/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.joda.time.chrono;

import com.amazonaws.org.joda.time.Chronology;
import com.amazonaws.org.joda.time.DateTimeField;
import com.amazonaws.org.joda.time.DateTimeZone;
import com.amazonaws.org.joda.time.DurationField;
import com.amazonaws.org.joda.time.IllegalFieldValueException;
import com.amazonaws.org.joda.time.IllegalInstantException;
import com.amazonaws.org.joda.time.chrono.AssembledChronology;
import com.amazonaws.org.joda.time.field.BaseDateTimeField;
import com.amazonaws.org.joda.time.field.BaseDurationField;
import java.util.HashMap;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZonedChronology
extends AssembledChronology {
    public static ZonedChronology getInstance(Chronology chronology, DateTimeZone dateTimeZone) {
        if (chronology == null) {
            throw new IllegalArgumentException("Must supply a chronology");
        }
        if ((chronology = chronology.withUTC()) == null) {
            throw new IllegalArgumentException("UTC chronology must not be null");
        }
        if (dateTimeZone == null) {
            throw new IllegalArgumentException("DateTimeZone must not be null");
        }
        return new ZonedChronology(chronology, dateTimeZone);
    }

    static boolean useTimeArithmetic(DurationField durationField) {
        return durationField != null && durationField.getUnitMillis() < 43200000L;
    }

    private ZonedChronology(Chronology chronology, DateTimeZone dateTimeZone) {
        super(chronology, dateTimeZone);
    }

    @Override
    public DateTimeZone getZone() {
        return (DateTimeZone)this.getParam();
    }

    @Override
    public Chronology withUTC() {
        return this.getBase();
    }

    @Override
    public Chronology withZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == this.getParam()) {
            return this;
        }
        if (dateTimeZone == DateTimeZone.UTC) {
            return this.getBase();
        }
        return new ZonedChronology(this.getBase(), dateTimeZone);
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        fields.eras = this.convertField(fields.eras, hashMap);
        fields.centuries = this.convertField(fields.centuries, hashMap);
        fields.years = this.convertField(fields.years, hashMap);
        fields.months = this.convertField(fields.months, hashMap);
        fields.weekyears = this.convertField(fields.weekyears, hashMap);
        fields.weeks = this.convertField(fields.weeks, hashMap);
        fields.days = this.convertField(fields.days, hashMap);
        fields.halfdays = this.convertField(fields.halfdays, hashMap);
        fields.hours = this.convertField(fields.hours, hashMap);
        fields.minutes = this.convertField(fields.minutes, hashMap);
        fields.seconds = this.convertField(fields.seconds, hashMap);
        fields.millis = this.convertField(fields.millis, hashMap);
        fields.year = this.convertField(fields.year, hashMap);
        fields.yearOfEra = this.convertField(fields.yearOfEra, hashMap);
        fields.yearOfCentury = this.convertField(fields.yearOfCentury, hashMap);
        fields.centuryOfEra = this.convertField(fields.centuryOfEra, hashMap);
        fields.era = this.convertField(fields.era, hashMap);
        fields.dayOfWeek = this.convertField(fields.dayOfWeek, hashMap);
        fields.dayOfMonth = this.convertField(fields.dayOfMonth, hashMap);
        fields.dayOfYear = this.convertField(fields.dayOfYear, hashMap);
        fields.monthOfYear = this.convertField(fields.monthOfYear, hashMap);
        fields.weekOfWeekyear = this.convertField(fields.weekOfWeekyear, hashMap);
        fields.weekyear = this.convertField(fields.weekyear, hashMap);
        fields.weekyearOfCentury = this.convertField(fields.weekyearOfCentury, hashMap);
        fields.millisOfSecond = this.convertField(fields.millisOfSecond, hashMap);
        fields.millisOfDay = this.convertField(fields.millisOfDay, hashMap);
        fields.secondOfMinute = this.convertField(fields.secondOfMinute, hashMap);
        fields.secondOfDay = this.convertField(fields.secondOfDay, hashMap);
        fields.minuteOfHour = this.convertField(fields.minuteOfHour, hashMap);
        fields.minuteOfDay = this.convertField(fields.minuteOfDay, hashMap);
        fields.hourOfDay = this.convertField(fields.hourOfDay, hashMap);
        fields.hourOfHalfday = this.convertField(fields.hourOfHalfday, hashMap);
        fields.clockhourOfDay = this.convertField(fields.clockhourOfDay, hashMap);
        fields.clockhourOfHalfday = this.convertField(fields.clockhourOfHalfday, hashMap);
        fields.halfdayOfDay = this.convertField(fields.halfdayOfDay, hashMap);
    }

    private DurationField convertField(DurationField durationField, HashMap<Object, Object> hashMap) {
        if (durationField == null || !durationField.isSupported()) {
            return durationField;
        }
        if (hashMap.containsKey(durationField)) {
            return (DurationField)hashMap.get(durationField);
        }
        ZonedDurationField zonedDurationField = new ZonedDurationField(durationField, this.getZone());
        hashMap.put(durationField, zonedDurationField);
        return zonedDurationField;
    }

    private DateTimeField convertField(DateTimeField dateTimeField, HashMap<Object, Object> hashMap) {
        if (dateTimeField == null || !dateTimeField.isSupported()) {
            return dateTimeField;
        }
        if (hashMap.containsKey(dateTimeField)) {
            return (DateTimeField)hashMap.get(dateTimeField);
        }
        ZonedDateTimeField zonedDateTimeField = new ZonedDateTimeField(dateTimeField, this.getZone(), this.convertField(dateTimeField.getDurationField(), hashMap), this.convertField(dateTimeField.getRangeDurationField(), hashMap), this.convertField(dateTimeField.getLeapDurationField(), hashMap));
        hashMap.put(dateTimeField, zonedDateTimeField);
        return zonedDateTimeField;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ZonedChronology)) {
            return false;
        }
        ZonedChronology zonedChronology = (ZonedChronology)object;
        return this.getBase().equals(zonedChronology.getBase()) && this.getZone().equals(zonedChronology.getZone());
    }

    public int hashCode() {
        return 326565 + this.getZone().hashCode() * 11 + this.getBase().hashCode() * 7;
    }

    public String toString() {
        return "ZonedChronology[" + this.getBase() + ", " + this.getZone().getID() + ']';
    }

    static final class ZonedDateTimeField
    extends BaseDateTimeField {
        final DateTimeField iField;
        final DateTimeZone iZone;
        final DurationField iDurationField;
        final boolean iTimeField;
        final DurationField iRangeDurationField;
        final DurationField iLeapDurationField;

        ZonedDateTimeField(DateTimeField dateTimeField, DateTimeZone dateTimeZone, DurationField durationField, DurationField durationField2, DurationField durationField3) {
            super(dateTimeField.getType());
            if (!dateTimeField.isSupported()) {
                throw new IllegalArgumentException();
            }
            this.iField = dateTimeField;
            this.iZone = dateTimeZone;
            this.iDurationField = durationField;
            this.iTimeField = ZonedChronology.useTimeArithmetic(durationField);
            this.iRangeDurationField = durationField2;
            this.iLeapDurationField = durationField3;
        }

        public int get(long l) {
            long l2 = this.iZone.convertUTCToLocal(l);
            return this.iField.get(l2);
        }

        public String getAsText(long l, Locale locale) {
            long l2 = this.iZone.convertUTCToLocal(l);
            return this.iField.getAsText(l2, locale);
        }

        public String getAsShortText(long l, Locale locale) {
            long l2 = this.iZone.convertUTCToLocal(l);
            return this.iField.getAsShortText(l2, locale);
        }

        public String getAsText(int n, Locale locale) {
            return this.iField.getAsText(n, locale);
        }

        public String getAsShortText(int n, Locale locale) {
            return this.iField.getAsShortText(n, locale);
        }

        public long add(long l, int n) {
            if (this.iTimeField) {
                int n2 = this.getOffsetToAdd(l);
                long l2 = this.iField.add(l + (long)n2, n);
                return l2 - (long)n2;
            }
            long l3 = this.iZone.convertUTCToLocal(l);
            l3 = this.iField.add(l3, n);
            return this.iZone.convertLocalToUTC(l3, false, l);
        }

        public long add(long l, long l2) {
            if (this.iTimeField) {
                int n = this.getOffsetToAdd(l);
                long l3 = this.iField.add(l + (long)n, l2);
                return l3 - (long)n;
            }
            long l4 = this.iZone.convertUTCToLocal(l);
            l4 = this.iField.add(l4, l2);
            return this.iZone.convertLocalToUTC(l4, false, l);
        }

        public long set(long l, int n) {
            long l2 = this.iZone.convertUTCToLocal(l);
            long l3 = this.iZone.convertLocalToUTC(l2 = this.iField.set(l2, n), false, l);
            if (this.get(l3) != n) {
                IllegalInstantException illegalInstantException = new IllegalInstantException(l2, this.iZone.getID());
                IllegalFieldValueException illegalFieldValueException = new IllegalFieldValueException(this.iField.getType(), n, illegalInstantException.getMessage());
                illegalFieldValueException.initCause(illegalInstantException);
                throw illegalFieldValueException;
            }
            return l3;
        }

        public long set(long l, String string, Locale locale) {
            long l2 = this.iZone.convertUTCToLocal(l);
            l2 = this.iField.set(l2, string, locale);
            return this.iZone.convertLocalToUTC(l2, false, l);
        }

        public final DurationField getDurationField() {
            return this.iDurationField;
        }

        public final DurationField getRangeDurationField() {
            return this.iRangeDurationField;
        }

        public boolean isLeap(long l) {
            long l2 = this.iZone.convertUTCToLocal(l);
            return this.iField.isLeap(l2);
        }

        public final DurationField getLeapDurationField() {
            return this.iLeapDurationField;
        }

        public long roundFloor(long l) {
            if (this.iTimeField) {
                int n = this.getOffsetToAdd(l);
                l = this.iField.roundFloor(l + (long)n);
                return l - (long)n;
            }
            long l2 = this.iZone.convertUTCToLocal(l);
            l2 = this.iField.roundFloor(l2);
            return this.iZone.convertLocalToUTC(l2, false, l);
        }

        public long roundCeiling(long l) {
            if (this.iTimeField) {
                int n = this.getOffsetToAdd(l);
                l = this.iField.roundCeiling(l + (long)n);
                return l - (long)n;
            }
            long l2 = this.iZone.convertUTCToLocal(l);
            l2 = this.iField.roundCeiling(l2);
            return this.iZone.convertLocalToUTC(l2, false, l);
        }

        public long remainder(long l) {
            long l2 = this.iZone.convertUTCToLocal(l);
            return this.iField.remainder(l2);
        }

        public int getMinimumValue() {
            return this.iField.getMinimumValue();
        }

        public int getMaximumValue() {
            return this.iField.getMaximumValue();
        }

        public int getMaximumValue(long l) {
            long l2 = this.iZone.convertUTCToLocal(l);
            return this.iField.getMaximumValue(l2);
        }

        public int getMaximumTextLength(Locale locale) {
            return this.iField.getMaximumTextLength(locale);
        }

        private int getOffsetToAdd(long l) {
            int n = this.iZone.getOffset(l);
            long l2 = l + (long)n;
            if ((l ^ l2) < 0L && (l ^ (long)n) >= 0L) {
                throw new ArithmeticException("Adding time zone offset caused overflow");
            }
            return n;
        }
    }

    static class ZonedDurationField
    extends BaseDurationField {
        final DurationField iField;
        final boolean iTimeField;
        final DateTimeZone iZone;

        ZonedDurationField(DurationField durationField, DateTimeZone dateTimeZone) {
            super(durationField.getType());
            if (!durationField.isSupported()) {
                throw new IllegalArgumentException();
            }
            this.iField = durationField;
            this.iTimeField = ZonedChronology.useTimeArithmetic(durationField);
            this.iZone = dateTimeZone;
        }

        public boolean isPrecise() {
            return this.iTimeField ? this.iField.isPrecise() : this.iField.isPrecise() && this.iZone.isFixed();
        }

        public long getUnitMillis() {
            return this.iField.getUnitMillis();
        }

        public long add(long l, int n) {
            int n2 = this.getOffsetToAdd(l);
            l = this.iField.add(l + (long)n2, n);
            return l - (long)(this.iTimeField ? n2 : this.getOffsetFromLocalToSubtract(l));
        }

        public long add(long l, long l2) {
            int n = this.getOffsetToAdd(l);
            l = this.iField.add(l + (long)n, l2);
            return l - (long)(this.iTimeField ? n : this.getOffsetFromLocalToSubtract(l));
        }

        private int getOffsetToAdd(long l) {
            int n = this.iZone.getOffset(l);
            long l2 = l + (long)n;
            if ((l ^ l2) < 0L && (l ^ (long)n) >= 0L) {
                throw new ArithmeticException("Adding time zone offset caused overflow");
            }
            return n;
        }

        private int getOffsetFromLocalToSubtract(long l) {
            int n = this.iZone.getOffsetFromLocal(l);
            long l2 = l - (long)n;
            if ((l ^ l2) < 0L && (l ^ (long)n) < 0L) {
                throw new ArithmeticException("Subtracting time zone offset caused overflow");
            }
            return n;
        }
    }
}

