/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.joda.time.chrono;

import com.amazonaws.org.joda.time.Chronology;
import com.amazonaws.org.joda.time.DateTimeFieldType;
import com.amazonaws.org.joda.time.DateTimeZone;
import com.amazonaws.org.joda.time.chrono.AssembledChronology;
import com.amazonaws.org.joda.time.chrono.GregorianChronology;
import com.amazonaws.org.joda.time.chrono.ISOYearOfEraDateTimeField;
import com.amazonaws.org.joda.time.chrono.ZonedChronology;
import com.amazonaws.org.joda.time.field.DividedDateTimeField;
import com.amazonaws.org.joda.time.field.RemainderDateTimeField;
import java.util.HashMap;
import java.util.Map;

public final class ISOChronology
extends AssembledChronology {
    private static final ISOChronology INSTANCE_UTC;
    private static final ISOChronology[] cFastCache;
    private static final Map<DateTimeZone, ISOChronology> cCache;

    public static ISOChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static ISOChronology getInstance() {
        return ISOChronology.getInstance(DateTimeZone.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISOChronology getInstance(DateTimeZone dateTimeZone) {
        int n;
        ISOChronology iSOChronology;
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if ((iSOChronology = cFastCache[n = System.identityHashCode(dateTimeZone) & 0x3F]) != null && iSOChronology.getZone() == dateTimeZone) {
            return iSOChronology;
        }
        Map<DateTimeZone, ISOChronology> map = cCache;
        synchronized (map) {
            iSOChronology = cCache.get(dateTimeZone);
            if (iSOChronology == null) {
                iSOChronology = new ISOChronology(ZonedChronology.getInstance(INSTANCE_UTC, dateTimeZone));
                cCache.put(dateTimeZone, iSOChronology);
            }
        }
        ISOChronology.cFastCache[n] = iSOChronology;
        return iSOChronology;
    }

    private ISOChronology(Chronology chronology) {
        super(chronology, null);
    }

    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    public Chronology withZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == this.getZone()) {
            return this;
        }
        return ISOChronology.getInstance(dateTimeZone);
    }

    public String toString() {
        String string = "ISOChronology";
        DateTimeZone dateTimeZone = this.getZone();
        if (dateTimeZone != null) {
            string = string + '[' + dateTimeZone.getID() + ']';
        }
        return string;
    }

    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getBase().getZone() == DateTimeZone.UTC) {
            fields.centuryOfEra = new DividedDateTimeField(ISOYearOfEraDateTimeField.INSTANCE, DateTimeFieldType.centuryOfEra(), 100);
            fields.yearOfCentury = new RemainderDateTimeField((DividedDateTimeField)fields.centuryOfEra, DateTimeFieldType.yearOfCentury());
            fields.weekyearOfCentury = new RemainderDateTimeField((DividedDateTimeField)fields.centuryOfEra, DateTimeFieldType.weekyearOfCentury());
            fields.centuries = fields.centuryOfEra.getDurationField();
        }
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return "ISO".hashCode() * 11 + this.getZone().hashCode();
    }

    static {
        cCache = new HashMap<DateTimeZone, ISOChronology>();
        cFastCache = new ISOChronology[64];
        INSTANCE_UTC = new ISOChronology(GregorianChronology.getInstanceUTC());
        cCache.put(DateTimeZone.UTC, INSTANCE_UTC);
    }
}

