/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.apache.http.impl.cookie;

import com.amazonaws.org.apache.http.Header;
import com.amazonaws.org.apache.http.HeaderElement;
import com.amazonaws.org.apache.http.NameValuePair;
import com.amazonaws.org.apache.http.cookie.ClientCookie;
import com.amazonaws.org.apache.http.cookie.Cookie;
import com.amazonaws.org.apache.http.cookie.CookieAttributeHandler;
import com.amazonaws.org.apache.http.cookie.CookieOrigin;
import com.amazonaws.org.apache.http.cookie.MalformedCookieException;
import com.amazonaws.org.apache.http.impl.cookie.BasicClientCookie2;
import com.amazonaws.org.apache.http.impl.cookie.RFC2109Spec;
import com.amazonaws.org.apache.http.impl.cookie.RFC2965CommentUrlAttributeHandler;
import com.amazonaws.org.apache.http.impl.cookie.RFC2965DiscardAttributeHandler;
import com.amazonaws.org.apache.http.impl.cookie.RFC2965DomainAttributeHandler;
import com.amazonaws.org.apache.http.impl.cookie.RFC2965PortAttributeHandler;
import com.amazonaws.org.apache.http.impl.cookie.RFC2965VersionAttributeHandler;
import com.amazonaws.org.apache.http.message.BufferedHeader;
import com.amazonaws.org.apache.http.util.CharArrayBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RFC2965Spec
extends RFC2109Spec {
    public RFC2965Spec() {
        this(null, false);
    }

    public RFC2965Spec(String[] datepatterns, boolean oneHeader) {
        super(datepatterns, oneHeader);
        this.registerAttribHandler("domain", new RFC2965DomainAttributeHandler());
        this.registerAttribHandler("port", new RFC2965PortAttributeHandler());
        this.registerAttribHandler("commenturl", new RFC2965CommentUrlAttributeHandler());
        this.registerAttribHandler("discard", new RFC2965DiscardAttributeHandler());
        this.registerAttribHandler("version", new RFC2965VersionAttributeHandler());
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        if (header == null) {
            throw new IllegalArgumentException("Header may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        if (!header.getName().equalsIgnoreCase("Set-Cookie2")) {
            throw new MalformedCookieException("Unrecognized cookie header '" + header.toString() + "'");
        }
        origin = RFC2965Spec.adjustEffectiveHost(origin);
        HeaderElement[] elems = header.getElements();
        return this.createCookies(elems, origin);
    }

    @Override
    protected List<Cookie> parse(HeaderElement[] elems, CookieOrigin origin) throws MalformedCookieException {
        origin = RFC2965Spec.adjustEffectiveHost(origin);
        return this.createCookies(elems, origin);
    }

    private List<Cookie> createCookies(HeaderElement[] elems, CookieOrigin origin) throws MalformedCookieException {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(elems.length);
        for (HeaderElement headerelement : elems) {
            String name = headerelement.getName();
            String value = headerelement.getValue();
            if (name == null || name.length() == 0) {
                throw new MalformedCookieException("Cookie name may not be empty");
            }
            BasicClientCookie2 cookie = new BasicClientCookie2(name, value);
            cookie.setPath(RFC2965Spec.getDefaultPath(origin));
            cookie.setDomain(RFC2965Spec.getDefaultDomain(origin));
            cookie.setPorts(new int[]{origin.getPort()});
            NameValuePair[] attribs = headerelement.getParameters();
            HashMap<String, NameValuePair> attribmap = new HashMap<String, NameValuePair>(attribs.length);
            for (int j = attribs.length - 1; j >= 0; --j) {
                NameValuePair param = attribs[j];
                attribmap.put(param.getName().toLowerCase(Locale.ENGLISH), param);
            }
            for (Map.Entry entry : attribmap.entrySet()) {
                NameValuePair attrib = (NameValuePair)entry.getValue();
                String s = attrib.getName().toLowerCase(Locale.ENGLISH);
                cookie.setAttribute(s, attrib.getValue());
                CookieAttributeHandler handler = this.findAttribHandler(s);
                if (handler == null) continue;
                handler.parse(cookie, attrib.getValue());
            }
            cookies.add(cookie);
        }
        return cookies;
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (cookieOrigin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        cookieOrigin = RFC2965Spec.adjustEffectiveHost(cookieOrigin);
        super.validate(cookie, cookieOrigin);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (cookieOrigin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        cookieOrigin = RFC2965Spec.adjustEffectiveHost(cookieOrigin);
        return super.match(cookie, cookieOrigin);
    }

    @Override
    protected void formatCookieAsVer(CharArrayBuffer charArrayBuffer, Cookie cookie, int n) {
        String string;
        super.formatCookieAsVer(charArrayBuffer, cookie, n);
        if (cookie instanceof ClientCookie && (string = ((ClientCookie)cookie).getAttribute("port")) != null) {
            int[] nArray;
            charArrayBuffer.append("; $Port");
            charArrayBuffer.append("=\"");
            if (string.trim().length() > 0 && (nArray = cookie.getPorts()) != null) {
                int n2 = nArray.length;
                for (int i = 0; i < n2; ++i) {
                    if (i > 0) {
                        charArrayBuffer.append(",");
                    }
                    charArrayBuffer.append(Integer.toString(nArray[i]));
                }
            }
            charArrayBuffer.append("\"");
        }
    }

    private static CookieOrigin adjustEffectiveHost(CookieOrigin cookieOrigin) {
        String string = cookieOrigin.getHost();
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '.' && c != ':') continue;
            bl = false;
            break;
        }
        if (bl) {
            string = string + ".local";
            return new CookieOrigin(string, cookieOrigin.getPort(), cookieOrigin.getPath(), cookieOrigin.isSecure());
        }
        return cookieOrigin;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public Header getVersionHeader() {
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(40);
        charArrayBuffer.append("Cookie2");
        charArrayBuffer.append(": ");
        charArrayBuffer.append("$Version=");
        charArrayBuffer.append(Integer.toString(this.getVersion()));
        return new BufferedHeader(charArrayBuffer);
    }

    @Override
    public String toString() {
        return "rfc2965";
    }
}

