/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics;

import com.amazonaws.internal.MetricAware;
import com.amazonaws.metrics.ByteThroughputHelper;
import com.amazonaws.metrics.ThroughputMetricType;
import com.amazonaws.org.apache.http.entity.ContentType;
import com.amazonaws.org.apache.http.entity.InputStreamEntity;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MetricInputStreamEntity
extends InputStreamEntity {
    private static final int BUFFER_SIZE = 2048;
    private final ByteThroughputHelper helper;

    public MetricInputStreamEntity(ThroughputMetricType throughputMetricType, InputStream inputStream, long l) {
        super(inputStream, l);
        this.helper = new ByteThroughputHelper(throughputMetricType);
    }

    public MetricInputStreamEntity(ThroughputMetricType throughputMetricType, InputStream inputStream, long l, ContentType contentType) {
        super(inputStream, l, contentType);
        this.helper = new ByteThroughputHelper(throughputMetricType);
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        MetricAware metricAware;
        if (outputStream instanceof MetricAware && (metricAware = (MetricAware)((Object)outputStream)).isMetricActivated()) {
            super.writeTo(outputStream);
            return;
        }
        this.writeToWithMetrics(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToWithMetrics(OutputStream outputStream) throws IOException {
        block8: {
            if (outputStream == null) {
                throw new IllegalArgumentException("Output stream may not be null");
            }
            InputStream inputStream = this.getContent();
            long l = this.getContentLength();
            InputStream inputStream2 = inputStream;
            try {
                int n;
                byte[] byArray = new byte[2048];
                if (l < 0L) {
                    int n2;
                    while ((n2 = inputStream2.read(byArray)) != -1) {
                        long l2 = this.helper.startTiming();
                        outputStream.write(byArray, 0, n2);
                        this.helper.increment(n2, l2);
                    }
                    break block8;
                }
                for (long i = l; i > 0L; i -= (long)n) {
                    n = inputStream2.read(byArray, 0, (int)Math.min(2048L, i));
                    if (n == -1) {
                        break;
                    }
                    long l3 = this.helper.startTiming();
                    outputStream.write(byArray, 0, n);
                    this.helper.increment(n, l3);
                }
            }
            finally {
                this.helper.reportMetrics();
                inputStream2.close();
            }
        }
    }
}

