/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics;

import com.amazonaws.metrics.ThroughputMetricType;

public abstract class ByteThroughputProvider {
    private long duration;
    private int byteCount;
    private final ThroughputMetricType throughputType;

    protected ByteThroughputProvider(ThroughputMetricType throughputMetricType) {
        this.throughputType = throughputMetricType;
    }

    public ThroughputMetricType getThroughputMetricType() {
        return this.throughputType;
    }

    public int getByteCount() {
        return this.byteCount;
    }

    public long getDurationNano() {
        return this.duration;
    }

    public String getProviderId() {
        return super.toString();
    }

    protected void increment(int n, long l) {
        this.byteCount += n;
        this.duration += System.nanoTime() - l;
    }

    protected void reset() {
        this.byteCount = 0;
        this.duration = 0L;
    }

    public String toString() {
        return String.format("providerId=%s, throughputType=%s, byteCount=%d, duration=%d", this.getProviderId(), this.throughputType, this.byteCount, this.duration);
    }
}

