/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.javax.xml.stream.XMLEventReader;
import com.amazonaws.javax.xml.stream.XMLInputFactory;
import com.amazonaws.javax.xml.stream.XMLStreamException;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.transform.VoidStaxUnmarshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class StaxResponseHandler<T>
implements HttpResponseHandler<AmazonWebServiceResponse<T>> {
    private Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller;
    private static final Log log = LogFactory.getLog("com.amazonaws.request");
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    public StaxResponseHandler(Unmarshaller<T, StaxUnmarshallerContext> unmarshaller) {
        this.responseUnmarshaller = unmarshaller;
        if (this.responseUnmarshaller == null) {
            this.responseUnmarshaller = new VoidStaxUnmarshaller();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmazonWebServiceResponse<T> handle(HttpResponse httpResponse) throws Exception {
        XMLEventReader xMLEventReader;
        log.trace("Parsing service response XML");
        InputStream inputStream = httpResponse.getContent();
        if (inputStream == null) {
            inputStream = new ByteArrayInputStream("<eof/>".getBytes());
        }
        Object object = xmlInputFactory;
        synchronized (object) {
            xMLEventReader = xmlInputFactory.createXMLEventReader(inputStream);
        }
        try {
            object = new AmazonWebServiceResponse();
            StaxUnmarshallerContext staxUnmarshallerContext = new StaxUnmarshallerContext(xMLEventReader, httpResponse.getHeaders());
            staxUnmarshallerContext.registerMetadataExpression("ResponseMetadata/RequestId", 2, "AWS_REQUEST_ID");
            staxUnmarshallerContext.registerMetadataExpression("requestId", 2, "AWS_REQUEST_ID");
            this.registerAdditionalMetadataExpressions(staxUnmarshallerContext);
            T t = this.responseUnmarshaller.unmarshall(staxUnmarshallerContext);
            ((AmazonWebServiceResponse)object).setResult(t);
            Map<String, String> map = staxUnmarshallerContext.getMetadata();
            Map<String, String> map2 = httpResponse.getHeaders();
            if (map2 != null && map2.get("x-amzn-RequestId") != null) {
                map.put("AWS_REQUEST_ID", map2.get("x-amzn-RequestId"));
            }
            ((AmazonWebServiceResponse)object).setResponseMetadata(new ResponseMetadata(map));
            log.trace("Done parsing service response");
            Object object2 = object;
            return object2;
        }
        finally {
            try {
                xMLEventReader.close();
            }
            catch (XMLStreamException xMLStreamException) {
                log.warn("Error closing xml parser", xMLStreamException);
            }
        }
    }

    protected void registerAdditionalMetadataExpressions(StaxUnmarshallerContext staxUnmarshallerContext) {
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

