/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.RepeatableInputStreamRequestEntity;
import com.amazonaws.org.apache.http.HttpEntity;
import com.amazonaws.org.apache.http.client.methods.HttpDelete;
import com.amazonaws.org.apache.http.client.methods.HttpGet;
import com.amazonaws.org.apache.http.client.methods.HttpHead;
import com.amazonaws.org.apache.http.client.methods.HttpPatch;
import com.amazonaws.org.apache.http.client.methods.HttpPost;
import com.amazonaws.org.apache.http.client.methods.HttpPut;
import com.amazonaws.org.apache.http.client.methods.HttpRequestBase;
import com.amazonaws.org.apache.http.entity.BufferedHttpEntity;
import com.amazonaws.org.apache.http.entity.StringEntity;
import com.amazonaws.util.HttpUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Map;

class HttpRequestFactory {
    private static final String DEFAULT_ENCODING = "UTF-8";

    HttpRequestFactory() {
    }

    HttpRequestBase createHttpRequest(Request<?> request, ClientConfiguration clientConfiguration, ExecutionContext executionContext) {
        HttpRequestBase httpRequestBase;
        boolean bl;
        URI uRI = request.getEndpoint();
        String string = HttpUtils.appendUri(uRI.toString(), request.getResourcePath(), true);
        String string2 = HttpUtils.encodeParameters(request);
        boolean bl2 = request.getContent() != null;
        boolean bl3 = request.getHttpMethod() == HttpMethodName.POST;
        boolean bl4 = bl = !bl3 || bl2;
        if (string2 != null && bl) {
            string = string + "?" + string2;
        }
        if (request.getHttpMethod() == HttpMethodName.POST) {
            HttpPost httpPost = new HttpPost(string);
            if (request.getContent() == null && string2 != null) {
                httpPost.setEntity(this.newStringEntity(string2));
            } else {
                httpPost.setEntity(new RepeatableInputStreamRequestEntity(request));
            }
            httpRequestBase = httpPost;
        } else if (request.getHttpMethod() == HttpMethodName.PUT) {
            HttpPut httpPut;
            httpRequestBase = httpPut = new HttpPut(string);
            httpPut.getParams().setParameter("http.protocol.expect-continue", true);
            if (request.getContent() != null) {
                HttpEntity httpEntity = new RepeatableInputStreamRequestEntity(request);
                if (request.getHeaders().get("Content-Length") == null) {
                    httpEntity = this.newBufferedHttpEntity(httpEntity);
                }
                httpPut.setEntity(httpEntity);
            }
        } else if (request.getHttpMethod() == HttpMethodName.PATCH) {
            HttpPatch httpPatch = new HttpPatch(string);
            httpRequestBase = httpPatch;
            if (request.getContent() != null) {
                HttpEntity httpEntity = new RepeatableInputStreamRequestEntity(request);
                if (request.getHeaders().get("Content-Length") == null) {
                    httpEntity = this.newBufferedHttpEntity(httpEntity);
                }
                httpPatch.setEntity(httpEntity);
            }
        } else if (request.getHttpMethod() == HttpMethodName.GET) {
            httpRequestBase = new HttpGet(string);
        } else if (request.getHttpMethod() == HttpMethodName.DELETE) {
            httpRequestBase = new HttpDelete(string);
        } else if (request.getHttpMethod() == HttpMethodName.HEAD) {
            httpRequestBase = new HttpHead(string);
        } else {
            throw new AmazonClientException("Unknown HTTP method name: " + (Object)((Object)request.getHttpMethod()));
        }
        this.configureHeaders(httpRequestBase, request, executionContext, clientConfiguration);
        return httpRequestBase;
    }

    private void configureHeaders(HttpRequestBase httpRequestBase, Request<?> request, ExecutionContext executionContext, ClientConfiguration clientConfiguration) {
        URI uRI = request.getEndpoint();
        String string = uRI.getHost();
        if (HttpUtils.isUsingNonDefaultPort(uRI)) {
            string = string + ":" + uRI.getPort();
        }
        httpRequestBase.addHeader("Host", string);
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length") || entry.getKey().equalsIgnoreCase("Host")) continue;
            httpRequestBase.addHeader(entry.getKey(), entry.getValue());
        }
        if (httpRequestBase.getHeaders("Content-Type") == null || httpRequestBase.getHeaders("Content-Type").length == 0) {
            httpRequestBase.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + DEFAULT_ENCODING.toLowerCase());
        }
        if (executionContext != null && executionContext.getContextUserAgent() != null) {
            httpRequestBase.addHeader("User-Agent", this.createUserAgentString(clientConfiguration, executionContext.getContextUserAgent()));
        }
    }

    private String createUserAgentString(ClientConfiguration clientConfiguration, String string) {
        if (clientConfiguration.getUserAgent().contains(string)) {
            return clientConfiguration.getUserAgent();
        }
        return clientConfiguration.getUserAgent() + " " + string;
    }

    private HttpEntity newStringEntity(String string) {
        try {
            return new StringEntity(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AmazonClientException("Unable to create HTTP entity: " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    private HttpEntity newBufferedHttpEntity(HttpEntity httpEntity) {
        try {
            return new BufferedHttpEntity(httpEntity);
        }
        catch (IOException iOException) {
            throw new AmazonClientException("Unable to create HTTP entity: " + iOException.getMessage(), iOException);
        }
    }
}

