/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.handlers;

import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.TimingInfo;

final class RequestHandler2Adaptor
extends RequestHandler2 {
    private final RequestHandler old;

    RequestHandler2Adaptor(RequestHandler requestHandler) {
        if (requestHandler == null) {
            throw new IllegalArgumentException();
        }
        this.old = requestHandler;
    }

    @Override
    public void beforeRequest(Request<?> request) {
        this.old.beforeRequest(request);
    }

    @Override
    public void afterResponse(Request<?> request, Response<?> response) {
        AWSRequestMetrics aWSRequestMetrics = request == null ? null : request.getAWSRequestMetrics();
        Object var4_4 = response == null ? null : response.getAwsResponse();
        TimingInfo timingInfo = aWSRequestMetrics == null ? null : aWSRequestMetrics.getTimingInfo();
        this.old.afterResponse(request, var4_4, timingInfo);
    }

    @Override
    public void afterError(Request<?> request, Response<?> response, Exception exception) {
        this.old.afterError(request, exception);
    }

    public int hashCode() {
        return this.old.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof RequestHandler2Adaptor)) {
            return false;
        }
        RequestHandler2Adaptor requestHandler2Adaptor = (RequestHandler2Adaptor)object;
        return this.old.equals(requestHandler2Adaptor.old);
    }
}

