/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.util;

import com.amazonaws.com.fasterxml.jackson.core.Base64Variant;
import com.amazonaws.com.fasterxml.jackson.core.JsonGenerationException;
import com.amazonaws.com.fasterxml.jackson.core.JsonGenerator;
import com.amazonaws.com.fasterxml.jackson.core.JsonLocation;
import com.amazonaws.com.fasterxml.jackson.core.JsonParseException;
import com.amazonaws.com.fasterxml.jackson.core.JsonParser;
import com.amazonaws.com.fasterxml.jackson.core.JsonProcessingException;
import com.amazonaws.com.fasterxml.jackson.core.JsonToken;
import com.amazonaws.com.fasterxml.jackson.core.ObjectCodec;
import com.amazonaws.com.fasterxml.jackson.core.SerializableString;
import com.amazonaws.com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.amazonaws.com.fasterxml.jackson.core.json.JsonReadContext;
import com.amazonaws.com.fasterxml.jackson.core.json.JsonWriteContext;
import com.amazonaws.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class TokenBuffer
extends JsonGenerator {
    protected static final int DEFAULT_PARSER_FEATURES = JsonParser.Feature.collectDefaults();
    protected ObjectCodec _objectCodec;
    protected int _generatorFeatures;
    protected boolean _closed;
    protected Segment _first;
    protected Segment _last;
    protected int _appendOffset;
    protected JsonWriteContext _writeContext;

    public TokenBuffer(ObjectCodec codec) {
        this._objectCodec = codec;
        this._generatorFeatures = DEFAULT_PARSER_FEATURES;
        this._writeContext = JsonWriteContext.createRootContext();
        this._first = this._last = new Segment();
        this._appendOffset = 0;
    }

    public JsonParser asParser() {
        return this.asParser(this._objectCodec);
    }

    public JsonParser asParser(ObjectCodec codec) {
        return new Parser(this._first, codec);
    }

    public JsonParser asParser(JsonParser src) {
        Parser p = new Parser(this._first, src.getCodec());
        p.setLocation(src.getTokenLocation());
        return p;
    }

    public TokenBuffer append(TokenBuffer other) throws IOException, JsonGenerationException {
        JsonParser jp = other.asParser();
        while (jp.nextToken() != null) {
            this.copyCurrentEvent(jp);
        }
        return this;
    }

    public void serialize(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
        Segment segment = this._first;
        int n = -1;
        while (true) {
            JsonToken jsonToken;
            if (++n >= 16) {
                n = 0;
                if ((segment = segment.next()) == null) break;
            }
            if ((jsonToken = segment.type(n)) == null) break;
            switch (jsonToken) {
                case START_OBJECT: {
                    jsonGenerator.writeStartObject();
                    break;
                }
                case END_OBJECT: {
                    jsonGenerator.writeEndObject();
                    break;
                }
                case START_ARRAY: {
                    jsonGenerator.writeStartArray();
                    break;
                }
                case END_ARRAY: {
                    jsonGenerator.writeEndArray();
                    break;
                }
                case FIELD_NAME: {
                    Object object = segment.get(n);
                    if (object instanceof SerializableString) {
                        jsonGenerator.writeFieldName((SerializableString)object);
                        break;
                    }
                    jsonGenerator.writeFieldName((String)object);
                    break;
                }
                case VALUE_STRING: {
                    Object object = segment.get(n);
                    if (object instanceof SerializableString) {
                        jsonGenerator.writeString((SerializableString)object);
                        break;
                    }
                    jsonGenerator.writeString((String)object);
                    break;
                }
                case VALUE_NUMBER_INT: {
                    Object object = (Number)segment.get(n);
                    if (object instanceof BigInteger) {
                        jsonGenerator.writeNumber((BigInteger)object);
                        break;
                    }
                    if (object instanceof Long) {
                        jsonGenerator.writeNumber(((Number)object).longValue());
                        break;
                    }
                    jsonGenerator.writeNumber(((Number)object).intValue());
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    Object object = segment.get(n);
                    if (object instanceof BigDecimal) {
                        jsonGenerator.writeNumber((BigDecimal)object);
                        break;
                    }
                    if (object instanceof Float) {
                        jsonGenerator.writeNumber(((Float)object).floatValue());
                        break;
                    }
                    if (object instanceof Double) {
                        jsonGenerator.writeNumber((Double)object);
                        break;
                    }
                    if (object == null) {
                        jsonGenerator.writeNull();
                        break;
                    }
                    if (object instanceof String) {
                        jsonGenerator.writeNumber((String)object);
                        break;
                    }
                    throw new JsonGenerationException("Unrecognized value type for VALUE_NUMBER_FLOAT: " + object.getClass().getName() + ", can not serialize");
                }
                case VALUE_TRUE: {
                    jsonGenerator.writeBoolean(true);
                    break;
                }
                case VALUE_FALSE: {
                    jsonGenerator.writeBoolean(false);
                    break;
                }
                case VALUE_NULL: {
                    jsonGenerator.writeNull();
                    break;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    jsonGenerator.writeObject(segment.get(n));
                    break;
                }
                default: {
                    throw new RuntimeException("Internal error: should never end up through this code path");
                }
            }
        }
    }

    public String toString() {
        int n = 100;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[TokenBuffer: ");
        JsonParser jsonParser = this.asParser();
        int n2 = 0;
        while (true) {
            try {
                JsonToken jsonToken = jsonParser.nextToken();
                if (jsonToken == null) break;
                if (n2 < 100) {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(jsonToken.toString());
                    if (jsonToken == JsonToken.FIELD_NAME) {
                        stringBuilder.append('(');
                        stringBuilder.append(jsonParser.getCurrentName());
                        stringBuilder.append(')');
                    }
                }
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
            ++n2;
        }
        if (n2 >= 100) {
            stringBuilder.append(" ... (truncated ").append(n2 - 100).append(" entries)");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        return this;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this._closed = true;
    }

    @Override
    public final void writeStartArray() throws IOException, JsonGenerationException {
        this._append(JsonToken.START_ARRAY);
        this._writeContext = this._writeContext.createChildArrayContext();
    }

    @Override
    public final void writeEndArray() throws IOException, JsonGenerationException {
        this._append(JsonToken.END_ARRAY);
        JsonWriteContext c = this._writeContext.getParent();
        if (c != null) {
            this._writeContext = c;
        }
    }

    @Override
    public final void writeStartObject() throws IOException, JsonGenerationException {
        this._append(JsonToken.START_OBJECT);
        this._writeContext = this._writeContext.createChildObjectContext();
    }

    @Override
    public final void writeEndObject() throws IOException, JsonGenerationException {
        this._append(JsonToken.END_OBJECT);
        JsonWriteContext c = this._writeContext.getParent();
        if (c != null) {
            this._writeContext = c;
        }
    }

    @Override
    public final void writeFieldName(String name) throws IOException, JsonGenerationException {
        this._append(JsonToken.FIELD_NAME, name);
        this._writeContext.writeFieldName(name);
    }

    @Override
    public void writeFieldName(SerializableString name) throws IOException, JsonGenerationException {
        this._append(JsonToken.FIELD_NAME, name);
        this._writeContext.writeFieldName(name.getValue());
    }

    @Override
    public void writeString(String text) throws IOException, JsonGenerationException {
        if (text == null) {
            this.writeNull();
        } else {
            this._append(JsonToken.VALUE_STRING, text);
        }
    }

    @Override
    public void writeString(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this.writeString(new String(text, offset, len));
    }

    @Override
    public void writeString(SerializableString text) throws IOException, JsonGenerationException {
        if (text == null) {
            this.writeNull();
        } else {
            this._append(JsonToken.VALUE_STRING, text);
        }
    }

    @Override
    public void writeRaw(String text) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(SerializableString text) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char c) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(String text) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeNumber(int i) throws IOException, JsonGenerationException {
        this._append(JsonToken.VALUE_NUMBER_INT, i);
    }

    @Override
    public void writeNumber(long l) throws IOException, JsonGenerationException {
        this._append(JsonToken.VALUE_NUMBER_INT, l);
    }

    @Override
    public void writeNumber(double d) throws IOException, JsonGenerationException {
        this._append(JsonToken.VALUE_NUMBER_FLOAT, d);
    }

    @Override
    public void writeNumber(float f) throws IOException, JsonGenerationException {
        this._append(JsonToken.VALUE_NUMBER_FLOAT, Float.valueOf(f));
    }

    @Override
    public void writeNumber(BigDecimal dec) throws IOException, JsonGenerationException {
        if (dec == null) {
            this.writeNull();
        } else {
            this._append(JsonToken.VALUE_NUMBER_FLOAT, dec);
        }
    }

    @Override
    public void writeNumber(BigInteger v) throws IOException, JsonGenerationException {
        if (v == null) {
            this.writeNull();
        } else {
            this._append(JsonToken.VALUE_NUMBER_INT, v);
        }
    }

    @Override
    public void writeNumber(String encodedValue) throws IOException, JsonGenerationException {
        this._append(JsonToken.VALUE_NUMBER_FLOAT, encodedValue);
    }

    @Override
    public void writeBoolean(boolean state) throws IOException, JsonGenerationException {
        this._append(state ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE);
    }

    @Override
    public void writeNull() throws IOException, JsonGenerationException {
        this._append(JsonToken.VALUE_NULL);
    }

    @Override
    public void writeObject(Object value) throws IOException, JsonProcessingException {
        this._append(JsonToken.VALUE_EMBEDDED_OBJECT, value);
    }

    @Override
    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException, JsonGenerationException {
        byte[] copy = new byte[len];
        System.arraycopy(data, offset, copy, 0, len);
        this.writeObject(copy);
    }

    public void copyCurrentEvent(JsonParser jsonParser) throws IOException, JsonProcessingException {
        block0 : switch (jsonParser.getCurrentToken()) {
            case START_OBJECT: {
                this.writeStartObject();
                break;
            }
            case END_OBJECT: {
                this.writeEndObject();
                break;
            }
            case START_ARRAY: {
                this.writeStartArray();
                break;
            }
            case END_ARRAY: {
                this.writeEndArray();
                break;
            }
            case FIELD_NAME: {
                this.writeFieldName(jsonParser.getCurrentName());
                break;
            }
            case VALUE_STRING: {
                if (jsonParser.hasTextCharacters()) {
                    this.writeString(jsonParser.getTextCharacters(), jsonParser.getTextOffset(), jsonParser.getTextLength());
                    break;
                }
                this.writeString(jsonParser.getText());
                break;
            }
            case VALUE_NUMBER_INT: {
                switch (jsonParser.getNumberType()) {
                    case INT: {
                        this.writeNumber(jsonParser.getIntValue());
                        break block0;
                    }
                    case BIG_INTEGER: {
                        this.writeNumber(jsonParser.getBigIntegerValue());
                        break block0;
                    }
                }
                this.writeNumber(jsonParser.getLongValue());
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                switch (jsonParser.getNumberType()) {
                    case BIG_DECIMAL: {
                        this.writeNumber(jsonParser.getDecimalValue());
                        break block0;
                    }
                    case FLOAT: {
                        this.writeNumber(jsonParser.getFloatValue());
                        break block0;
                    }
                }
                this.writeNumber(jsonParser.getDoubleValue());
                break;
            }
            case VALUE_TRUE: {
                this.writeBoolean(true);
                break;
            }
            case VALUE_FALSE: {
                this.writeBoolean(false);
                break;
            }
            case VALUE_NULL: {
                this.writeNull();
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                this.writeObject(jsonParser.getEmbeddedObject());
                break;
            }
            default: {
                throw new RuntimeException("Internal error: should never end up through this code path");
            }
        }
    }

    public void copyCurrentStructure(JsonParser jp) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.FIELD_NAME) {
            this.writeFieldName(jp.getCurrentName());
            t = jp.nextToken();
        }
        switch (t) {
            case START_ARRAY: {
                this.writeStartArray();
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    this.copyCurrentStructure(jp);
                }
                this.writeEndArray();
                break;
            }
            case START_OBJECT: {
                this.writeStartObject();
                while (jp.nextToken() != JsonToken.END_OBJECT) {
                    this.copyCurrentStructure(jp);
                }
                this.writeEndObject();
                break;
            }
            default: {
                this.copyCurrentEvent(jp);
            }
        }
    }

    protected final void _append(JsonToken type) {
        Segment next = this._last.append(this._appendOffset, type);
        if (next == null) {
            ++this._appendOffset;
        } else {
            this._last = next;
            this._appendOffset = 1;
        }
    }

    protected final void _append(JsonToken type, Object value) {
        Segment next = this._last.append(this._appendOffset, type, value);
        if (next == null) {
            ++this._appendOffset;
        } else {
            this._last = next;
            this._appendOffset = 1;
        }
    }

    protected void _reportUnsupportedOperation() {
        throw new UnsupportedOperationException("Called operation not supported for TokenBuffer");
    }

    protected static final class Segment {
        private static final JsonToken[] TOKEN_TYPES_BY_INDEX = new JsonToken[16];
        protected Segment _next;
        protected long _tokenTypes;
        protected final Object[] _tokens = new Object[16];

        public JsonToken type(int index) {
            long l = this._tokenTypes;
            if (index > 0) {
                l >>= index << 2;
            }
            int ix = (int)l & 0xF;
            return TOKEN_TYPES_BY_INDEX[ix];
        }

        public Object get(int index) {
            return this._tokens[index];
        }

        public Segment next() {
            return this._next;
        }

        public Segment append(int index, JsonToken tokenType) {
            if (index < 16) {
                this.set(index, tokenType);
                return null;
            }
            this._next = new Segment();
            this._next.set(0, tokenType);
            return this._next;
        }

        public Segment append(int index, JsonToken tokenType, Object value) {
            if (index < 16) {
                this.set(index, tokenType, value);
                return null;
            }
            this._next = new Segment();
            this._next.set(0, tokenType, value);
            return this._next;
        }

        public void set(int index, JsonToken tokenType) {
            long typeCode = tokenType.ordinal();
            if (index > 0) {
                typeCode <<= index << 2;
            }
            this._tokenTypes |= typeCode;
        }

        public void set(int index, JsonToken tokenType, Object value) {
            this._tokens[index] = value;
            long typeCode = tokenType.ordinal();
            if (index > 0) {
                typeCode <<= index << 2;
            }
            this._tokenTypes |= typeCode;
        }

        static {
            JsonToken[] t = JsonToken.values();
            System.arraycopy(t, 1, TOKEN_TYPES_BY_INDEX, 1, Math.min(15, t.length - 1));
        }
    }

    protected static final class Parser
    extends ParserMinimalBase {
        protected ObjectCodec _codec;
        protected Segment _segment;
        protected int _segmentPtr;
        protected JsonReadContext _parsingContext;
        protected boolean _closed;
        protected transient ByteArrayBuilder _byteBuilder;
        protected JsonLocation _location = null;

        public Parser(Segment firstSeg, ObjectCodec codec) {
            super(0);
            this._segment = firstSeg;
            this._segmentPtr = -1;
            this._codec = codec;
            this._parsingContext = JsonReadContext.createRootContext(-1, -1);
        }

        public void setLocation(JsonLocation l) {
            this._location = l;
        }

        @Override
        public ObjectCodec getCodec() {
            return this._codec;
        }

        @Override
        public void close() throws IOException {
            if (!this._closed) {
                this._closed = true;
            }
        }

        @Override
        public JsonToken nextToken() throws IOException, JsonParseException {
            if (this._closed || this._segment == null) {
                return null;
            }
            if (++this._segmentPtr >= 16) {
                this._segmentPtr = 0;
                this._segment = this._segment.next();
                if (this._segment == null) {
                    return null;
                }
            }
            this._currToken = this._segment.type(this._segmentPtr);
            if (this._currToken == JsonToken.FIELD_NAME) {
                Object ob = this._currentObject();
                String name = ob instanceof String ? (String)ob : ob.toString();
                this._parsingContext.setCurrentName(name);
            } else if (this._currToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
            } else if (this._currToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(-1, -1);
            } else if (this._currToken == JsonToken.END_OBJECT || this._currToken == JsonToken.END_ARRAY) {
                this._parsingContext = this._parsingContext.getParent();
                if (this._parsingContext == null) {
                    this._parsingContext = JsonReadContext.createRootContext(-1, -1);
                }
            }
            return this._currToken;
        }

        @Override
        public JsonLocation getTokenLocation() {
            return this.getCurrentLocation();
        }

        @Override
        public JsonLocation getCurrentLocation() {
            return this._location == null ? JsonLocation.NA : this._location;
        }

        @Override
        public String getCurrentName() {
            return this._parsingContext.getCurrentName();
        }

        @Override
        public String getText() {
            if (this._currToken == JsonToken.VALUE_STRING || this._currToken == JsonToken.FIELD_NAME) {
                Object ob = this._currentObject();
                if (ob instanceof String) {
                    return (String)ob;
                }
                return ob == null ? null : ob.toString();
            }
            if (this._currToken == null) {
                return null;
            }
            switch (this._currToken) {
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    Object ob = this._currentObject();
                    return ob == null ? null : ob.toString();
                }
            }
            return this._currToken.asString();
        }

        @Override
        public char[] getTextCharacters() {
            String str = this.getText();
            return str == null ? null : str.toCharArray();
        }

        @Override
        public int getTextLength() {
            String str = this.getText();
            return str == null ? 0 : str.length();
        }

        @Override
        public int getTextOffset() {
            return 0;
        }

        @Override
        public boolean hasTextCharacters() {
            return false;
        }

        @Override
        public BigInteger getBigIntegerValue() throws IOException, JsonParseException {
            Number n = this.getNumberValue();
            if (n instanceof BigInteger) {
                return (BigInteger)n;
            }
            switch (this.getNumberType()) {
                case BIG_DECIMAL: {
                    return ((BigDecimal)n).toBigInteger();
                }
            }
            return BigInteger.valueOf(n.longValue());
        }

        @Override
        public BigDecimal getDecimalValue() throws IOException, JsonParseException {
            Number n = this.getNumberValue();
            if (n instanceof BigDecimal) {
                return (BigDecimal)n;
            }
            switch (this.getNumberType()) {
                case INT: 
                case LONG: {
                    return BigDecimal.valueOf(n.longValue());
                }
                case BIG_INTEGER: {
                    return new BigDecimal((BigInteger)n);
                }
            }
            return BigDecimal.valueOf(n.doubleValue());
        }

        @Override
        public double getDoubleValue() throws IOException, JsonParseException {
            return this.getNumberValue().doubleValue();
        }

        @Override
        public float getFloatValue() throws IOException, JsonParseException {
            return this.getNumberValue().floatValue();
        }

        @Override
        public int getIntValue() throws IOException, JsonParseException {
            if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
                return ((Number)this._currentObject()).intValue();
            }
            return this.getNumberValue().intValue();
        }

        @Override
        public long getLongValue() throws IOException, JsonParseException {
            return this.getNumberValue().longValue();
        }

        @Override
        public JsonParser.NumberType getNumberType() throws IOException, JsonParseException {
            Number n = this.getNumberValue();
            if (n instanceof Integer) {
                return JsonParser.NumberType.INT;
            }
            if (n instanceof Long) {
                return JsonParser.NumberType.LONG;
            }
            if (n instanceof Double) {
                return JsonParser.NumberType.DOUBLE;
            }
            if (n instanceof BigDecimal) {
                return JsonParser.NumberType.BIG_DECIMAL;
            }
            if (n instanceof Float) {
                return JsonParser.NumberType.FLOAT;
            }
            if (n instanceof BigInteger) {
                return JsonParser.NumberType.BIG_INTEGER;
            }
            return null;
        }

        @Override
        public final Number getNumberValue() throws IOException, JsonParseException {
            this._checkIsNumber();
            return (Number)this._currentObject();
        }

        @Override
        public Object getEmbeddedObject() {
            if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
                return this._currentObject();
            }
            return null;
        }

        @Override
        public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException, JsonParseException {
            Object object;
            if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT && (object = this._currentObject()) instanceof byte[]) {
                return (byte[])object;
            }
            if (this._currToken != JsonToken.VALUE_STRING) {
                throw this._constructError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING (or VALUE_EMBEDDED_OBJECT with byte[]), can not access as binary");
            }
            object = this.getText();
            if (object == null) {
                return null;
            }
            ByteArrayBuilder byteArrayBuilder = this._byteBuilder;
            if (byteArrayBuilder == null) {
                this._byteBuilder = byteArrayBuilder = new ByteArrayBuilder(100);
            } else {
                this._byteBuilder.reset();
            }
            this._decodeBase64((String)object, byteArrayBuilder, base64Variant);
            return byteArrayBuilder.toByteArray();
        }

        protected final Object _currentObject() {
            return this._segment.get(this._segmentPtr);
        }

        protected final void _checkIsNumber() throws JsonParseException {
            if (this._currToken == null || !this._currToken.isNumeric()) {
                throw this._constructError("Current token (" + (Object)((Object)this._currToken) + ") not numeric, can not use numeric value accessors");
            }
        }

        @Override
        protected void _handleEOF() throws JsonParseException {
            this._throwInternal();
        }
    }
}

