/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.util;

import com.amazonaws.com.fasterxml.jackson.core.io.SerializedString;
import com.amazonaws.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.amazonaws.com.fasterxml.jackson.databind.BeanDescription;
import com.amazonaws.com.fasterxml.jackson.databind.JavaType;
import com.amazonaws.com.fasterxml.jackson.databind.PropertyName;
import com.amazonaws.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.amazonaws.com.fasterxml.jackson.databind.type.ClassKey;
import com.amazonaws.com.fasterxml.jackson.databind.util.LRUMap;
import java.io.Serializable;

public class RootNameLookup
implements Serializable {
    protected LRUMap<ClassKey, SerializedString> _rootNames;

    public SerializedString findRootName(JavaType rootType, MapperConfig<?> config) {
        return this.findRootName(rootType.getRawClass(), config);
    }

    public synchronized SerializedString findRootName(Class<?> rootType, MapperConfig<?> config) {
        ClassKey key = new ClassKey(rootType);
        if (this._rootNames == null) {
            this._rootNames = new LRUMap(20, 200);
        } else {
            SerializedString name = (SerializedString)this._rootNames.get(key);
            if (name != null) {
                return name;
            }
        }
        BeanDescription beanDesc = config.introspectClassAnnotations(rootType);
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        AnnotatedClass ac = beanDesc.getClassInfo();
        PropertyName pname = intr.findRootName(ac);
        String nameStr = pname == null || !pname.hasSimpleName() ? rootType.getSimpleName() : pname.getSimpleName();
        SerializedString name = new SerializedString(nameStr);
        this._rootNames.put(key, name);
        return name;
    }
}

