/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.ser.std;

import com.amazonaws.com.fasterxml.jackson.core.JsonGenerationException;
import com.amazonaws.com.fasterxml.jackson.core.JsonGenerator;
import com.amazonaws.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.amazonaws.com.fasterxml.jackson.databind.BeanProperty;
import com.amazonaws.com.fasterxml.jackson.databind.JavaType;
import com.amazonaws.com.fasterxml.jackson.databind.JsonMappingException;
import com.amazonaws.com.fasterxml.jackson.databind.JsonSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.SerializationFeature;
import com.amazonaws.com.fasterxml.jackson.databind.SerializerProvider;
import com.amazonaws.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.amazonaws.com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

@JacksonStdImpl
public class MapSerializer
extends ContainerSerializer<Map<?, ?>>
implements ContextualSerializer {
    protected static final JavaType UNSPECIFIED_TYPE = TypeFactory.unknownType();
    protected final BeanProperty _property;
    protected final HashSet<String> _ignoredEntries;
    protected final boolean _valueTypeIsStatic;
    protected final JavaType _keyType;
    protected final JavaType _valueType;
    protected JsonSerializer<Object> _keySerializer;
    protected JsonSerializer<Object> _valueSerializer;
    protected final TypeSerializer _valueTypeSerializer;
    protected PropertySerializerMap _dynamicValueSerializers;

    protected MapSerializer(HashSet<String> ignoredEntries, JavaType keyType, JavaType valueType, boolean valueTypeIsStatic, TypeSerializer vts, JsonSerializer<?> keySerializer, JsonSerializer<?> valueSerializer) {
        super(Map.class, false);
        this._ignoredEntries = ignoredEntries;
        this._keyType = keyType;
        this._valueType = valueType;
        this._valueTypeIsStatic = valueTypeIsStatic;
        this._valueTypeSerializer = vts;
        this._keySerializer = keySerializer;
        this._valueSerializer = valueSerializer;
        this._dynamicValueSerializers = PropertySerializerMap.emptyMap();
        this._property = null;
    }

    protected MapSerializer(MapSerializer src, BeanProperty property, JsonSerializer<?> keySerializer, JsonSerializer<?> valueSerializer, HashSet<String> ignored) {
        super(Map.class, false);
        this._ignoredEntries = ignored;
        this._keyType = src._keyType;
        this._valueType = src._valueType;
        this._valueTypeIsStatic = src._valueTypeIsStatic;
        this._valueTypeSerializer = src._valueTypeSerializer;
        this._keySerializer = keySerializer;
        this._valueSerializer = valueSerializer;
        this._dynamicValueSerializers = src._dynamicValueSerializers;
        this._property = property;
    }

    protected MapSerializer(MapSerializer src, TypeSerializer vts) {
        super(Map.class, false);
        this._ignoredEntries = src._ignoredEntries;
        this._keyType = src._keyType;
        this._valueType = src._valueType;
        this._valueTypeIsStatic = src._valueTypeIsStatic;
        this._valueTypeSerializer = vts;
        this._keySerializer = src._keySerializer;
        this._valueSerializer = src._valueSerializer;
        this._dynamicValueSerializers = src._dynamicValueSerializers;
        this._property = src._property;
    }

    public MapSerializer _withValueTypeSerializer(TypeSerializer vts) {
        return new MapSerializer(this, vts);
    }

    public MapSerializer withResolved(BeanProperty property, JsonSerializer<?> keySerializer, JsonSerializer<?> valueSerializer, HashSet<String> ignored) {
        return new MapSerializer(this, property, keySerializer, valueSerializer, ignored);
    }

    public static MapSerializer construct(String[] ignoredList, JavaType mapType, boolean staticValueType, TypeSerializer vts, JsonSerializer<Object> keySerializer, JsonSerializer<Object> valueSerializer) {
        JavaType keyType;
        JavaType valueType;
        HashSet<String> ignoredEntries = MapSerializer.toSet(ignoredList);
        if (mapType == null) {
            keyType = valueType = UNSPECIFIED_TYPE;
        } else {
            keyType = mapType.getKeyType();
            valueType = mapType.getContentType();
        }
        if (!staticValueType) {
            staticValueType = valueType != null && valueType.isFinal();
        }
        return new MapSerializer(ignoredEntries, keyType, valueType, staticValueType, vts, keySerializer, valueSerializer);
    }

    private static HashSet<String> toSet(String[] ignoredEntries) {
        if (ignoredEntries == null || ignoredEntries.length == 0) {
            return null;
        }
        HashSet<String> result = new HashSet<String>(ignoredEntries.length);
        for (String prop : ignoredEntries) {
            result.add(prop);
        }
        return result;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        String[] moreToIgnore;
        AnnotatedMember m;
        JsonSerializer<Object> ser = null;
        JsonSerializer<Object> keySer = null;
        if (property != null && (m = property.getMember()) != null) {
            AnnotationIntrospector intr = provider.getAnnotationIntrospector();
            Object serDef = intr.findKeySerializer(m);
            if (serDef != null) {
                keySer = provider.serializerInstance(m, serDef);
            }
            if ((serDef = intr.findContentSerializer(m)) != null) {
                ser = provider.serializerInstance(m, serDef);
            }
        }
        if (ser == null) {
            ser = this._valueSerializer;
        }
        if (ser == null) {
            if (this._valueTypeIsStatic || this.hasContentTypeAnnotation(provider, property)) {
                ser = provider.findValueSerializer(this._valueType, property);
            }
        } else if (ser instanceof ContextualSerializer) {
            ser = ((ContextualSerializer)((Object)ser)).createContextual(provider, property);
        }
        if (keySer == null) {
            keySer = this._keySerializer;
        }
        if (keySer == null) {
            keySer = provider.findKeySerializer(this._keyType, property);
        } else if (keySer instanceof ContextualSerializer) {
            keySer = ((ContextualSerializer)((Object)keySer)).createContextual(provider, property);
        }
        HashSet<String> ignored = this._ignoredEntries;
        AnnotationIntrospector intr = provider.getAnnotationIntrospector();
        if (intr != null && property != null && (moreToIgnore = intr.findPropertiesToIgnore(property.getMember())) != null) {
            ignored = ignored == null ? new HashSet() : new HashSet<String>(ignored);
            for (String str : moreToIgnore) {
                ignored.add(str);
            }
        }
        return this.withResolved(property, keySer, ser, ignored);
    }

    @Override
    public boolean isEmpty(Map<?, ?> value) {
        return value == null || value.isEmpty();
    }

    @Override
    public boolean hasSingleElement(Map<?, ?> value) {
        return value.size() == 1;
    }

    @Override
    public void serialize(Map<?, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartObject();
        if (!value.isEmpty()) {
            if (provider.isEnabled(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS)) {
                value = this._orderEntries(value);
            }
            if (this._valueSerializer != null) {
                this.serializeFieldsUsing(value, jgen, provider, this._valueSerializer);
            } else {
                this.serializeFields(value, jgen, provider);
            }
        }
        jgen.writeEndObject();
    }

    @Override
    public void serializeWithType(Map<?, ?> value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForObject(value, jgen);
        if (!value.isEmpty()) {
            if (provider.isEnabled(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS)) {
                value = this._orderEntries(value);
            }
            if (this._valueSerializer != null) {
                this.serializeFieldsUsing(value, jgen, provider, this._valueSerializer);
            } else {
                this.serializeFields(value, jgen, provider);
            }
        }
        typeSer.writeTypeSuffixForObject(value, jgen);
    }

    public void serializeFields(Map<?, ?> map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (this._valueTypeSerializer != null) {
            this.serializeTypedFields(map, jsonGenerator, serializerProvider);
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._keySerializer;
        HashSet<String> hashSet = this._ignoredEntries;
        boolean bl = !serializerProvider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES);
        PropertySerializerMap propertySerializerMap = this._dynamicValueSerializers;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object obj = entry.getValue();
            Object obj2 = entry.getKey();
            if (obj2 == null) {
                serializerProvider.findNullKeySerializer(this._keyType, this._property).serialize(null, jsonGenerator, serializerProvider);
            } else {
                if (bl && obj == null || hashSet != null && hashSet.contains(obj2)) continue;
                jsonSerializer.serialize(obj2, jsonGenerator, serializerProvider);
            }
            if (obj == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            Class<?> clazz = obj.getClass();
            JsonSerializer<Object> jsonSerializer2 = propertySerializerMap.serializerFor(clazz);
            if (jsonSerializer2 == null) {
                jsonSerializer2 = this._valueType.hasGenericTypes() ? this._findAndAddDynamic(propertySerializerMap, serializerProvider.constructSpecializedType(this._valueType, clazz), serializerProvider) : this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
                propertySerializerMap = this._dynamicValueSerializers;
            }
            try {
                jsonSerializer2.serialize(obj, jsonGenerator, serializerProvider);
            }
            catch (Exception exception) {
                String string = "" + obj2;
                this.wrapAndThrow(serializerProvider, (Throwable)exception, map, string);
            }
        }
    }

    protected void serializeFieldsUsing(Map<?, ?> map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, JsonSerializer<Object> jsonSerializer) throws IOException, JsonGenerationException {
        JsonSerializer<Object> jsonSerializer2 = this._keySerializer;
        HashSet<String> hashSet = this._ignoredEntries;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        boolean bl = !serializerProvider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object obj = entry.getValue();
            Object obj2 = entry.getKey();
            if (obj2 == null) {
                serializerProvider.findNullKeySerializer(this._keyType, this._property).serialize(null, jsonGenerator, serializerProvider);
            } else {
                if (bl && obj == null || hashSet != null && hashSet.contains(obj2)) continue;
                jsonSerializer2.serialize(obj2, jsonGenerator, serializerProvider);
            }
            if (obj == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            try {
                if (typeSerializer == null) {
                    jsonSerializer.serialize(obj, jsonGenerator, serializerProvider);
                    continue;
                }
                jsonSerializer.serializeWithType(obj, jsonGenerator, serializerProvider, typeSerializer);
            }
            catch (Exception exception) {
                String string = "" + obj2;
                this.wrapAndThrow(serializerProvider, (Throwable)exception, map, string);
            }
        }
    }

    protected void serializeTypedFields(Map<?, ?> map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        JsonSerializer<Object> jsonSerializer = this._keySerializer;
        JsonSerializer<Object> jsonSerializer2 = null;
        Class<?> clazz = null;
        HashSet<String> hashSet = this._ignoredEntries;
        boolean bl = !serializerProvider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            JsonSerializer<Object> jsonSerializer3;
            Object obj = entry.getValue();
            Object obj2 = entry.getKey();
            if (obj2 == null) {
                serializerProvider.findNullKeySerializer(this._keyType, this._property).serialize(null, jsonGenerator, serializerProvider);
            } else {
                if (bl && obj == null || hashSet != null && hashSet.contains(obj2)) continue;
                jsonSerializer.serialize(obj2, jsonGenerator, serializerProvider);
            }
            if (obj == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            Class<?> clazz2 = obj.getClass();
            if (clazz2 == clazz) {
                jsonSerializer3 = jsonSerializer2;
            } else {
                jsonSerializer2 = jsonSerializer3 = serializerProvider.findValueSerializer(clazz2, this._property);
                clazz = clazz2;
            }
            try {
                jsonSerializer3.serializeWithType(obj, jsonGenerator, serializerProvider, this._valueTypeSerializer);
            }
            catch (Exception exception) {
                String string = "" + obj2;
                this.wrapAndThrow(serializerProvider, (Throwable)exception, map, string);
            }
        }
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map, Class<?> type, SerializerProvider provider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSerializer(type, provider, this._property);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map, JavaType type, SerializerProvider provider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSerializer(type, provider, this._property);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }

    protected Map<?, ?> _orderEntries(Map<?, ?> input) {
        if (input instanceof SortedMap) {
            return input;
        }
        return new TreeMap(input);
    }
}

