/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.node;

import com.amazonaws.com.fasterxml.jackson.core.JsonGenerator;
import com.amazonaws.com.fasterxml.jackson.core.JsonParser;
import com.amazonaws.com.fasterxml.jackson.core.JsonProcessingException;
import com.amazonaws.com.fasterxml.jackson.core.JsonToken;
import com.amazonaws.com.fasterxml.jackson.core.io.NumberOutput;
import com.amazonaws.com.fasterxml.jackson.databind.SerializerProvider;
import com.amazonaws.com.fasterxml.jackson.databind.node.NumericNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class DoubleNode
extends NumericNode {
    protected final double _value;

    public DoubleNode(double v) {
        this._value = v;
    }

    public static DoubleNode valueOf(double v) {
        return new DoubleNode(v);
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    @Override
    public JsonParser.NumberType numberType() {
        return JsonParser.NumberType.DOUBLE;
    }

    @Override
    public Number numberValue() {
        return this._value;
    }

    @Override
    public int intValue() {
        return (int)this._value;
    }

    @Override
    public long longValue() {
        return (long)this._value;
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    @Override
    public BigDecimal decimalValue() {
        return BigDecimal.valueOf(this._value);
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this.decimalValue().toBigInteger();
    }

    @Override
    public String asText() {
        return NumberOutput.toString(this._value);
    }

    @Override
    public final void serialize(JsonGenerator jg, SerializerProvider provider) throws IOException, JsonProcessingException {
        jg.writeNumber(this._value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        double otherValue = ((DoubleNode)o)._value;
        return Double.compare(this._value, otherValue) == 0;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this._value);
        return (int)l ^ (int)(l >> 32);
    }
}

