/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.deser;

import com.amazonaws.com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.amazonaws.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.amazonaws.com.fasterxml.jackson.databind.BeanDescription;
import com.amazonaws.com.fasterxml.jackson.databind.BeanProperty;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationConfig;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationContext;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationFeature;
import com.amazonaws.com.fasterxml.jackson.databind.JavaType;
import com.amazonaws.com.fasterxml.jackson.databind.JsonDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.JsonMappingException;
import com.amazonaws.com.fasterxml.jackson.databind.JsonNode;
import com.amazonaws.com.fasterxml.jackson.databind.KeyDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.PropertyName;
import com.amazonaws.com.fasterxml.jackson.databind.annotation.NoClass;
import com.amazonaws.com.fasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import com.amazonaws.com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.amazonaws.com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.amazonaws.com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.amazonaws.com.fasterxml.jackson.databind.deser.Deserializers;
import com.amazonaws.com.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.amazonaws.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.amazonaws.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.amazonaws.com.fasterxml.jackson.databind.deser.ValueInstantiators;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.CreatorCollector;
import com.amazonaws.com.fasterxml.jackson.databind.deser.std.CollectionDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import com.amazonaws.com.fasterxml.jackson.databind.deser.std.EnumDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.deser.std.EnumMapDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.deser.std.EnumSetDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.deser.std.JacksonDeserializers;
import com.amazonaws.com.fasterxml.jackson.databind.deser.std.JdkDeserializers;
import com.amazonaws.com.fasterxml.jackson.databind.deser.std.JsonNodeDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.deser.std.MapDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.deser.std.NumberDeserializers;
import com.amazonaws.com.fasterxml.jackson.databind.deser.std.ObjectArrayDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers;
import com.amazonaws.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.deser.std.StdKeyDeserializers;
import com.amazonaws.com.fasterxml.jackson.databind.deser.std.StringCollectionDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.ext.OptionalHandlerFactory;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.Annotated;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.NamedType;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.amazonaws.com.fasterxml.jackson.databind.type.ArrayType;
import com.amazonaws.com.fasterxml.jackson.databind.type.ClassKey;
import com.amazonaws.com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.amazonaws.com.fasterxml.jackson.databind.type.CollectionType;
import com.amazonaws.com.fasterxml.jackson.databind.type.MapLikeType;
import com.amazonaws.com.fasterxml.jackson.databind.type.MapType;
import com.amazonaws.com.fasterxml.jackson.databind.util.ClassUtil;
import com.amazonaws.com.fasterxml.jackson.databind.util.EnumResolver;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class BasicDeserializerFactory
extends DeserializerFactory
implements Serializable {
    protected static final HashMap<ClassKey, JsonDeserializer<Object>> _simpleDeserializers = new HashMap();
    protected static final HashMap<JavaType, JsonDeserializer<Object>> _arrayDeserializers = PrimitiveArrayDeserializers.getAll();
    protected static final HashMap<JavaType, KeyDeserializer> _keyDeserializers = StdKeyDeserializers.constructAll();
    static final HashMap<String, Class<? extends Map>> _mapFallbacks;
    static final HashMap<String, Class<? extends Collection>> _collectionFallbacks;
    protected OptionalHandlerFactory optionalHandlers = OptionalHandlerFactory.instance;
    protected final DeserializerFactoryConfig _factoryConfig;

    private static void _add(Map<ClassKey, JsonDeserializer<Object>> desers, StdDeserializer<?>[] serializers) {
        for (StdDeserializer<?> ser : serializers) {
            BasicDeserializerFactory._add(desers, ser.getValueClass(), ser);
        }
    }

    private static void _add(Map<ClassKey, JsonDeserializer<Object>> desers, Class<?> valueClass, StdDeserializer<?> stdDeser) {
        StdDeserializer<?> deser = stdDeser;
        desers.put(new ClassKey(valueClass), deser);
    }

    protected BasicDeserializerFactory(DeserializerFactoryConfig config) {
        this._factoryConfig = config;
    }

    @Override
    public JavaType mapAbstractType(DeserializationConfig config, JavaType type) throws JsonMappingException {
        JavaType next;
        while ((next = this._mapAbstractType2(config, type)) != null) {
            Class<?> nextCls;
            Class<?> prevCls = type.getRawClass();
            if (prevCls == (nextCls = next.getRawClass()) || !prevCls.isAssignableFrom(nextCls)) {
                throw new IllegalArgumentException("Invalid abstract type resolution from " + type + " to " + next + ": latter is not a subtype of former");
            }
            type = next;
        }
        return type;
    }

    private JavaType _mapAbstractType2(DeserializationConfig config, JavaType type) throws JsonMappingException {
        Class<?> currClass = type.getRawClass();
        if (this._factoryConfig.hasAbstractTypeResolvers()) {
            for (AbstractTypeResolver resolver : this._factoryConfig.abstractTypeResolvers()) {
                JavaType concrete = resolver.findTypeMapping(config, type);
                if (concrete == null || concrete.getRawClass() == currClass) continue;
                return concrete;
            }
        }
        return null;
    }

    public ValueInstantiator findValueInstantiator(DeserializationContext deserializationContext, BeanDescription beanDescription) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        ValueInstantiator valueInstantiator = null;
        AnnotatedClass annotatedClass = beanDescription.getClassInfo();
        Object object = deserializationContext.getAnnotationIntrospector().findValueInstantiator(annotatedClass);
        if (object != null) {
            valueInstantiator = this._valueInstantiatorInstance(deserializationConfig, annotatedClass, object);
        }
        if (valueInstantiator == null && (valueInstantiator = this._findStdValueInstantiator(deserializationConfig, beanDescription)) == null) {
            valueInstantiator = this._constructDefaultValueInstantiator(deserializationContext, beanDescription);
        }
        if (this._factoryConfig.hasValueInstantiators()) {
            for (ValueInstantiators valueInstantiators : this._factoryConfig.valueInstantiators()) {
                valueInstantiator = valueInstantiators.findValueInstantiator(deserializationConfig, beanDescription, valueInstantiator);
                if (valueInstantiator != null) continue;
                throw new JsonMappingException("Broken registered ValueInstantiators (of type " + valueInstantiators.getClass().getName() + "): returned null ValueInstantiator");
            }
        }
        return valueInstantiator;
    }

    private ValueInstantiator _findStdValueInstantiator(DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        return JacksonDeserializers.findValueInstantiator(config, beanDesc);
    }

    protected ValueInstantiator _constructDefaultValueInstantiator(DeserializationContext ctxt, BeanDescription beanDesc) throws JsonMappingException {
        boolean fixAccess = ctxt.canOverrideAccessModifiers();
        CreatorCollector creators = new CreatorCollector(beanDesc, fixAccess);
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        DeserializationConfig config = ctxt.getConfig();
        VisibilityChecker<?> vchecker = config.getDefaultVisibilityChecker();
        vchecker = intr.findAutoDetectVisibility(beanDesc.getClassInfo(), vchecker);
        this._addDeserializerFactoryMethods(ctxt, beanDesc, vchecker, intr, creators);
        if (beanDesc.getType().isConcrete()) {
            this._addDeserializerConstructors(ctxt, beanDesc, vchecker, intr, creators);
        }
        return creators.constructValueInstantiator(config);
    }

    public ValueInstantiator _valueInstantiatorInstance(DeserializationConfig deserializationConfig, Annotated annotated, Object object) throws JsonMappingException {
        ValueInstantiator valueInstantiator;
        if (object == null) {
            return null;
        }
        if (object instanceof ValueInstantiator) {
            valueInstantiator = (ValueInstantiator)object;
        } else {
            if (!(object instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned key deserializer definition of type " + object.getClass().getName() + "; expected type KeyDeserializer or Class<KeyDeserializer> instead");
            }
            Class clazz = (Class)object;
            if (clazz == NoClass.class) {
                return null;
            }
            if (!ValueInstantiator.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<ValueInstantiator>");
            }
            HandlerInstantiator handlerInstantiator = deserializationConfig.getHandlerInstantiator();
            valueInstantiator = handlerInstantiator != null ? handlerInstantiator.valueInstantiatorInstance(deserializationConfig, annotated, clazz) : (ValueInstantiator)ClassUtil.createInstance(clazz, deserializationConfig.canOverrideAccessModifiers());
        }
        return valueInstantiator;
    }

    protected void _addDeserializerConstructors(DeserializationContext deserializationContext, BeanDescription beanDescription, VisibilityChecker<?> visibilityChecker, AnnotationIntrospector annotationIntrospector, CreatorCollector creatorCollector) throws JsonMappingException {
        AnnotatedConstructor annotatedConstructor = beanDescription.findDefaultConstructor();
        if (annotatedConstructor != null && (!creatorCollector.hasDefaultCreator() || annotationIntrospector.hasCreatorAnnotation(annotatedConstructor))) {
            creatorCollector.setDefaultCreator(annotatedConstructor);
        }
        for (AnnotatedConstructor annotatedConstructor2 : beanDescription.getConstructors()) {
            int n = annotatedConstructor2.getParameterCount();
            boolean bl = annotationIntrospector.hasCreatorAnnotation(annotatedConstructor2);
            boolean bl2 = visibilityChecker.isCreatorVisible(annotatedConstructor2);
            if (n == 1) {
                this._handleSingleArgumentConstructor(deserializationContext, beanDescription, visibilityChecker, annotationIntrospector, creatorCollector, annotatedConstructor2, bl, bl2);
                continue;
            }
            if (!bl && !bl2) continue;
            AnnotatedParameter annotatedParameter = null;
            int n2 = 0;
            int n3 = 0;
            CreatorProperty[] creatorPropertyArray = new CreatorProperty[n];
            for (int i = 0; i < n; ++i) {
                AnnotatedParameter annotatedParameter2 = annotatedConstructor2.getParameter(i);
                PropertyName propertyName = annotatedParameter2 == null ? null : annotationIntrospector.findNameForDeserialization(annotatedParameter2);
                String string = propertyName == null ? null : propertyName.getSimpleName();
                Object object = annotationIntrospector.findInjectableValueId(annotatedParameter2);
                if (string != null && string.length() > 0) {
                    ++n2;
                    creatorPropertyArray[i] = this.constructCreatorProperty(deserializationContext, beanDescription, string, i, annotatedParameter2, object);
                    continue;
                }
                if (object != null) {
                    ++n3;
                    creatorPropertyArray[i] = this.constructCreatorProperty(deserializationContext, beanDescription, string, i, annotatedParameter2, object);
                    continue;
                }
                if (annotatedParameter != null) continue;
                annotatedParameter = annotatedParameter2;
            }
            if (!bl && n2 <= 0 && n3 <= 0) continue;
            if (n2 + n3 == n) {
                creatorCollector.addPropertyCreator(annotatedConstructor2, creatorPropertyArray);
                continue;
            }
            if (n2 == 0 && n3 + 1 == n) {
                creatorCollector.addDelegatingCreator(annotatedConstructor2, creatorPropertyArray);
                continue;
            }
            throw new IllegalArgumentException("Argument #" + annotatedParameter.getIndex() + " of constructor " + annotatedConstructor2 + " has no property name annotation; must have name when multiple-paramater constructor annotated as Creator");
        }
    }

    protected boolean _handleSingleArgumentConstructor(DeserializationContext deserializationContext, BeanDescription beanDescription, VisibilityChecker<?> visibilityChecker, AnnotationIntrospector annotationIntrospector, CreatorCollector creatorCollector, AnnotatedConstructor annotatedConstructor, boolean bl, boolean bl2) throws JsonMappingException {
        AnnotatedParameter annotatedParameter = annotatedConstructor.getParameter(0);
        PropertyName propertyName = annotatedParameter == null ? null : annotationIntrospector.findNameForDeserialization(annotatedParameter);
        String string = propertyName == null ? null : propertyName.getSimpleName();
        Object object = annotationIntrospector.findInjectableValueId(annotatedParameter);
        if (object != null || string != null && string.length() > 0) {
            CreatorProperty[] creatorPropertyArray = new CreatorProperty[]{this.constructCreatorProperty(deserializationContext, beanDescription, string, 0, annotatedParameter, object)};
            creatorCollector.addPropertyCreator(annotatedConstructor, creatorPropertyArray);
            return true;
        }
        Class<?> clazz = annotatedConstructor.getRawParameterType(0);
        if (clazz == String.class) {
            if (bl || bl2) {
                creatorCollector.addStringCreator(annotatedConstructor);
            }
            return true;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            if (bl || bl2) {
                creatorCollector.addIntCreator(annotatedConstructor);
            }
            return true;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            if (bl || bl2) {
                creatorCollector.addLongCreator(annotatedConstructor);
            }
            return true;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            if (bl || bl2) {
                creatorCollector.addDoubleCreator(annotatedConstructor);
            }
            return true;
        }
        if (bl) {
            creatorCollector.addDelegatingCreator(annotatedConstructor, null);
            return true;
        }
        return false;
    }

    protected void _addDeserializerFactoryMethods(DeserializationContext deserializationContext, BeanDescription beanDescription, VisibilityChecker<?> visibilityChecker, AnnotationIntrospector annotationIntrospector, CreatorCollector creatorCollector) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        for (AnnotatedMethod annotatedMethod : beanDescription.getFactoryMethods()) {
            CreatorProperty[] creatorPropertyArray;
            AnnotatedParameter annotatedParameter;
            boolean bl = annotationIntrospector.hasCreatorAnnotation(annotatedMethod);
            int n = annotatedMethod.getParameterCount();
            if (n == 0) {
                if (!bl) continue;
                creatorCollector.setDefaultCreator(annotatedMethod);
                continue;
            }
            if (n == 1) {
                annotatedParameter = annotatedMethod.getParameter(0);
                creatorPropertyArray = annotatedParameter == null ? null : annotationIntrospector.findNameForDeserialization(annotatedParameter);
                String string = creatorPropertyArray == null ? null : creatorPropertyArray.getSimpleName();
                Object object = annotationIntrospector.findInjectableValueId(annotatedParameter);
                if (object == null && (string == null || string.length() == 0)) {
                    this._handleSingleArgumentFactory(deserializationConfig, beanDescription, visibilityChecker, annotationIntrospector, creatorCollector, annotatedMethod, bl);
                    continue;
                }
            } else if (!annotationIntrospector.hasCreatorAnnotation(annotatedMethod)) continue;
            annotatedParameter = null;
            creatorPropertyArray = new CreatorProperty[n];
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                AnnotatedParameter annotatedParameter2 = annotatedMethod.getParameter(i);
                PropertyName propertyName = annotatedParameter2 == null ? null : annotationIntrospector.findNameForDeserialization(annotatedParameter2);
                String string = propertyName == null ? null : propertyName.getSimpleName();
                Object object = annotationIntrospector.findInjectableValueId(annotatedParameter2);
                if (string != null && string.length() > 0) {
                    ++n2;
                    creatorPropertyArray[i] = this.constructCreatorProperty(deserializationContext, beanDescription, string, i, annotatedParameter2, object);
                    continue;
                }
                if (object != null) {
                    ++n3;
                    creatorPropertyArray[i] = this.constructCreatorProperty(deserializationContext, beanDescription, string, i, annotatedParameter2, object);
                    continue;
                }
                if (annotatedParameter != null) continue;
                annotatedParameter = annotatedParameter2;
            }
            if (!bl && n2 <= 0 && n3 <= 0) continue;
            if (n2 + n3 == n) {
                creatorCollector.addPropertyCreator(annotatedMethod, creatorPropertyArray);
                continue;
            }
            if (n2 == 0 && n3 + 1 == n) {
                creatorCollector.addDelegatingCreator(annotatedMethod, creatorPropertyArray);
                continue;
            }
            throw new IllegalArgumentException("Argument #" + annotatedParameter.getIndex() + " of factory method " + annotatedMethod + " has no property name annotation; must have name when multiple-paramater constructor annotated as Creator");
        }
    }

    protected boolean _handleSingleArgumentFactory(DeserializationConfig deserializationConfig, BeanDescription beanDescription, VisibilityChecker<?> visibilityChecker, AnnotationIntrospector annotationIntrospector, CreatorCollector creatorCollector, AnnotatedMethod annotatedMethod, boolean bl) throws JsonMappingException {
        Class<?> clazz = annotatedMethod.getRawParameterType(0);
        if (clazz == String.class) {
            if (bl || visibilityChecker.isCreatorVisible(annotatedMethod)) {
                creatorCollector.addStringCreator(annotatedMethod);
            }
            return true;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            if (bl || visibilityChecker.isCreatorVisible(annotatedMethod)) {
                creatorCollector.addIntCreator(annotatedMethod);
            }
            return true;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            if (bl || visibilityChecker.isCreatorVisible(annotatedMethod)) {
                creatorCollector.addLongCreator(annotatedMethod);
            }
            return true;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            if (bl || visibilityChecker.isCreatorVisible(annotatedMethod)) {
                creatorCollector.addDoubleCreator(annotatedMethod);
            }
            return true;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            if (bl || visibilityChecker.isCreatorVisible(annotatedMethod)) {
                creatorCollector.addBooleanCreator(annotatedMethod);
            }
            return true;
        }
        if (annotationIntrospector.hasCreatorAnnotation(annotatedMethod)) {
            creatorCollector.addDelegatingCreator(annotatedMethod, null);
            return true;
        }
        return false;
    }

    protected CreatorProperty constructCreatorProperty(DeserializationContext ctxt, BeanDescription beanDesc, String name, int index, AnnotatedParameter param, Object injectableValueId) throws JsonMappingException {
        DeserializationConfig config = ctxt.getConfig();
        JavaType t0 = config.getTypeFactory().constructType(param.getParameterType(), beanDesc.bindingsForBeanType());
        BeanProperty.Std property = new BeanProperty.Std(name, t0, beanDesc.getClassAnnotations(), param);
        JavaType type = this.resolveType(ctxt, beanDesc, t0, param);
        if (type != t0) {
            property = property.withType(type);
        }
        JsonDeserializer<Object> deser = this.findDeserializerFromAnnotation(ctxt, param);
        TypeDeserializer typeDeser = (TypeDeserializer)(type = this.modifyTypeByAnnotation(ctxt, param, type)).getTypeHandler();
        if (typeDeser == null) {
            typeDeser = this.findTypeDeserializer(config, type);
        }
        SettableBeanProperty prop = new CreatorProperty(name, type, typeDeser, beanDesc.getClassAnnotations(), param, index, injectableValueId);
        if (deser != null) {
            prop = prop.withValueDeserializer((JsonDeserializer)deser);
        }
        return prop;
    }

    @Override
    public JsonDeserializer<?> createArrayDeserializer(DeserializationContext deserializationContext, ArrayType arrayType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<?> jsonDeserializer;
        JsonDeserializer<Object> jsonDeserializer2;
        JavaType javaType = arrayType.getContentType();
        JsonDeserializer jsonDeserializer3 = (JsonDeserializer)javaType.getValueHandler();
        if (jsonDeserializer3 == null) {
            jsonDeserializer2 = _arrayDeserializers.get(javaType);
            if (jsonDeserializer2 != null) {
                JsonDeserializer<?> jsonDeserializer4 = this._findCustomArrayDeserializer(arrayType, deserializationContext.getConfig(), beanDescription, null, jsonDeserializer3);
                if (jsonDeserializer4 != null) {
                    return jsonDeserializer4;
                }
                return jsonDeserializer2;
            }
            if (javaType.isPrimitive()) {
                throw new IllegalArgumentException("Internal error: primitive type (" + arrayType + ") passed, no array deserializer found");
            }
        }
        if ((jsonDeserializer2 = (TypeDeserializer)javaType.getTypeHandler()) == null) {
            jsonDeserializer2 = this.findTypeDeserializer(deserializationContext.getConfig(), javaType);
        }
        if ((jsonDeserializer = this._findCustomArrayDeserializer(arrayType, deserializationContext.getConfig(), beanDescription, (TypeDeserializer)((Object)jsonDeserializer2), jsonDeserializer3)) != null) {
            return jsonDeserializer;
        }
        return new ObjectArrayDeserializer(arrayType, jsonDeserializer3, (TypeDeserializer)((Object)jsonDeserializer2));
    }

    protected JsonDeserializer<?> _findCustomArrayDeserializer(ArrayType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findArrayDeserializer(type, config, beanDesc, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createCollectionDeserializer(DeserializationContext deserializationContext, CollectionType collectionType, BeanDescription beanDescription) throws JsonMappingException {
        Class<? extends Collection> clazz;
        JsonDeserializer<?> jsonDeserializer;
        JavaType javaType = collectionType.getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType.getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationContext.getConfig(), javaType);
        }
        if ((jsonDeserializer = this._findCustomCollectionDeserializer(collectionType, deserializationContext.getConfig(), beanDescription, typeDeserializer, jsonDeserializer2)) != null) {
            return jsonDeserializer;
        }
        Object object = collectionType.getRawClass();
        if (jsonDeserializer2 == null && EnumSet.class.isAssignableFrom((Class<?>)object)) {
            return new EnumSetDeserializer(javaType, null);
        }
        if (collectionType.isInterface() || collectionType.isAbstract()) {
            clazz = _collectionFallbacks.get(((Class)object).getName());
            if (clazz == null) {
                throw new IllegalArgumentException("Can not find a deserializer for non-concrete Collection type " + collectionType);
            }
            object = clazz;
            collectionType = (CollectionType)deserializationContext.getConfig().constructSpecializedType(collectionType, (Class<?>)object);
            beanDescription = deserializationContext.getConfig().introspectForCreation(collectionType);
        }
        clazz = this.findValueInstantiator(deserializationContext, beanDescription);
        if (javaType.getRawClass() == String.class) {
            return new StringCollectionDeserializer(collectionType, jsonDeserializer2, (ValueInstantiator)((Object)clazz));
        }
        return new CollectionDeserializer(collectionType, jsonDeserializer2, typeDeserializer, (ValueInstantiator)((Object)clazz));
    }

    @Override
    public JsonDeserializer<?> createCollectionLikeDeserializer(DeserializationContext ctxt, CollectionLikeType type, BeanDescription beanDesc) throws JsonMappingException {
        JavaType contentType = type.getContentType();
        JsonDeserializer contentDeser = (JsonDeserializer)contentType.getValueHandler();
        TypeDeserializer contentTypeDeser = (TypeDeserializer)contentType.getTypeHandler();
        if (contentTypeDeser == null) {
            contentTypeDeser = this.findTypeDeserializer(ctxt.getConfig(), contentType);
        }
        return this._findCustomCollectionLikeDeserializer(type, ctxt.getConfig(), beanDesc, contentTypeDeser, contentDeser);
    }

    protected JsonDeserializer<?> _findCustomCollectionDeserializer(CollectionType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findCollectionDeserializer(type, config, beanDesc, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomCollectionLikeDeserializer(CollectionLikeType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findCollectionLikeDeserializer(type, config, beanDesc, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createMapDeserializer(DeserializationContext deserializationContext, MapType mapType, BeanDescription beanDescription) throws JsonMappingException {
        Class<? extends Map> clazz;
        JsonDeserializer<?> jsonDeserializer;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        JavaType javaType = mapType.getKeyType();
        JavaType javaType2 = mapType.getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType2.getValueHandler();
        KeyDeserializer keyDeserializer = (KeyDeserializer)javaType.getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType2.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationConfig, javaType2);
        }
        if ((jsonDeserializer = this._findCustomMapDeserializer(mapType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer2)) != null) {
            return jsonDeserializer;
        }
        Class<?> clazz2 = mapType.getRawClass();
        if (EnumMap.class.isAssignableFrom(clazz2)) {
            Class<?> clazz3 = javaType.getRawClass();
            if (clazz3 == null || !clazz3.isEnum()) {
                throw new IllegalArgumentException("Can not construct EnumMap; generic (key) type not available");
            }
            return new EnumMapDeserializer(mapType, null, jsonDeserializer2);
        }
        if (mapType.isInterface() || mapType.isAbstract()) {
            clazz = _mapFallbacks.get(clazz2.getName());
            if (clazz == null) {
                throw new IllegalArgumentException("Can not find a deserializer for non-concrete Map type " + mapType);
            }
            clazz2 = clazz;
            mapType = (MapType)deserializationConfig.constructSpecializedType(mapType, clazz2);
            beanDescription = deserializationConfig.introspectForCreation(mapType);
        }
        clazz = this.findValueInstantiator(deserializationContext, beanDescription);
        MapDeserializer mapDeserializer = new MapDeserializer(mapType, (ValueInstantiator)((Object)clazz), keyDeserializer, jsonDeserializer2, typeDeserializer);
        mapDeserializer.setIgnorableProperties(deserializationConfig.getAnnotationIntrospector().findPropertiesToIgnore(beanDescription.getClassInfo()));
        return mapDeserializer;
    }

    @Override
    public JsonDeserializer<?> createMapLikeDeserializer(DeserializationContext ctxt, MapLikeType type, BeanDescription beanDesc) throws JsonMappingException {
        JavaType keyType = type.getKeyType();
        JavaType contentType = type.getContentType();
        JsonDeserializer contentDeser = (JsonDeserializer)contentType.getValueHandler();
        KeyDeserializer keyDes = (KeyDeserializer)keyType.getValueHandler();
        TypeDeserializer contentTypeDeser = (TypeDeserializer)contentType.getTypeHandler();
        if (contentTypeDeser == null) {
            contentTypeDeser = this.findTypeDeserializer(ctxt.getConfig(), contentType);
        }
        return this._findCustomMapLikeDeserializer(type, ctxt.getConfig(), beanDesc, keyDes, contentTypeDeser, contentDeser);
    }

    protected JsonDeserializer<?> _findCustomMapDeserializer(MapType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findMapDeserializer(type, config, beanDesc, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomMapLikeDeserializer(MapLikeType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findMapLikeDeserializer(type, config, beanDesc, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createEnumDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        JsonDeserializer<?> jsonDeserializer = this._findCustomEnumDeserializer(clazz, deserializationContext.getConfig(), beanDescription);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        for (AnnotatedMethod annotatedMethod : beanDescription.getFactoryMethods()) {
            Class<?> clazz2;
            if (!deserializationContext.getAnnotationIntrospector().hasCreatorAnnotation(annotatedMethod)) continue;
            int n = annotatedMethod.getParameterCount();
            if (n == 1 && (clazz2 = annotatedMethod.getRawReturnType()).isAssignableFrom(clazz)) {
                return EnumDeserializer.deserializerForCreator(deserializationContext.getConfig(), clazz, annotatedMethod);
            }
            throw new IllegalArgumentException("Unsuitable method (" + annotatedMethod + ") decorated with @JsonCreator (for Enum type " + clazz.getName() + ")");
        }
        return new EnumDeserializer(this.constructEnumResolver(clazz, deserializationContext.getConfig(), beanDescription.findJsonValueMethod()));
    }

    protected JsonDeserializer<?> _findCustomEnumDeserializer(Class<?> type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findEnumDeserializer(type, config, beanDesc);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createTreeDeserializer(DeserializationConfig config, JavaType nodeType, BeanDescription beanDesc) throws JsonMappingException {
        Class<?> nodeClass = nodeType.getRawClass();
        JsonDeserializer<?> custom = this._findCustomTreeNodeDeserializer(nodeClass, config, beanDesc);
        if (custom != null) {
            return custom;
        }
        return JsonNodeDeserializer.getDeserializer(nodeClass);
    }

    protected JsonDeserializer<?> _findCustomTreeNodeDeserializer(Class<? extends JsonNode> type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> deser = d.findTreeNodeDeserializer(type, config, beanDesc);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    @Override
    public TypeDeserializer findTypeDeserializer(DeserializationConfig config, JavaType baseType) throws JsonMappingException {
        JavaType defaultType;
        Class<?> cls = baseType.getRawClass();
        BeanDescription bean = config.introspectClassAnnotations(cls);
        AnnotatedClass ac = bean.getClassInfo();
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findTypeResolver(config, ac, baseType);
        Collection<NamedType> subtypes = null;
        if (b == null) {
            b = config.getDefaultTyper(baseType);
            if (b == null) {
                return null;
            }
        } else {
            subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(ac, config, ai);
        }
        if (b.getDefaultImpl() == null && baseType.isAbstract() && (defaultType = this.mapAbstractType(config, baseType)) != null && defaultType.getRawClass() != baseType.getRawClass()) {
            b = b.defaultImpl(defaultType.getRawClass());
        }
        return b.buildTypeDeserializer(config, baseType, subtypes);
    }

    @Override
    public KeyDeserializer createKeyDeserializer(DeserializationContext deserializationContext, JavaType javaType) throws JsonMappingException {
        Object object;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        if (this._factoryConfig.hasKeyDeserializers()) {
            object = deserializationConfig.introspectClassAnnotations(javaType.getRawClass());
            for (KeyDeserializers keyDeserializers : this._factoryConfig.keyDeserializers()) {
                KeyDeserializer keyDeserializer = keyDeserializers.findKeyDeserializer(javaType, deserializationConfig, (BeanDescription)object);
                if (keyDeserializer == null) continue;
                return keyDeserializer;
            }
        }
        if ((object = javaType.getRawClass()) == String.class || object == Object.class) {
            return StdKeyDeserializers.constructStringKeyDeserializer(deserializationConfig, javaType);
        }
        Object object2 = _keyDeserializers.get(javaType);
        if (object2 != null) {
            return object2;
        }
        if (javaType.isEnumType()) {
            return this._createEnumKeyDeserializer(deserializationContext, javaType);
        }
        object2 = StdKeyDeserializers.findStringBasedKeyDeserializer(deserializationConfig, javaType);
        return object2;
    }

    private KeyDeserializer _createEnumKeyDeserializer(DeserializationContext deserializationContext, JavaType javaType) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        Object t = deserializationConfig.introspect(javaType);
        JsonDeserializer<Object> jsonDeserializer = this.findDeserializerFromAnnotation(deserializationContext, ((BeanDescription)t).getClassInfo());
        if (jsonDeserializer != null) {
            return StdKeyDeserializers.constructDelegatingKeyDeserializer(deserializationConfig, javaType, jsonDeserializer);
        }
        Class<?> clazz = javaType.getRawClass();
        JsonDeserializer<?> jsonDeserializer2 = this._findCustomEnumDeserializer(clazz, deserializationConfig, (BeanDescription)t);
        if (jsonDeserializer2 != null) {
            return StdKeyDeserializers.constructDelegatingKeyDeserializer(deserializationConfig, javaType, jsonDeserializer);
        }
        EnumResolver<?> enumResolver = this.constructEnumResolver(clazz, deserializationConfig, ((BeanDescription)t).findJsonValueMethod());
        for (AnnotatedMethod annotatedMethod : ((BeanDescription)t).getFactoryMethods()) {
            Class<?> clazz2;
            if (!deserializationConfig.getAnnotationIntrospector().hasCreatorAnnotation(annotatedMethod)) continue;
            int n = annotatedMethod.getParameterCount();
            if (n == 1 && (clazz2 = annotatedMethod.getRawReturnType()).isAssignableFrom(clazz)) {
                if (annotatedMethod.getGenericParameterType(0) != String.class) {
                    throw new IllegalArgumentException("Parameter #0 type for factory method (" + annotatedMethod + ") not suitable, must be java.lang.String");
                }
                if (deserializationConfig.canOverrideAccessModifiers()) {
                    ClassUtil.checkAndFixAccess(annotatedMethod.getMember());
                }
                return StdKeyDeserializers.constructEnumKeyDeserializer(enumResolver, annotatedMethod);
            }
            throw new IllegalArgumentException("Unsuitable method (" + annotatedMethod + ") decorated with @JsonCreator (for Enum type " + clazz.getName() + ")");
        }
        return StdKeyDeserializers.constructEnumKeyDeserializer(enumResolver);
    }

    public TypeDeserializer findPropertyTypeDeserializer(DeserializationConfig config, JavaType baseType, AnnotatedMember annotated) throws JsonMappingException {
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findPropertyTypeResolver(config, annotated, baseType);
        if (b == null) {
            return this.findTypeDeserializer(config, baseType);
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(annotated, config, ai, baseType);
        return b.buildTypeDeserializer(config, baseType, subtypes);
    }

    public TypeDeserializer findPropertyContentTypeDeserializer(DeserializationConfig config, JavaType containerType, AnnotatedMember propertyEntity) throws JsonMappingException {
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findPropertyContentTypeResolver(config, propertyEntity, containerType);
        JavaType contentType = containerType.getContentType();
        if (b == null) {
            return this.findTypeDeserializer(config, contentType);
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(propertyEntity, config, ai, contentType);
        return b.buildTypeDeserializer(config, contentType, subtypes);
    }

    protected JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationContext ctxt, Annotated ann) throws JsonMappingException {
        Object deserDef = ctxt.getAnnotationIntrospector().findDeserializer(ann);
        if (deserDef == null) {
            return null;
        }
        return ctxt.deserializerInstance(ann, deserDef);
    }

    protected <T extends JavaType> T modifyTypeByAnnotation(DeserializationContext deserializationContext, Annotated annotated, T object) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        Class<?> clazz = annotationIntrospector.findDeserializationType(annotated, (JavaType)object);
        if (clazz != null) {
            try {
                object = ((JavaType)object).narrowBy(clazz);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JsonMappingException("Failed to narrow type " + object + " with concrete-type annotation (value " + clazz.getName() + "), method '" + annotated.getName() + "': " + illegalArgumentException.getMessage(), null, illegalArgumentException);
            }
        }
        if (((JavaType)object).isContainerType()) {
            Object object2;
            JsonDeserializer<Object> jsonDeserializer;
            Object object3;
            Object object4;
            JavaType javaType;
            Class<?> clazz2 = annotationIntrospector.findDeserializationKeyType(annotated, ((JavaType)object).getKeyType());
            if (clazz2 != null) {
                if (!(object instanceof MapLikeType)) {
                    throw new JsonMappingException("Illegal key-type annotation: type " + object + " is not a Map(-like) type");
                }
                try {
                    object = ((MapLikeType)object).narrowKey(clazz2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new JsonMappingException("Failed to narrow key type " + object + " with key-type annotation (" + clazz2.getName() + "): " + illegalArgumentException.getMessage(), null, illegalArgumentException);
                }
            }
            if ((javaType = ((JavaType)object).getKeyType()) != null && javaType.getValueHandler() == null && (object4 = deserializationContext.keyDeserializerInstance(annotated, object3 = annotationIntrospector.findKeyDeserializer(annotated))) != null) {
                object = ((MapLikeType)object).withKeyValueHandler(object4);
                javaType = ((JavaType)object).getKeyType();
            }
            if ((object3 = annotationIntrospector.findDeserializationContentType(annotated, ((JavaType)object).getContentType())) != null) {
                try {
                    object = ((JavaType)object).narrowContentsBy((Class<?>)object3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new JsonMappingException("Failed to narrow content type " + object + " with content-type annotation (" + ((Class)object3).getName() + "): " + illegalArgumentException.getMessage(), null, illegalArgumentException);
                }
            }
            if (((JavaType)(object4 = ((JavaType)object).getContentType())).getValueHandler() == null && (jsonDeserializer = deserializationContext.deserializerInstance(annotated, object2 = annotationIntrospector.findContentDeserializer(annotated))) != null) {
                object = ((JavaType)object).withContentValueHandler(jsonDeserializer);
            }
        }
        return (T)object;
    }

    protected JavaType resolveType(DeserializationContext ctxt, BeanDescription beanDesc, JavaType type, AnnotatedMember member) throws JsonMappingException {
        TypeDeserializer valueTypeDeser;
        if (type.isContainerType()) {
            TypeDeserializer contentTypeDeser;
            Object cdDef;
            JsonDeserializer<Object> cd;
            Object kdDef;
            KeyDeserializer kd;
            AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
            JavaType keyType = type.getKeyType();
            if (keyType != null && (kd = ctxt.keyDeserializerInstance(member, kdDef = intr.findKeyDeserializer(member))) != null) {
                type = ((MapLikeType)type).withKeyValueHandler(kd);
                keyType = type.getKeyType();
            }
            if ((cd = ctxt.deserializerInstance(member, cdDef = intr.findContentDeserializer(member))) != null) {
                type = type.withContentValueHandler(cd);
            }
            if (member instanceof AnnotatedMember && (contentTypeDeser = this.findPropertyContentTypeDeserializer(ctxt.getConfig(), type, member)) != null) {
                type = type.withContentTypeHandler(contentTypeDeser);
            }
        }
        if ((valueTypeDeser = member instanceof AnnotatedMember ? this.findPropertyTypeDeserializer(ctxt.getConfig(), type, member) : this.findTypeDeserializer(ctxt.getConfig(), type)) != null) {
            type = type.withTypeHandler(valueTypeDeser);
        }
        return type;
    }

    protected EnumResolver<?> constructEnumResolver(Class<?> enumClass, DeserializationConfig config, AnnotatedMethod jsonValueMethod) {
        if (jsonValueMethod != null) {
            Method accessor = jsonValueMethod.getAnnotated();
            if (config.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(accessor);
            }
            return EnumResolver.constructUnsafeUsingMethod(enumClass, accessor);
        }
        if (config.isEnabled(DeserializationFeature.READ_ENUMS_USING_TO_STRING)) {
            return EnumResolver.constructUnsafeUsingToString(enumClass);
        }
        return EnumResolver.constructUnsafe(enumClass, config.getAnnotationIntrospector());
    }

    static {
        BasicDeserializerFactory._add(_simpleDeserializers, Object.class, new UntypedObjectDeserializer());
        Serializable serializable = new StringDeserializer();
        BasicDeserializerFactory._add(_simpleDeserializers, String.class, serializable);
        BasicDeserializerFactory._add(_simpleDeserializers, CharSequence.class, serializable);
        BasicDeserializerFactory._add(_simpleDeserializers, NumberDeserializers.all());
        BasicDeserializerFactory._add(_simpleDeserializers, DateDeserializers.all());
        BasicDeserializerFactory._add(_simpleDeserializers, JdkDeserializers.all());
        BasicDeserializerFactory._add(_simpleDeserializers, JacksonDeserializers.all());
        _mapFallbacks = new HashMap();
        _mapFallbacks.put(Map.class.getName(), LinkedHashMap.class);
        _mapFallbacks.put(ConcurrentMap.class.getName(), ConcurrentHashMap.class);
        _mapFallbacks.put(SortedMap.class.getName(), TreeMap.class);
        _mapFallbacks.put("java.util.NavigableMap", TreeMap.class);
        try {
            Class<?> clazz;
            serializable = Class.forName("java.util.concurrent.ConcurrentNavigableMap");
            Class<?> clazz2 = clazz = Class.forName("java.util.concurrent.ConcurrentSkipListMap");
            _mapFallbacks.put(((Class)serializable).getName(), clazz2);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        _collectionFallbacks = new HashMap();
        _collectionFallbacks.put(Collection.class.getName(), ArrayList.class);
        _collectionFallbacks.put(List.class.getName(), ArrayList.class);
        _collectionFallbacks.put(Set.class.getName(), HashSet.class);
        _collectionFallbacks.put(SortedSet.class.getName(), TreeSet.class);
        _collectionFallbacks.put(Queue.class.getName(), LinkedList.class);
        _collectionFallbacks.put("java.util.Deque", LinkedList.class);
        _collectionFallbacks.put("java.util.NavigableSet", TreeSet.class);
    }
}

