/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.Request;
import com.amazonaws.SDKGlobalConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.internal.SdkDigestInputStream;
import com.amazonaws.util.Base64;
import com.amazonaws.util.HttpUtils;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class AbstractAWSSigner
implements Signer {
    protected String signAndBase64Encode(String string, String string2, SigningAlgorithm signingAlgorithm) throws AmazonClientException {
        return this.signAndBase64Encode(string.getBytes(StringUtils.UTF8), string2, signingAlgorithm);
    }

    protected String signAndBase64Encode(byte[] byArray, String string, SigningAlgorithm signingAlgorithm) throws AmazonClientException {
        try {
            byte[] byArray2 = this.sign(byArray, string.getBytes(StringUtils.UTF8), signingAlgorithm);
            return Base64.encodeAsString(byArray2);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to calculate a request signature: " + exception.getMessage(), exception);
        }
    }

    public byte[] sign(String string, byte[] byArray, SigningAlgorithm signingAlgorithm) throws AmazonClientException {
        try {
            byte[] byArray2 = string.getBytes(StringUtils.UTF8);
            return this.sign(byArray2, byArray, signingAlgorithm);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to calculate a request signature: " + exception.getMessage(), exception);
        }
    }

    protected byte[] sign(byte[] byArray, byte[] byArray2, SigningAlgorithm signingAlgorithm) throws AmazonClientException {
        try {
            Mac mac = Mac.getInstance(signingAlgorithm.toString());
            mac.init(new SecretKeySpec(byArray2, signingAlgorithm.toString()));
            return mac.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to calculate a request signature: " + exception.getMessage(), exception);
        }
    }

    public byte[] hash(String string) throws AmazonClientException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(string.getBytes(StringUtils.UTF8));
            return messageDigest.digest();
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to compute hash while signing request: " + exception.getMessage(), exception);
        }
    }

    protected byte[] hash(InputStream inputStream) throws AmazonClientException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            SdkDigestInputStream sdkDigestInputStream = new SdkDigestInputStream(inputStream, messageDigest);
            byte[] byArray = new byte[1024];
            while (sdkDigestInputStream.read(byArray) > -1) {
            }
            return sdkDigestInputStream.getMessageDigest().digest();
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to compute hash while signing request: " + exception.getMessage(), exception);
        }
    }

    public byte[] hash(byte[] byArray) throws AmazonClientException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to compute hash while signing request: " + exception.getMessage(), exception);
        }
    }

    protected String getCanonicalizedQueryString(Map<String, String> map) {
        Object object;
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> object22 : map.entrySet()) {
            object = object22.getKey();
            String string = object22.getValue();
            treeMap.put(HttpUtils.urlEncode((String)object, false), HttpUtils.urlEncode(string, false));
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            stringBuilder.append((String)object.getKey());
            stringBuilder.append("=");
            stringBuilder.append((String)object.getValue());
            if (!iterator.hasNext()) continue;
            stringBuilder.append("&");
        }
        return stringBuilder.toString();
    }

    protected String getCanonicalizedQueryString(Request<?> request) {
        if (HttpUtils.usePayloadForQueryParameters(request)) {
            return "";
        }
        return this.getCanonicalizedQueryString(request.getParameters());
    }

    protected byte[] getBinaryRequestPayload(Request<?> request) {
        if (HttpUtils.usePayloadForQueryParameters(request)) {
            String string = HttpUtils.encodeParameters(request);
            if (string == null) {
                return new byte[0];
            }
            return string.getBytes(StringUtils.UTF8);
        }
        return this.getBinaryRequestPayloadWithoutQueryParams(request);
    }

    protected String getRequestPayload(Request<?> request) {
        return this.newString(this.getBinaryRequestPayload(request));
    }

    protected String getRequestPayloadWithoutQueryParams(Request<?> request) {
        return this.newString(this.getBinaryRequestPayloadWithoutQueryParams(request));
    }

    protected byte[] getBinaryRequestPayloadWithoutQueryParams(Request<?> request) {
        InputStream inputStream = this.getBinaryRequestPayloadStreamWithoutQueryParams(request);
        try {
            int n;
            inputStream.mark(-1);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[5120];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.close();
            inputStream.reset();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to read request payload to sign request: " + exception.getMessage(), exception);
        }
    }

    protected InputStream getBinaryRequestPayloadStream(Request<?> request) {
        if (HttpUtils.usePayloadForQueryParameters(request)) {
            String string = HttpUtils.encodeParameters(request);
            if (string == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            return new ByteArrayInputStream(string.getBytes(StringUtils.UTF8));
        }
        return this.getBinaryRequestPayloadStreamWithoutQueryParams(request);
    }

    protected InputStream getBinaryRequestPayloadStreamWithoutQueryParams(Request<?> request) {
        try {
            InputStream inputStream = request.getContent();
            if (inputStream == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            if (inputStream instanceof StringInputStream) {
                return inputStream;
            }
            if (!inputStream.markSupported()) {
                throw new AmazonClientException("Unable to read request payload to sign request.");
            }
            return request.getContent();
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to read request payload to sign request: " + exception.getMessage(), exception);
        }
    }

    protected String getCanonicalizedResourcePath(String string) {
        return this.getCanonicalizedResourcePath(string, true);
    }

    protected String getCanonicalizedResourcePath(String string, boolean bl) {
        String string2;
        if (string == null || string.length() == 0) {
            return "/";
        }
        String string3 = string2 = bl ? HttpUtils.urlEncode(string, true) : string;
        if (string2.startsWith("/")) {
            return string2;
        }
        return "/".concat(string2);
    }

    protected String getCanonicalizedEndpoint(URI uRI) {
        String string = uRI.getHost().toLowerCase();
        if (HttpUtils.isUsingNonDefaultPort(uRI)) {
            string = string + ":" + uRI.getPort();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AWSCredentials sanitizeCredentials(AWSCredentials aWSCredentials) {
        String string = null;
        String string2 = null;
        String string3 = null;
        AWSCredentials aWSCredentials2 = aWSCredentials;
        synchronized (aWSCredentials2) {
            string = aWSCredentials.getAWSAccessKeyId();
            string2 = aWSCredentials.getAWSSecretKey();
            if (aWSCredentials instanceof AWSSessionCredentials) {
                string3 = ((AWSSessionCredentials)aWSCredentials).getSessionToken();
            }
        }
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (string != null) {
            string = string.trim();
        }
        if (string3 != null) {
            string3 = string3.trim();
        }
        if (aWSCredentials instanceof AWSSessionCredentials) {
            return new BasicSessionCredentials(string, string2, string3);
        }
        return new BasicAWSCredentials(string, string2);
    }

    protected String newString(byte[] byArray) {
        return new String(byArray, StringUtils.UTF8);
    }

    protected Date getSignatureDate(int n) {
        Date date = new Date();
        if (n != 0) {
            long l = date.getTime();
            date = new Date(l -= (long)(n * 1000));
        }
        return date;
    }

    protected int getTimeOffset(Request<?> request) {
        int n = request.getTimeOffset();
        if (SDKGlobalConfiguration.getGlobalTimeOffset() != 0) {
            n = SDKGlobalConfiguration.getGlobalTimeOffset();
        }
        return n;
    }

    protected abstract void addSessionCredentials(Request<?> var1, AWSSessionCredentials var2);
}

