/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.util.AWSRequestMetrics;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultRequest<T>
implements Request<T> {
    private String resourcePath;
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    private Map<String, String> headers = new HashMap<String, String>();
    private URI endpoint;
    private String serviceName;
    private final AmazonWebServiceRequest originalRequest;
    private HttpMethodName httpMethod = HttpMethodName.POST;
    private InputStream content;
    private int timeOffset;
    private AWSRequestMetrics metrics;

    public DefaultRequest(AmazonWebServiceRequest amazonWebServiceRequest, String string) {
        this.serviceName = string;
        this.originalRequest = amazonWebServiceRequest;
    }

    public DefaultRequest(String string) {
        this(null, string);
    }

    @Override
    public AmazonWebServiceRequest getOriginalRequest() {
        return this.originalRequest;
    }

    @Override
    public void addHeader(String string, String string2) {
        this.headers.put(string, string2);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void setResourcePath(String string) {
        this.resourcePath = string;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public void addParameter(String string, String string2) {
        this.parameters.put(string, string2);
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public Request<T> withParameter(String string, String string2) {
        this.addParameter(string, string2);
        return this;
    }

    @Override
    public HttpMethodName getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public void setHttpMethod(HttpMethodName httpMethodName) {
        this.httpMethod = httpMethodName;
    }

    @Override
    public void setEndpoint(URI uRI) {
        this.endpoint = uRI;
    }

    @Override
    public URI getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public InputStream getContent() {
        return this.content;
    }

    @Override
    public void setContent(InputStream inputStream) {
        this.content = inputStream;
    }

    @Override
    public void setHeaders(Map<String, String> map) {
        this.headers.clear();
        this.headers.putAll(map);
    }

    @Override
    public void setParameters(Map<String, String> map) {
        this.parameters.clear();
        this.parameters.putAll(map);
    }

    @Override
    public int getTimeOffset() {
        return this.timeOffset;
    }

    @Override
    public void setTimeOffset(int n) {
        this.timeOffset = n;
    }

    @Override
    public Request<T> withTimeOffset(int n) {
        this.setTimeOffset(n);
        return this;
    }

    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((Object)this.getHttpMethod()).append(" ");
        stringBuilder.append(this.getEndpoint()).append(" ");
        String string2 = this.getResourcePath();
        if (string2 == null) {
            stringBuilder.append("/");
        } else {
            if (!string2.startsWith("/")) {
                stringBuilder.append("/");
            }
            stringBuilder.append(string2);
        }
        stringBuilder.append(" ");
        if (!this.getParameters().isEmpty()) {
            stringBuilder.append("Parameters: (");
            for (String string3 : this.getParameters().keySet()) {
                string = this.getParameters().get(string3);
                stringBuilder.append(string3).append(": ").append(string).append(", ");
            }
            stringBuilder.append(") ");
        }
        if (!this.getHeaders().isEmpty()) {
            stringBuilder.append("Headers: (");
            for (String string3 : this.getHeaders().keySet()) {
                string = this.getHeaders().get(string3);
                stringBuilder.append(string3).append(": ").append(string).append(", ");
            }
            stringBuilder.append(") ");
        }
        return stringBuilder.toString();
    }

    @Override
    public AWSRequestMetrics getAWSRequestMetrics() {
        return this.metrics;
    }

    @Override
    public void setAWSRequestMetrics(AWSRequestMetrics aWSRequestMetrics) {
        if (this.metrics != null) {
            throw new IllegalStateException("AWSRequestMetrics has already been set on this request");
        }
        this.metrics = aWSRequestMetrics;
    }
}

