/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws;

import com.amazonaws.RequestClientOptions;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.metrics.RequestMetricCollector;
import java.util.HashMap;
import java.util.Map;

public abstract class AmazonWebServiceRequest {
    private final RequestClientOptions requestClientOptions = new RequestClientOptions();
    private RequestMetricCollector requestMetricCollector;
    private String delegationToken;
    private AWSCredentials credentials;

    @Deprecated
    public String getDelegationToken() {
        return this.delegationToken;
    }

    @Deprecated
    public void setDelegationToken(String string) {
        this.delegationToken = string;
    }

    public void setRequestCredentials(AWSCredentials aWSCredentials) {
        this.credentials = aWSCredentials;
    }

    public AWSCredentials getRequestCredentials() {
        return this.credentials;
    }

    public Map<String, String> copyPrivateRequestParameters() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.delegationToken != null) {
            hashMap.put("SecurityToken", this.delegationToken);
        }
        return hashMap;
    }

    public RequestClientOptions getRequestClientOptions() {
        return this.requestClientOptions;
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    public void setRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        this.requestMetricCollector = requestMetricCollector;
    }

    public <T extends AmazonWebServiceRequest> T withRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        this.setRequestMetricCollector(requestMetricCollector);
        AmazonWebServiceRequest amazonWebServiceRequest = this;
        return (T)amazonWebServiceRequest;
    }
}

