/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cognitoidentityprovider.model.AnalyticsMetadataType;
import com.amazonaws.services.cognitoidentityprovider.model.ChallengeNameType;
import com.amazonaws.services.cognitoidentityprovider.model.UserContextDataType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class RespondToAuthChallengeRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String clientId;
    private String challengeName;
    private String session;
    private Map<String, String> challengeResponses;
    private AnalyticsMetadataType analyticsMetadata;
    private UserContextDataType userContextData;

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public RespondToAuthChallengeRequest withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getChallengeName() {
        return this.challengeName;
    }

    public void setChallengeName(String challengeName) {
        this.challengeName = challengeName;
    }

    public RespondToAuthChallengeRequest withChallengeName(String challengeName) {
        this.challengeName = challengeName;
        return this;
    }

    public void setChallengeName(ChallengeNameType challengeName) {
        this.challengeName = challengeName.toString();
    }

    public RespondToAuthChallengeRequest withChallengeName(ChallengeNameType challengeName) {
        this.challengeName = challengeName.toString();
        return this;
    }

    public String getSession() {
        return this.session;
    }

    public void setSession(String session) {
        this.session = session;
    }

    public RespondToAuthChallengeRequest withSession(String session) {
        this.session = session;
        return this;
    }

    public Map<String, String> getChallengeResponses() {
        return this.challengeResponses;
    }

    public void setChallengeResponses(Map<String, String> challengeResponses) {
        this.challengeResponses = challengeResponses;
    }

    public RespondToAuthChallengeRequest withChallengeResponses(Map<String, String> challengeResponses) {
        this.challengeResponses = challengeResponses;
        return this;
    }

    public RespondToAuthChallengeRequest addChallengeResponsesEntry(String key, String value) {
        if (null == this.challengeResponses) {
            this.challengeResponses = new HashMap<String, String>();
        }
        if (this.challengeResponses.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.challengeResponses.put(key, value);
        return this;
    }

    public RespondToAuthChallengeRequest clearChallengeResponsesEntries() {
        this.challengeResponses = null;
        return this;
    }

    public AnalyticsMetadataType getAnalyticsMetadata() {
        return this.analyticsMetadata;
    }

    public void setAnalyticsMetadata(AnalyticsMetadataType analyticsMetadata) {
        this.analyticsMetadata = analyticsMetadata;
    }

    public RespondToAuthChallengeRequest withAnalyticsMetadata(AnalyticsMetadataType analyticsMetadata) {
        this.analyticsMetadata = analyticsMetadata;
        return this;
    }

    public UserContextDataType getUserContextData() {
        return this.userContextData;
    }

    public void setUserContextData(UserContextDataType userContextData) {
        this.userContextData = userContextData;
    }

    public RespondToAuthChallengeRequest withUserContextData(UserContextDataType userContextData) {
        this.userContextData = userContextData;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientId() != null) {
            sb.append("ClientId: " + this.getClientId() + ",");
        }
        if (this.getChallengeName() != null) {
            sb.append("ChallengeName: " + this.getChallengeName() + ",");
        }
        if (this.getSession() != null) {
            sb.append("Session: " + this.getSession() + ",");
        }
        if (this.getChallengeResponses() != null) {
            sb.append("ChallengeResponses: " + this.getChallengeResponses() + ",");
        }
        if (this.getAnalyticsMetadata() != null) {
            sb.append("AnalyticsMetadata: " + this.getAnalyticsMetadata() + ",");
        }
        if (this.getUserContextData() != null) {
            sb.append("UserContextData: " + this.getUserContextData());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientId() == null ? 0 : this.getClientId().hashCode());
        hashCode = 31 * hashCode + (this.getChallengeName() == null ? 0 : this.getChallengeName().hashCode());
        hashCode = 31 * hashCode + (this.getSession() == null ? 0 : this.getSession().hashCode());
        hashCode = 31 * hashCode + (this.getChallengeResponses() == null ? 0 : this.getChallengeResponses().hashCode());
        hashCode = 31 * hashCode + (this.getAnalyticsMetadata() == null ? 0 : this.getAnalyticsMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getUserContextData() == null ? 0 : this.getUserContextData().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RespondToAuthChallengeRequest)) {
            return false;
        }
        RespondToAuthChallengeRequest other = (RespondToAuthChallengeRequest)obj;
        if (other.getClientId() == null ^ this.getClientId() == null) {
            return false;
        }
        if (other.getClientId() != null && !other.getClientId().equals(this.getClientId())) {
            return false;
        }
        if (other.getChallengeName() == null ^ this.getChallengeName() == null) {
            return false;
        }
        if (other.getChallengeName() != null && !other.getChallengeName().equals(this.getChallengeName())) {
            return false;
        }
        if (other.getSession() == null ^ this.getSession() == null) {
            return false;
        }
        if (other.getSession() != null && !other.getSession().equals(this.getSession())) {
            return false;
        }
        if (other.getChallengeResponses() == null ^ this.getChallengeResponses() == null) {
            return false;
        }
        if (other.getChallengeResponses() != null && !other.getChallengeResponses().equals(this.getChallengeResponses())) {
            return false;
        }
        if (other.getAnalyticsMetadata() == null ^ this.getAnalyticsMetadata() == null) {
            return false;
        }
        if (other.getAnalyticsMetadata() != null && !other.getAnalyticsMetadata().equals(this.getAnalyticsMetadata())) {
            return false;
        }
        if (other.getUserContextData() == null ^ this.getUserContextData() == null) {
            return false;
        }
        return other.getUserContextData() == null || other.getUserContextData().equals(this.getUserContextData());
    }
}

