/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.services.cognitoidentityprovider.model.IdentityProviderType;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;

class IdentityProviderTypeJsonMarshaller {
    private static IdentityProviderTypeJsonMarshaller instance;

    IdentityProviderTypeJsonMarshaller() {
    }

    public void marshall(IdentityProviderType identityProviderType, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (identityProviderType.getUserPoolId() != null) {
            String userPoolId = identityProviderType.getUserPoolId();
            jsonWriter.name("UserPoolId");
            jsonWriter.value(userPoolId);
        }
        if (identityProviderType.getProviderName() != null) {
            String providerName = identityProviderType.getProviderName();
            jsonWriter.name("ProviderName");
            jsonWriter.value(providerName);
        }
        if (identityProviderType.getProviderType() != null) {
            String providerType = identityProviderType.getProviderType();
            jsonWriter.name("ProviderType");
            jsonWriter.value(providerType);
        }
        if (identityProviderType.getProviderDetails() != null) {
            Map<String, String> providerDetails = identityProviderType.getProviderDetails();
            jsonWriter.name("ProviderDetails");
            jsonWriter.beginObject();
            for (Map.Entry<String, String> entry : providerDetails.entrySet()) {
                String providerDetailsValue = entry.getValue();
                if (providerDetailsValue == null) continue;
                jsonWriter.name(entry.getKey());
                jsonWriter.value(providerDetailsValue);
            }
            jsonWriter.endObject();
        }
        if (identityProviderType.getAttributeMapping() != null) {
            Map<String, String> attributeMapping = identityProviderType.getAttributeMapping();
            jsonWriter.name("AttributeMapping");
            jsonWriter.beginObject();
            for (Map.Entry entry : attributeMapping.entrySet()) {
                String attributeMappingValue = (String)entry.getValue();
                if (attributeMappingValue == null) continue;
                jsonWriter.name((String)entry.getKey());
                jsonWriter.value(attributeMappingValue);
            }
            jsonWriter.endObject();
        }
        if (identityProviderType.getIdpIdentifiers() != null) {
            List<String> idpIdentifiers = identityProviderType.getIdpIdentifiers();
            jsonWriter.name("IdpIdentifiers");
            jsonWriter.beginArray();
            for (String string : idpIdentifiers) {
                if (string == null) continue;
                jsonWriter.value(string);
            }
            jsonWriter.endArray();
        }
        if (identityProviderType.getLastModifiedDate() != null) {
            Date lastModifiedDate = identityProviderType.getLastModifiedDate();
            jsonWriter.name("LastModifiedDate");
            jsonWriter.value(lastModifiedDate);
        }
        if (identityProviderType.getCreationDate() != null) {
            Date creationDate = identityProviderType.getCreationDate();
            jsonWriter.name("CreationDate");
            jsonWriter.value(creationDate);
        }
        jsonWriter.endObject();
    }

    public static IdentityProviderTypeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new IdentityProviderTypeJsonMarshaller();
        }
        return instance;
    }
}

