/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.services.cognitoidentityprovider.model.EventContextDataType;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class EventContextDataTypeJsonUnmarshaller
implements Unmarshaller<EventContextDataType, JsonUnmarshallerContext> {
    private static EventContextDataTypeJsonUnmarshaller instance;

    EventContextDataTypeJsonUnmarshaller() {
    }

    public EventContextDataType unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        EventContextDataType eventContextDataType = new EventContextDataType();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("IpAddress")) {
                eventContextDataType.setIpAddress(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("DeviceName")) {
                eventContextDataType.setDeviceName(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Timezone")) {
                eventContextDataType.setTimezone(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("City")) {
                eventContextDataType.setCity(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Country")) {
                eventContextDataType.setCountry(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return eventContextDataType;
    }

    public static EventContextDataTypeJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EventContextDataTypeJsonUnmarshaller();
        }
        return instance;
    }
}

