/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class VerifySoftwareTokenRequestMarshaller
implements Marshaller<Request<VerifySoftwareTokenRequest>, VerifySoftwareTokenRequest> {
    public Request<VerifySoftwareTokenRequest> marshall(VerifySoftwareTokenRequest verifySoftwareTokenRequest) {
        if (verifySoftwareTokenRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(VerifySoftwareTokenRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)verifySoftwareTokenRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.VerifySoftwareToken";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (verifySoftwareTokenRequest.getAccessToken() != null) {
                String accessToken = verifySoftwareTokenRequest.getAccessToken();
                jsonWriter.name("AccessToken");
                jsonWriter.value(accessToken);
            }
            if (verifySoftwareTokenRequest.getSession() != null) {
                String session = verifySoftwareTokenRequest.getSession();
                jsonWriter.name("Session");
                jsonWriter.value(session);
            }
            if (verifySoftwareTokenRequest.getUserCode() != null) {
                String userCode = verifySoftwareTokenRequest.getUserCode();
                jsonWriter.name("UserCode");
                jsonWriter.value(userCode);
            }
            if (verifySoftwareTokenRequest.getFriendlyDeviceName() != null) {
                String friendlyDeviceName = verifySoftwareTokenRequest.getFriendlyDeviceName();
                jsonWriter.name("FriendlyDeviceName");
                jsonWriter.value(friendlyDeviceName);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

