/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider;

import com.amazonaws.services.cognitoidentityprovider.model.MFAOptionType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CognitoUserSettings {
    private Map<String, String> userSettings = new HashMap<String, String>();

    public CognitoUserSettings() {
        this(null);
    }

    protected CognitoUserSettings(List<MFAOptionType> userSettingsList) {
        if (userSettingsList != null) {
            for (MFAOptionType option : userSettingsList) {
                this.userSettings.put(option.getAttributeName().toString(), option.getDeliveryMedium().toString());
            }
        }
    }

    protected List<MFAOptionType> getSettingsList() {
        ArrayList<MFAOptionType> settingsList = new ArrayList<MFAOptionType>();
        if (this.userSettings != null) {
            for (Map.Entry<String, String> detail : this.userSettings.entrySet()) {
                MFAOptionType option = new MFAOptionType();
                option.setAttributeName(detail.getKey());
                option.setDeliveryMedium(detail.getValue());
                settingsList.add(option);
            }
        }
        return settingsList;
    }

    public Map<String, String> getSettings() {
        return this.userSettings;
    }

    public void setSettings(String attributeName, String option) {
        this.userSettings.put(attributeName, option);
    }
}

