/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider.util;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CognitoPinpointSharedContext {
    private static final Log LOGGER = LogFactory.getLog(CognitoPinpointSharedContext.class);
    private static final String UNIQUE_ID_KEY = "UniqueId";
    private static final String PREFERENCES_AND_FILE_MANAGER_SUFFIX = "515d6767-01b7-49e5-8273-c8d11b0f331d";

    public static String getPinpointEndpoint(Context context, String pinpointAppId) {
        return CognitoPinpointSharedContext.getPinpointEndpoint(context, pinpointAppId, UNIQUE_ID_KEY);
    }

    public static String getPinpointEndpoint(Context context, String pinpointAppId, String pinpointEndpointIdentifier) {
        if (context == null || pinpointAppId == null || pinpointEndpointIdentifier == null) {
            return null;
        }
        try {
            SharedPreferences pinpointPreferences = context.getSharedPreferences(pinpointAppId + PREFERENCES_AND_FILE_MANAGER_SUFFIX, 0);
            String pinpointEndpointId = pinpointPreferences.getString(pinpointEndpointIdentifier, null);
            if (pinpointEndpointId == null) {
                pinpointEndpointId = UUID.randomUUID().toString();
                SharedPreferences.Editor pinpointSharedPrefsEditor = pinpointPreferences.edit();
                pinpointSharedPrefsEditor.putString(pinpointEndpointIdentifier, pinpointEndpointId).apply();
            }
            return pinpointEndpointId;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while reading from SharedPreferences", (Throwable)e);
            return null;
        }
    }
}

