/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider.util;

import com.amazonaws.mobileconnectors.cognitoidentityprovider.exceptions.CognitoInternalErrorException;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.exceptions.CognitoParameterInvalidException;
import com.amazonaws.util.Base64;
import com.amazonaws.util.StringUtils;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class CognitoSecretHash {
    private static final String HMAC_SHA_256 = "HmacSHA256";

    public static String getSecretHash(String userId, String clientId, String clientSecret) {
        if (userId == null) {
            throw new CognitoParameterInvalidException("user ID cannot be null");
        }
        if (clientId == null) {
            throw new CognitoParameterInvalidException("client ID cannot be null");
        }
        if (clientSecret == null) {
            return null;
        }
        SecretKeySpec signingKey = new SecretKeySpec(clientSecret.getBytes(StringUtils.UTF8), HMAC_SHA_256);
        try {
            Mac mac = Mac.getInstance(HMAC_SHA_256);
            mac.init(signingKey);
            mac.update(userId.getBytes(StringUtils.UTF8));
            byte[] rawHmac = mac.doFinal(clientId.getBytes(StringUtils.UTF8));
            return new String(Base64.encode((byte[])rawHmac));
        }
        catch (Exception e) {
            throw new CognitoInternalErrorException("errors in HMAC calculation");
        }
    }
}

