/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.cognito.clientcontext.datacollection;

import android.content.Context;
import com.amazonaws.cognito.clientcontext.datacollection.ApplicationDataCollector;
import com.amazonaws.cognito.clientcontext.datacollection.BuildDataCollector;
import com.amazonaws.cognito.clientcontext.datacollection.DataCollector;
import com.amazonaws.cognito.clientcontext.datacollection.DeviceDataCollector;
import com.amazonaws.cognito.clientcontext.datacollection.TelephonyDataCollector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContextDataAggregator {
    private final List<DataCollector> dataCollectors;

    private ContextDataAggregator() {
        this.dataCollectors = this.getDataCollectors();
    }

    protected ContextDataAggregator(List<DataCollector> dataCollectors) {
        this.dataCollectors = dataCollectors;
    }

    public static ContextDataAggregator getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public Map<String, String> getAggregatedData(Context context) {
        HashMap<String, String> userContextData = new HashMap<String, String>();
        for (DataCollector collector : this.dataCollectors) {
            Map<String, String> data = collector.collect(context);
            userContextData.putAll(data);
        }
        this.removerNullEntries(userContextData);
        return userContextData;
    }

    private void removerNullEntries(Map<String, String> data) {
        for (Map.Entry<String, String> entry : data.entrySet()) {
            if (entry.getValue() != null) continue;
            data.remove(entry.getKey());
        }
    }

    private List<DataCollector> getDataCollectors() {
        ArrayList<DataCollector> availableDataCollectors = new ArrayList<DataCollector>();
        availableDataCollectors.add(new ApplicationDataCollector());
        availableDataCollectors.add(new BuildDataCollector());
        availableDataCollectors.add(new DeviceDataCollector());
        availableDataCollectors.add(new TelephonyDataCollector());
        return availableDataCollectors;
    }

    private static class InstanceHolder {
        private static final ContextDataAggregator INSTANCE = new ContextDataAggregator();

        private InstanceHolder() {
        }
    }
}

