/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations;

import android.content.Context;
import android.os.Handler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUser;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserCodeDeliveryDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.CognitoIdentityProviderContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.AuthenticationHandler;
import com.amazonaws.services.cognitoidentityprovider.model.RespondToAuthChallengeResult;

public class MultiFactorAuthenticationContinuation
implements CognitoIdentityProviderContinuation<CognitoUserCodeDeliveryDetails> {
    public static final boolean RUN_IN_BACKGROUND = true;
    public static final boolean RUN_IN_CURRENT = false;
    private final CognitoUser user;
    private final Context context;
    private final RespondToAuthChallengeResult challenge;
    private final boolean runInBackground;
    private final AuthenticationHandler callback;
    private String mfaCode = null;

    public MultiFactorAuthenticationContinuation(CognitoUser user, Context context, RespondToAuthChallengeResult challenge, boolean runInBackground, AuthenticationHandler callback) {
        this.user = user;
        this.context = context;
        this.callback = callback;
        this.runInBackground = runInBackground;
        this.challenge = challenge;
    }

    @Override
    public CognitoUserCodeDeliveryDetails getParameters() {
        return new CognitoUserCodeDeliveryDetails(this.challenge.getChallengeParameters().get("CODE_DELIVERY_DESTINATION"), this.challenge.getChallengeParameters().get("CODE_DELIVERY_DELIVERY_MEDIUM"), null);
    }

    @Override
    public void continueTask() {
        if (this.runInBackground) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Runnable nextStep;
                    Handler handler = new Handler(MultiFactorAuthenticationContinuation.this.context.getMainLooper());
                    try {
                        nextStep = MultiFactorAuthenticationContinuation.this.user.respondToMfaChallenge(MultiFactorAuthenticationContinuation.this.mfaCode, MultiFactorAuthenticationContinuation.this.challenge, MultiFactorAuthenticationContinuation.this.callback, true);
                    }
                    catch (Exception e) {
                        nextStep = new Runnable(){

                            @Override
                            public void run() {
                                MultiFactorAuthenticationContinuation.this.callback.onFailure(e);
                            }
                        };
                    }
                    handler.post(nextStep);
                }
            }).start();
        } else {
            Runnable nextStep;
            try {
                nextStep = this.user.respondToMfaChallenge(this.mfaCode, this.challenge, this.callback, false);
            }
            catch (Exception e) {
                nextStep = new Runnable(){

                    @Override
                    public void run() {
                        MultiFactorAuthenticationContinuation.this.callback.onFailure(e);
                    }
                };
            }
            nextStep.run();
        }
    }

    public void setMfaCode(String mfaCode) {
        this.mfaCode = mfaCode;
    }
}

