/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider.tokens;

import com.amazonaws.mobileconnectors.cognitoidentityprovider.exceptions.CognitoInternalErrorException;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.tokens.CognitoUserToken;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.util.CognitoJWTParser;
import java.util.Date;

public class CognitoAccessToken
extends CognitoUserToken {
    public CognitoAccessToken(String jwtToken) {
        super(jwtToken);
    }

    public String getJWTToken() {
        return super.getToken();
    }

    public Date getExpiration() {
        try {
            String claim = CognitoJWTParser.getClaim(super.getToken(), "exp");
            if (claim == null) {
                return null;
            }
            long epocTimeSec = Long.parseLong(claim);
            long epocTimeMilliSec = epocTimeSec * 1000L;
            return new Date(epocTimeMilliSec);
        }
        catch (Exception e) {
            throw new CognitoInternalErrorException(e.getMessage());
        }
    }
}

