/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider;

import com.amazonaws.SDKGlobalConfiguration;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.tokens.CognitoAccessToken;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.tokens.CognitoIdToken;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.tokens.CognitoRefreshToken;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.util.CognitoIdentityProviderClientConfig;
import java.util.Date;

public class CognitoUserSession {
    private CognitoIdToken idToken;
    private CognitoAccessToken accessToken;
    private CognitoRefreshToken refreshToken;

    public CognitoUserSession(CognitoIdToken idToken, CognitoAccessToken accessToken, CognitoRefreshToken refreshToken) {
        this.idToken = idToken;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
    }

    public CognitoIdToken getIdToken() {
        return this.idToken;
    }

    public CognitoAccessToken getAccessToken() {
        return this.accessToken;
    }

    public CognitoRefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    public boolean isValid() {
        Date currentTimeStamp = new Date();
        try {
            return currentTimeStamp.before(this.idToken.getExpiration()) & currentTimeStamp.before(this.accessToken.getExpiration());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isValidForThreshold() {
        try {
            long currentTime = System.currentTimeMillis() - (long)(SDKGlobalConfiguration.getGlobalTimeOffset() * 1000);
            long expiresInMilliSeconds = this.idToken.getExpiration().getTime() - currentTime;
            return expiresInMilliSeconds > CognitoIdentityProviderClientConfig.getRefreshThreshold();
        }
        catch (Exception e) {
            return false;
        }
    }
}

