/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.GetJWKSRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetJWKSRequestMarshaller
implements Marshaller<Request<GetJWKSRequest>, GetJWKSRequest> {
    public Request<GetJWKSRequest> marshall(GetJWKSRequest getJWKSRequest) {
        if (getJWKSRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetJWKSRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getJWKSRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.GetJWKS";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{userPoolId}/.well-known/jwks.json";
        uriResourcePath = uriResourcePath.replace("{userPoolId}", getJWKSRequest.getUserPoolId() == null ? "" : StringUtils.fromString((String)getJWKSRequest.getUserPoolId()));
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

