/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.SignUpRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class SignUpRequestMarshaller
implements Marshaller<Request<SignUpRequest>, SignUpRequest> {
    public Request<SignUpRequest> marshall(SignUpRequest signUpRequest) {
        if (signUpRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)signUpRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.SignUp";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag validationDataList;
            ListWithAutoConstructFlag userAttributesList;
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (signUpRequest.getClientId() != null) {
                jsonWriter.name("ClientId").value(signUpRequest.getClientId());
            }
            if (signUpRequest.getSecretHash() != null) {
                jsonWriter.name("SecretHash").value(signUpRequest.getSecretHash());
            }
            if (signUpRequest.getUsername() != null) {
                jsonWriter.name("Username").value(signUpRequest.getUsername());
            }
            if (signUpRequest.getPassword() != null) {
                jsonWriter.name("Password").value(signUpRequest.getPassword());
            }
            if (!((userAttributesList = (ListWithAutoConstructFlag)signUpRequest.getUserAttributes()) == null || userAttributesList.isAutoConstruct() && userAttributesList.isEmpty())) {
                jsonWriter.name("UserAttributes");
                jsonWriter.beginArray();
                for (Object userAttributesListValue : userAttributesList) {
                    if (userAttributesListValue == null) continue;
                    jsonWriter.beginObject();
                    if (((AttributeType)userAttributesListValue).getName() != null) {
                        jsonWriter.name("Name").value(((AttributeType)userAttributesListValue).getName());
                    }
                    if (((AttributeType)userAttributesListValue).getValue() != null) {
                        jsonWriter.name("Value").value(((AttributeType)userAttributesListValue).getValue());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (!((validationDataList = (ListWithAutoConstructFlag)signUpRequest.getValidationData()) == null || validationDataList.isAutoConstruct() && validationDataList.isEmpty())) {
                jsonWriter.name("ValidationData");
                jsonWriter.beginArray();
                for (AttributeType validationDataListValue : validationDataList) {
                    if (validationDataListValue == null) continue;
                    jsonWriter.beginObject();
                    if (validationDataListValue.getName() != null) {
                        jsonWriter.name("Name").value(validationDataListValue.getName());
                    }
                    if (validationDataListValue.getValue() != null) {
                        jsonWriter.name("Value").value(validationDataListValue.getValue());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

