/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.GetAuthenticationDetailsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class GetAuthenticationDetailsRequestMarshaller
implements Marshaller<Request<GetAuthenticationDetailsRequest>, GetAuthenticationDetailsRequest> {
    public Request<GetAuthenticationDetailsRequest> marshall(GetAuthenticationDetailsRequest getAuthenticationDetailsRequest) {
        if (getAuthenticationDetailsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getAuthenticationDetailsRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.GetAuthenticationDetails";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag validationDataList;
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (getAuthenticationDetailsRequest.getClientId() != null) {
                jsonWriter.name("ClientId").value(getAuthenticationDetailsRequest.getClientId());
            }
            if (getAuthenticationDetailsRequest.getSecretHash() != null) {
                jsonWriter.name("SecretHash").value(getAuthenticationDetailsRequest.getSecretHash());
            }
            if (getAuthenticationDetailsRequest.getUsername() != null) {
                jsonWriter.name("Username").value(getAuthenticationDetailsRequest.getUsername());
            }
            if (getAuthenticationDetailsRequest.getSrpA() != null) {
                jsonWriter.name("SrpA").value(getAuthenticationDetailsRequest.getSrpA());
            }
            if (!((validationDataList = (ListWithAutoConstructFlag)getAuthenticationDetailsRequest.getValidationData()) == null || validationDataList.isAutoConstruct() && validationDataList.isEmpty())) {
                jsonWriter.name("ValidationData");
                jsonWriter.beginArray();
                for (AttributeType validationDataListValue : validationDataList) {
                    if (validationDataListValue == null) continue;
                    jsonWriter.beginObject();
                    if (validationDataListValue.getName() != null) {
                        jsonWriter.name("Name").value(validationDataListValue.getName());
                    }
                    if (validationDataListValue.getValue() != null) {
                        jsonWriter.name("Value").value(validationDataListValue.getValue());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

