/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitoidentityprovider.model.UserStatusType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListUsersRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String userPoolId;
    private ListWithAutoConstructFlag<String> attributesToGet;
    private Integer limit;
    private String paginationToken;
    private String userStatus;

    public String getUserPoolId() {
        return this.userPoolId;
    }

    public void setUserPoolId(String userPoolId) {
        this.userPoolId = userPoolId;
    }

    public ListUsersRequest withUserPoolId(String userPoolId) {
        this.userPoolId = userPoolId;
        return this;
    }

    public List<String> getAttributesToGet() {
        if (this.attributesToGet == null) {
            this.attributesToGet = new ListWithAutoConstructFlag();
            this.attributesToGet.setAutoConstruct(true);
        }
        return this.attributesToGet;
    }

    public void setAttributesToGet(Collection<String> attributesToGet) {
        if (attributesToGet == null) {
            this.attributesToGet = null;
            return;
        }
        ListWithAutoConstructFlag attributesToGetCopy = new ListWithAutoConstructFlag(attributesToGet.size());
        attributesToGetCopy.addAll(attributesToGet);
        this.attributesToGet = attributesToGetCopy;
    }

    public ListUsersRequest withAttributesToGet(String ... attributesToGet) {
        if (this.getAttributesToGet() == null) {
            this.setAttributesToGet(new ArrayList<String>(attributesToGet.length));
        }
        for (String value : attributesToGet) {
            this.getAttributesToGet().add(value);
        }
        return this;
    }

    public ListUsersRequest withAttributesToGet(Collection<String> attributesToGet) {
        if (attributesToGet == null) {
            this.attributesToGet = null;
        } else {
            ListWithAutoConstructFlag attributesToGetCopy = new ListWithAutoConstructFlag(attributesToGet.size());
            attributesToGetCopy.addAll(attributesToGet);
            this.attributesToGet = attributesToGetCopy;
        }
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public ListUsersRequest withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public String getPaginationToken() {
        return this.paginationToken;
    }

    public void setPaginationToken(String paginationToken) {
        this.paginationToken = paginationToken;
    }

    public ListUsersRequest withPaginationToken(String paginationToken) {
        this.paginationToken = paginationToken;
        return this;
    }

    public String getUserStatus() {
        return this.userStatus;
    }

    public void setUserStatus(String userStatus) {
        this.userStatus = userStatus;
    }

    public ListUsersRequest withUserStatus(String userStatus) {
        this.userStatus = userStatus;
        return this;
    }

    public void setUserStatus(UserStatusType userStatus) {
        this.userStatus = userStatus.toString();
    }

    public ListUsersRequest withUserStatus(UserStatusType userStatus) {
        this.userStatus = userStatus.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserPoolId() != null) {
            sb.append("UserPoolId: " + this.getUserPoolId() + ",");
        }
        if (this.getAttributesToGet() != null) {
            sb.append("AttributesToGet: " + this.getAttributesToGet() + ",");
        }
        if (this.getLimit() != null) {
            sb.append("Limit: " + this.getLimit() + ",");
        }
        if (this.getPaginationToken() != null) {
            sb.append("PaginationToken: " + this.getPaginationToken() + ",");
        }
        if (this.getUserStatus() != null) {
            sb.append("UserStatus: " + this.getUserStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserPoolId() == null ? 0 : this.getUserPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getAttributesToGet() == null ? 0 : this.getAttributesToGet().hashCode());
        hashCode = 31 * hashCode + (this.getLimit() == null ? 0 : this.getLimit().hashCode());
        hashCode = 31 * hashCode + (this.getPaginationToken() == null ? 0 : this.getPaginationToken().hashCode());
        hashCode = 31 * hashCode + (this.getUserStatus() == null ? 0 : this.getUserStatus().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsersRequest)) {
            return false;
        }
        ListUsersRequest other = (ListUsersRequest)obj;
        if (other.getUserPoolId() == null ^ this.getUserPoolId() == null) {
            return false;
        }
        if (other.getUserPoolId() != null && !other.getUserPoolId().equals(this.getUserPoolId())) {
            return false;
        }
        if (other.getAttributesToGet() == null ^ this.getAttributesToGet() == null) {
            return false;
        }
        if (other.getAttributesToGet() != null && !other.getAttributesToGet().equals(this.getAttributesToGet())) {
            return false;
        }
        if (other.getLimit() == null ^ this.getLimit() == null) {
            return false;
        }
        if (other.getLimit() != null && !other.getLimit().equals(this.getLimit())) {
            return false;
        }
        if (other.getPaginationToken() == null ^ this.getPaginationToken() == null) {
            return false;
        }
        if (other.getPaginationToken() != null && !other.getPaginationToken().equals(this.getPaginationToken())) {
            return false;
        }
        if (other.getUserStatus() == null ^ this.getUserStatus() == null) {
            return false;
        }
        return other.getUserStatus() == null || other.getUserStatus().equals(this.getUserStatus());
    }
}

