/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.util.Log;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserAttributes;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserCodeDeliveryDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserPool;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserSession;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserSettings;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.AuthenticationContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.AuthenticationDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.ForgotPasswordContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.MultiFactorAuthenticationContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.exceptions.CognitoInternalErrorException;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.exceptions.CognitoNotAuthorizedException;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.exceptions.CognitoParameterInvalidException;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.AuthenticationHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.ForgotPasswordHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.GenericHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.GetDetailsHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.UpdateAttributesHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.VerificationHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.tokens.CognitoAccessToken;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.tokens.CognitoIdToken;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.tokens.CognitoRefreshToken;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.util.CognitoSecretHash;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.util.Hkdf;
import com.amazonaws.services.cognitoidentityprovider.AmazonCognitoIdentityProvider;
import com.amazonaws.services.cognitoidentityprovider.model.AuthenticateRequest;
import com.amazonaws.services.cognitoidentityprovider.model.AuthenticateResult;
import com.amazonaws.services.cognitoidentityprovider.model.AuthenticationResultType;
import com.amazonaws.services.cognitoidentityprovider.model.ChangePasswordRequest;
import com.amazonaws.services.cognitoidentityprovider.model.CodeDeliveryDetailsType;
import com.amazonaws.services.cognitoidentityprovider.model.CodeMismatchException;
import com.amazonaws.services.cognitoidentityprovider.model.ConfirmForgotPasswordRequest;
import com.amazonaws.services.cognitoidentityprovider.model.ConfirmSignUpRequest;
import com.amazonaws.services.cognitoidentityprovider.model.DeleteUserAttributesRequest;
import com.amazonaws.services.cognitoidentityprovider.model.DeleteUserRequest;
import com.amazonaws.services.cognitoidentityprovider.model.EnhanceAuthRequest;
import com.amazonaws.services.cognitoidentityprovider.model.EnhanceAuthResult;
import com.amazonaws.services.cognitoidentityprovider.model.ForgotPasswordRequest;
import com.amazonaws.services.cognitoidentityprovider.model.ForgotPasswordResult;
import com.amazonaws.services.cognitoidentityprovider.model.GetAuthenticationDetailsRequest;
import com.amazonaws.services.cognitoidentityprovider.model.GetAuthenticationDetailsResult;
import com.amazonaws.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest;
import com.amazonaws.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResult;
import com.amazonaws.services.cognitoidentityprovider.model.GetUserRequest;
import com.amazonaws.services.cognitoidentityprovider.model.GetUserResult;
import com.amazonaws.services.cognitoidentityprovider.model.InvalidParameterException;
import com.amazonaws.services.cognitoidentityprovider.model.PasswordClaimType;
import com.amazonaws.services.cognitoidentityprovider.model.RefreshTokensRequest;
import com.amazonaws.services.cognitoidentityprovider.model.RefreshTokensResult;
import com.amazonaws.services.cognitoidentityprovider.model.ResendConfirmationCodeRequest;
import com.amazonaws.services.cognitoidentityprovider.model.ResendConfirmationCodeResult;
import com.amazonaws.services.cognitoidentityprovider.model.SetUserSettingsRequest;
import com.amazonaws.services.cognitoidentityprovider.model.SetUserSettingsResult;
import com.amazonaws.services.cognitoidentityprovider.model.UpdateUserAttributesRequest;
import com.amazonaws.services.cognitoidentityprovider.model.UpdateUserAttributesResult;
import com.amazonaws.services.cognitoidentityprovider.model.VerifyUserAttributeRequest;
import com.amazonaws.services.cognitoidentityprovider.model.VerifyUserAttributeResult;
import com.amazonaws.util.StringUtils;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class CognitoUser {
    private final String TAG = "CognitoUser";
    private final Context context;
    private final AmazonCognitoIdentityProvider cognitoIdentityProviderClient;
    private final String clientId;
    private final String clientSecret;
    private String userId;
    private String usernameInternal;
    private CognitoUserPool pool;
    private String secretHash;
    private CognitoUserSession cipSession;

    protected CognitoUser(CognitoUserPool pool, String userId, String clientId, String clientSecret, String secretHash, AmazonCognitoIdentityProvider client, Context context) {
        this.pool = pool;
        this.context = context;
        this.userId = userId;
        this.cognitoIdentityProviderClient = client;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.secretHash = secretHash;
        this.cipSession = null;
    }

    public String getUserId() {
        return this.userId;
    }

    public void confirmSignUpInBackground(final String confirmationCode, final boolean forcedAliasCreation, final GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUser.this.confirmSignUpInternal(confirmationCode, forcedAliasCreation);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void confirmSignUp(String confirmationCode, boolean forcedAliasCreation, GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            this.confirmSignUpInternal(confirmationCode, forcedAliasCreation);
            callback.onSuccess();
        }
        catch (AmazonServiceException e) {
            callback.onFailure((Exception)((Object)e));
        }
    }

    private void confirmSignUpInternal(String confirmationCode, boolean forcedAliasCreation) {
        ConfirmSignUpRequest confirmUserRegistrationRequest = new ConfirmSignUpRequest();
        confirmUserRegistrationRequest.setClientId(this.clientId);
        confirmUserRegistrationRequest.setSecretHash(this.secretHash);
        confirmUserRegistrationRequest.setUsername(this.userId);
        confirmUserRegistrationRequest.setConfirmationCode(confirmationCode);
        confirmUserRegistrationRequest.setForceAliasCreation(forcedAliasCreation);
        this.cognitoIdentityProviderClient.confirmSignUp(confirmUserRegistrationRequest);
    }

    public void resendConfirmationCodeInBackground(final VerificationHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    final ResendConfirmationCodeResult resendConfirmationCodeResult = CognitoUser.this.resendConfirmationCodeInternal();
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(new CognitoUserCodeDeliveryDetails(resendConfirmationCodeResult.getCodeDeliveryDetails()));
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void resendConfirmationCode(VerificationHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            ResendConfirmationCodeResult resendConfirmationCodeResult = this.resendConfirmationCodeInternal();
            callback.onSuccess(new CognitoUserCodeDeliveryDetails(resendConfirmationCodeResult.getCodeDeliveryDetails()));
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private ResendConfirmationCodeResult resendConfirmationCodeInternal() {
        ResendConfirmationCodeRequest resendConfirmationCodeRequest = new ResendConfirmationCodeRequest();
        resendConfirmationCodeRequest.setUsername(this.userId);
        resendConfirmationCodeRequest.setClientId(this.clientId);
        resendConfirmationCodeRequest.setSecretHash(this.secretHash);
        return this.cognitoIdentityProviderClient.resendConfirmationCode(resendConfirmationCodeRequest);
    }

    public void forgotPasswordInBackground(final ForgotPasswordHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser cognitoUser = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    ForgotPasswordResult forgotPasswordResult = CognitoUser.this.forgotPasswordInternal();
                    final ForgotPasswordContinuation continuation = new ForgotPasswordContinuation(cognitoUser, new CognitoUserCodeDeliveryDetails(forgotPasswordResult.getCodeDeliveryDetails()), true, callback);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.getResetCode(continuation);
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void forgotPassword(ForgotPasswordHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        CognitoUser cognitoUser = this;
        try {
            ForgotPasswordResult forgotPasswordResult = this.forgotPasswordInternal();
            ForgotPasswordContinuation continuation = new ForgotPasswordContinuation(cognitoUser, new CognitoUserCodeDeliveryDetails(forgotPasswordResult.getCodeDeliveryDetails()), false, callback);
            callback.getResetCode(continuation);
        }
        catch (AmazonServiceException e) {
            callback.onFailure((Exception)((Object)e));
        }
    }

    private ForgotPasswordResult forgotPasswordInternal() {
        ForgotPasswordRequest resetPasswordRequest = new ForgotPasswordRequest();
        resetPasswordRequest.setClientId(this.clientId);
        resetPasswordRequest.setSecretHash(this.secretHash);
        resetPasswordRequest.setUsername(this.userId);
        return this.cognitoIdentityProviderClient.forgotPassword(resetPasswordRequest);
    }

    public void confirmPasswordInBackground(final String verificationCode, final String newPassword, final ForgotPasswordHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUser.this.confirmPasswordInternal(verificationCode, newPassword);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    };
                }
                catch (AmazonServiceException e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure((Exception)((Object)e));
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void confirmPassword(String verificationCode, String newPassword, ForgotPasswordHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            this.confirmPasswordInternal(verificationCode, newPassword);
            callback.onSuccess();
        }
        catch (AmazonServiceException e) {
            callback.onFailure((Exception)((Object)e));
        }
    }

    private void confirmPasswordInternal(String verificationCode, String newPassword) {
        ConfirmForgotPasswordRequest confirmResetPasswordRequest = new ConfirmForgotPasswordRequest();
        confirmResetPasswordRequest.setUsername(this.userId);
        confirmResetPasswordRequest.setClientId(this.clientId);
        confirmResetPasswordRequest.setSecretHash(this.secretHash);
        confirmResetPasswordRequest.setConfirmationCode(verificationCode);
        confirmResetPasswordRequest.setPassword(newPassword);
        this.cognitoIdentityProviderClient.confirmForgotPassword(confirmResetPasswordRequest);
    }

    public void getSessionInBackground(final AuthenticationHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser cognitoUser = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUser.this.getCachedSession();
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(CognitoUser.this.cipSession);
                        }
                    };
                }
                catch (CognitoNotAuthorizedException e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            AuthenticationContinuation authenticationContinuation = new AuthenticationContinuation(cognitoUser, true, callback);
                            callback.getAuthenticationDetails(authenticationContinuation, cognitoUser.getUserId());
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void getSession(AuthenticationHandler callback) {
        if (callback == null) {
            throw new InvalidParameterException("callback is null");
        }
        try {
            this.getCachedSession();
            callback.onSuccess(this.cipSession);
        }
        catch (InvalidParameterException e) {
            callback.onFailure((Exception)((Object)e));
        }
        catch (CognitoNotAuthorizedException e) {
            AuthenticationContinuation authenticationContinuation = new AuthenticationContinuation(this, false, callback);
            callback.getAuthenticationDetails(authenticationContinuation, this.getUserId());
        }
        catch (Exception e) {
            callback.onFailure((Exception)((Object)new AmazonServiceException(e.getMessage())));
        }
    }

    private CognitoUserSession getCachedSession() {
        if (this.userId == null) {
            throw new CognitoNotAuthorizedException("User-ID is null");
        }
        if (this.cipSession != null && this.cipSession.isValid()) {
            return this.cipSession;
        }
        CognitoUserSession cachedTokens = this.readCachedTokens();
        if (cachedTokens.isValid()) {
            this.cipSession = cachedTokens;
            return this.cipSession;
        }
        this.clearCachedTokens();
        if (cachedTokens.getRefreshToken() != null) {
            try {
                this.cipSession = this.refreshSessionInternal(cachedTokens.getRefreshToken());
                this.cacheTokens(this.cipSession);
                return this.cipSession;
            }
            catch (Exception e) {
                throw new CognitoNotAuthorizedException("user is not authenticated");
            }
        }
        throw new CognitoNotAuthorizedException("user is not authenticated");
    }

    public void authenticateUserInBackground(final AuthenticationDetails authenticationDetails, final AuthenticationHandler callback) {
        if (callback == null) {
            throw new InvalidParameterException("callback is null");
        }
        this.userId = authenticationDetails.getUserId();
        try {
            this.secretHash = CognitoSecretHash.getSecretHash(this.userId, this.clientId, this.clientSecret);
        }
        catch (Exception exception) {
            callback.onFailure(exception);
        }
        final CognitoUser cognitoUser = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    AuthenticateResult authenticateResult = CognitoUser.this.authenticate(authenticationDetails);
                    if (authenticateResult.getCodeDeliveryDetails() == null) {
                        final CognitoUserSession session = CognitoUser.this.cipSession;
                        returnCallback = new Runnable(){

                            @Override
                            public void run() {
                                callback.onSuccess(session);
                            }
                        };
                    } else {
                        final MultiFactorAuthenticationContinuation multiFactorAuthenticationContinuation = new MultiFactorAuthenticationContinuation(cognitoUser, authenticateResult.getAuthState(), new CognitoUserCodeDeliveryDetails(authenticateResult.getCodeDeliveryDetails()), true, callback);
                        returnCallback = new Runnable(){

                            @Override
                            public void run() {
                                callback.getMFACode(multiFactorAuthenticationContinuation);
                            }
                        };
                    }
                }
                catch (AmazonServiceException e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure((Exception)e);
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure((Exception)new AmazonServiceException("Error", e));
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void authenticateUser(AuthenticationDetails authenticationDetails, AuthenticationHandler callback) {
        if (this.userId == null) {
            throw new CognitoParameterInvalidException("userId is null");
        }
        this.userId = authenticationDetails.getUserId();
        try {
            this.secretHash = CognitoSecretHash.getSecretHash(this.userId, this.clientId, this.clientSecret);
        }
        catch (Exception exception) {
            callback.onFailure(exception);
        }
        try {
            AuthenticateResult authenticateResult = this.authenticate(authenticationDetails);
            if (authenticateResult.getCodeDeliveryDetails() == null) {
                callback.onSuccess(this.cipSession);
            } else {
                MultiFactorAuthenticationContinuation multiFactorAuthenticationContinuation = new MultiFactorAuthenticationContinuation(this, authenticateResult.getAuthState(), new CognitoUserCodeDeliveryDetails(authenticateResult.getCodeDeliveryDetails()), false, callback);
                callback.getMFACode(multiFactorAuthenticationContinuation);
            }
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private AuthenticateResult authenticate(AuthenticationDetails authenticationDetails) {
        if (authenticationDetails == null) {
            throw new CognitoParameterInvalidException("AuthenticationDetails is null");
        }
        this.userId = authenticationDetails.getUserId();
        AuthenticateResult authResult = this.authenticateInternal(authenticationDetails);
        if (authResult.getCodeDeliveryDetails() == null) {
            this.cipSession = this.getCognitoUserSession(authResult.getAuthenticationResult());
            this.cacheTokens(this.cipSession);
        }
        return authResult;
    }

    public void sendMFACodeInBackground(final String mfaCode, final String authState, final CognitoUserCodeDeliveryDetails codeDeliveryDetails, final AuthenticationHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser cognitoUser = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    cognitoUser.sendMFACodeInternal(mfaCode, authState);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(cognitoUser.getCachedSession());
                        }
                    };
                }
                catch (CodeMismatchException e) {
                    final MultiFactorAuthenticationContinuation multiFactorAuthenticationContinuation = new MultiFactorAuthenticationContinuation(cognitoUser, authState, codeDeliveryDetails, true, callback);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.getMFACode(multiFactorAuthenticationContinuation);
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void sendMFACode(String mfaCode, String authState, CognitoUserCodeDeliveryDetails codeDeliveryDetails, AuthenticationHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            this.sendMFACodeInternal(mfaCode, authState);
            callback.onSuccess(this.getCachedSession());
        }
        catch (CodeMismatchException e) {
            MultiFactorAuthenticationContinuation multiFactorAuthenticationContinuation = new MultiFactorAuthenticationContinuation(this, authState, codeDeliveryDetails, false, callback);
            callback.getMFACode(multiFactorAuthenticationContinuation);
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private void sendMFACodeInternal(String mfaCode, String authState) {
        if (mfaCode == null) {
            throw new CognitoParameterInvalidException("MFA code is null");
        }
        EnhanceAuthRequest enhancedAuthRequest = new EnhanceAuthRequest();
        enhancedAuthRequest.setUsername(this.usernameInternal);
        enhancedAuthRequest.setClientId(this.clientId);
        enhancedAuthRequest.setSecretHash(this.secretHash);
        enhancedAuthRequest.setCode(mfaCode);
        enhancedAuthRequest.setAuthState(authState);
        EnhanceAuthResult enhancedAuthResult = this.cognitoIdentityProviderClient.enhanceAuth(enhancedAuthRequest);
        this.cipSession = this.getCognitoUserSession(enhancedAuthResult.getAuthenticationResult());
        this.cacheTokens(this.cipSession);
    }

    public void changePasswordInBackground(final String oldUserPassword, final String newUserPassword, final GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser user = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUserSession session = user.getCachedSession();
                    CognitoUser.this.changePasswordInternal(oldUserPassword, newUserPassword, session);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void changePassword(String oldUserPassword, String newUserPassword, GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            this.changePasswordInternal(oldUserPassword, newUserPassword, this.getCachedSession());
            callback.onSuccess();
        }
        catch (AmazonServiceException e) {
            callback.onFailure((Exception)((Object)e));
        }
    }

    private void changePasswordInternal(String oldUserPassword, String newUserPassword, CognitoUserSession session) {
        if (session == null || !session.isValid()) {
            throw new CognitoNotAuthorizedException("user is not authenticated");
        }
        ChangePasswordRequest changePasswordRequest = new ChangePasswordRequest();
        changePasswordRequest.setPreviousPassword(oldUserPassword);
        changePasswordRequest.setProposedPassword(newUserPassword);
        changePasswordRequest.setAccessToken(session.getAccessToken().getJWTToken());
        this.cognitoIdentityProviderClient.changePassword(changePasswordRequest);
    }

    public void getDetailsInBackground(final GetDetailsHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser user = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUserSession session = user.getCachedSession();
                    final CognitoUserDetails userDetails = CognitoUser.this.getUserDetailsInternal(session);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(userDetails);
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void getDetails(GetDetailsHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            CognitoUserDetails userDetails = this.getUserDetailsInternal(this.getCachedSession());
            callback.onSuccess(userDetails);
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private CognitoUserDetails getUserDetailsInternal(CognitoUserSession session) {
        if (session != null && session.isValid()) {
            GetUserRequest getUserRequest = new GetUserRequest();
            getUserRequest.setAccessToken(session.getAccessToken().getJWTToken());
            GetUserResult userResult = this.cognitoIdentityProviderClient.getUser(getUserRequest);
            return new CognitoUserDetails(new CognitoUserAttributes(userResult.getUserAttributes()), new CognitoUserSettings(userResult.getMFAOptions()));
        }
        throw new CognitoNotAuthorizedException("user is not authenticated");
    }

    public void getAttributeVerificationCodeInBackground(final String attributeName, final VerificationHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser user = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUserSession session = user.getCachedSession();
                    final GetUserAttributeVerificationCodeResult getUserAttributeVerificationCodeResult = CognitoUser.this.getAttributeVerificationCodeInternal(attributeName, session);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(new CognitoUserCodeDeliveryDetails(getUserAttributeVerificationCodeResult.getCodeDeliveryDetails()));
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void getAttributeVerificationCode(String attributeName, VerificationHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            GetUserAttributeVerificationCodeResult getUserAttributeVerificationCodeResult = this.getAttributeVerificationCodeInternal(attributeName, this.getCachedSession());
            callback.onSuccess(new CognitoUserCodeDeliveryDetails(getUserAttributeVerificationCodeResult.getCodeDeliveryDetails()));
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private GetUserAttributeVerificationCodeResult getAttributeVerificationCodeInternal(String attributeName, CognitoUserSession session) {
        if (session != null && session.isValid()) {
            GetUserAttributeVerificationCodeRequest getUserAttributeVerificationCodeRequest = new GetUserAttributeVerificationCodeRequest();
            getUserAttributeVerificationCodeRequest.setAccessToken(session.getAccessToken().getJWTToken());
            getUserAttributeVerificationCodeRequest.setAttributeName(attributeName);
            return this.cognitoIdentityProviderClient.getUserAttributeVerificationCode(getUserAttributeVerificationCodeRequest);
        }
        throw new CognitoNotAuthorizedException("user is not authenticated");
    }

    public void verifyAttributeInBackground(final String attributeName, final String verificationCode, final GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser user = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUserSession session = user.getCachedSession();
                    CognitoUser.this.verifyAttributeInternal(attributeName, verificationCode, session);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void verifyAttribute(String attributeName, String verificationCode, GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            VerifyUserAttributeResult verifyUserAttributeResult = this.verifyAttributeInternal(attributeName, verificationCode, this.getCachedSession());
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private VerifyUserAttributeResult verifyAttributeInternal(String attributeName, String verificationCode, CognitoUserSession session) {
        if (session != null && session.isValid()) {
            VerifyUserAttributeRequest verifyUserAttributeRequest = new VerifyUserAttributeRequest();
            verifyUserAttributeRequest.setAttributeName(attributeName);
            verifyUserAttributeRequest.setAccessToken(session.getAccessToken().getJWTToken());
            verifyUserAttributeRequest.setCode(verificationCode);
            return this.cognitoIdentityProviderClient.verifyUserAttribute(verifyUserAttributeRequest);
        }
        throw new CognitoNotAuthorizedException("user is not authenticated");
    }

    public void updateAttributesInBackground(final CognitoUserAttributes attributes, final UpdateAttributesHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser user = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUserSession session = user.getCachedSession();
                    final UpdateUserAttributesResult updateUserAttributesResult = CognitoUser.this.updateAttributesInternal(attributes, session);
                    final ArrayList attributesVerificationList = new ArrayList();
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            for (CodeDeliveryDetailsType details : updateUserAttributesResult.getCodeDeliveryDetailsList()) {
                                attributesVerificationList.add(new CognitoUserCodeDeliveryDetails(details));
                            }
                            callback.onSuccess(attributesVerificationList);
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void updateAttributes(CognitoUserAttributes attributes, UpdateAttributesHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            CognitoUserSession session = this.getCachedSession();
            UpdateUserAttributesResult updateUserAttributesResult = this.updateAttributesInternal(attributes, session);
            ArrayList<CognitoUserCodeDeliveryDetails> attributesVerificationList = new ArrayList<CognitoUserCodeDeliveryDetails>();
            for (CodeDeliveryDetailsType details : updateUserAttributesResult.getCodeDeliveryDetailsList()) {
                attributesVerificationList.add(new CognitoUserCodeDeliveryDetails(details));
            }
            callback.onSuccess(attributesVerificationList);
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private UpdateUserAttributesResult updateAttributesInternal(CognitoUserAttributes attributes, CognitoUserSession session) {
        if (session != null && session.isValid()) {
            UpdateUserAttributesRequest updateUserAttributesRequest = new UpdateUserAttributesRequest();
            updateUserAttributesRequest.setAccessToken(session.getAccessToken().getJWTToken());
            updateUserAttributesRequest.setUserAttributes(attributes.getAttributesList());
            return this.cognitoIdentityProviderClient.updateUserAttributes(updateUserAttributesRequest);
        }
        throw new CognitoNotAuthorizedException("user is not authenticated");
    }

    public void deleteAttributesInBackground(final List<String> attributeNamesToDelete, final GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser user = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUserSession session = user.getCachedSession();
                    CognitoUser.this.deleteAttributesInternal(attributeNamesToDelete, session);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void deleteAttributes(List<String> attributeNamesToDelete, GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            this.deleteAttributesInternal(attributeNamesToDelete, this.getCachedSession());
            callback.onSuccess();
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private void deleteAttributesInternal(List<String> attributeNamesToDelete, CognitoUserSession session) {
        if (session == null) {
            throw new CognitoNotAuthorizedException("user is not authenticated");
        }
        if (!session.isValid()) {
            throw new CognitoNotAuthorizedException("user is not authenticated");
        }
        if (attributeNamesToDelete == null) {
            return;
        }
        if (attributeNamesToDelete.size() < 1) {
            return;
        }
        DeleteUserAttributesRequest deleteUserAttributesRequest = new DeleteUserAttributesRequest();
        deleteUserAttributesRequest.setAccessToken(session.getAccessToken().getJWTToken());
        deleteUserAttributesRequest.setUserAttributeNames(attributeNamesToDelete);
        this.cognitoIdentityProviderClient.deleteUserAttributes(deleteUserAttributesRequest);
    }

    public void signOut() {
        this.cipSession = null;
        this.clearCachedTokens();
    }

    public void deleteUserInBackground(final GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser user = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUserSession session = user.getCachedSession();
                    CognitoUser.this.deleteUserInternal(session);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void deleteUser(GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            this.deleteUserInternal(this.getCachedSession());
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private void deleteUserInternal(CognitoUserSession session) {
        if (session == null) {
            throw new CognitoNotAuthorizedException("user is not authenticated");
        }
        if (!session.isValid()) {
            throw new CognitoNotAuthorizedException("user is not authenticated");
        }
        DeleteUserRequest deleteUserRequest = new DeleteUserRequest();
        deleteUserRequest.setAccessToken(session.getAccessToken().getJWTToken());
        this.cognitoIdentityProviderClient.deleteUser(deleteUserRequest);
    }

    public void setUserSettingsInBackground(final CognitoUserSettings cognitoUserSettings, final GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUserSession session = this.getCachedSession();
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUser.this.setUserSettingsInternal(cognitoUserSettings, session);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void setUserSettings(CognitoUserSettings cognitoUserSettings, GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            this.setUserSettingsInternal(cognitoUserSettings, this.getCachedSession());
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private void setUserSettingsInternal(CognitoUserSettings cognitoUserSettings, CognitoUserSession session) {
        if (session != null && session.isValid()) {
            if (cognitoUserSettings == null) {
                throw new CognitoParameterInvalidException("user attributes is null");
            }
        } else {
            throw new CognitoNotAuthorizedException("user is not authenticated");
        }
        SetUserSettingsRequest setUserSettingsRequest = new SetUserSettingsRequest();
        setUserSettingsRequest.setAccessToken(session.getAccessToken().getJWTToken());
        setUserSettingsRequest.setMFAOptions(cognitoUserSettings.getSettingsList());
        SetUserSettingsResult setUserSettingsResult = this.cognitoIdentityProviderClient.setUserSettings(setUserSettingsRequest);
    }

    private void clearCachedTokens() {
        try {
            SharedPreferences csiCachedTokens = this.context.getSharedPreferences("CognitoIdentityProviderCache", 0);
            csiCachedTokens.edit().clear().apply();
        }
        catch (Exception e) {
            Log.e((String)"CognitoUser", (String)"Error while deleting from SharedPreferences");
        }
    }

    private CognitoUserSession readCachedTokens() {
        CognitoUserSession userSession = new CognitoUserSession(null, null, null);
        try {
            SharedPreferences csiCachedTokens = this.context.getSharedPreferences("CognitoIdentityProviderCache", 0);
            String csiIdTokenKey = "CognitoIdentityProvider." + this.clientId + "." + this.userId + ".idToken";
            String csiAccessTokenKey = "CognitoIdentityProvider." + this.clientId + "." + this.userId + ".accessToken";
            String csiRefreshTokenKey = "CognitoIdentityProvider." + this.clientId + "." + this.userId + ".refreshToken";
            if (csiCachedTokens.contains(csiIdTokenKey)) {
                CognitoIdToken csiCachedIdToken = new CognitoIdToken(csiCachedTokens.getString(csiIdTokenKey, null));
                CognitoAccessToken csiCachedAccessToken = new CognitoAccessToken(csiCachedTokens.getString(csiAccessTokenKey, null));
                CognitoRefreshToken csiCachedRefreshToken = new CognitoRefreshToken(csiCachedTokens.getString(csiRefreshTokenKey, null));
                userSession = new CognitoUserSession(csiCachedIdToken, csiCachedAccessToken, csiCachedRefreshToken);
            }
        }
        catch (Exception e) {
            Log.e((String)"CognitoUser", (String)"Error while reading SharedPreferences");
        }
        return userSession;
    }

    private void cacheTokens(CognitoUserSession session) {
        try {
            SharedPreferences csiCachedTokens = this.context.getSharedPreferences("CognitoIdentityProviderCache", 0);
            String csiUserPoolId = this.pool.getUserPoolId();
            String csiIdTokenKey = "CognitoIdentityProvider." + this.clientId + "." + this.userId + ".idToken";
            String csiAccessTokenKey = "CognitoIdentityProvider." + this.clientId + "." + this.userId + ".accessToken";
            String csiRefreshTokenKey = "CognitoIdentityProvider." + this.clientId + "." + this.userId + ".refreshToken";
            String csiLastUserKey = "CognitoIdentityProvider." + this.clientId + ".LastAuthUser";
            SharedPreferences.Editor cacheEdit = csiCachedTokens.edit();
            cacheEdit.putString(csiIdTokenKey, session.getIdToken().getJWTToken());
            cacheEdit.putString(csiAccessTokenKey, session.getAccessToken().getJWTToken());
            cacheEdit.putString(csiRefreshTokenKey, session.getRefreshToken().getToken());
            cacheEdit.putString(csiLastUserKey, this.userId).apply();
        }
        catch (Exception e) {
            Log.e((String)"CognitoUser", (String)"Error while writing to SharedPreferences.");
        }
    }

    private AuthenticateResult authenticateInternal(AuthenticationDetails authenticationDetails) {
        AuthenticationHelper authenticationHelper = new AuthenticationHelper(this.pool.getUserPoolId());
        GetAuthenticationDetailsResult authParameters = this.preAuthProcess(authenticationHelper, authenticationDetails);
        this.usernameInternal = authParameters.getUsername();
        this.secretHash = CognitoSecretHash.getSecretHash(this.usernameInternal, this.clientId, this.clientSecret);
        return this.authenticateUser(authenticationDetails.getPassword(), authParameters, authenticationHelper);
    }

    private GetAuthenticationDetailsResult preAuthProcess(AuthenticationHelper authenticationHelper, AuthenticationDetails authenticationDetails) {
        GetAuthenticationDetailsRequest getUserAuthDetailsRequest = new GetAuthenticationDetailsRequest();
        getUserAuthDetailsRequest.setClientId(this.clientId);
        getUserAuthDetailsRequest.setSecretHash(this.secretHash);
        getUserAuthDetailsRequest.setUsername(this.userId);
        getUserAuthDetailsRequest.setSrpA(authenticationHelper.getA().toString(16));
        getUserAuthDetailsRequest.setValidationData(authenticationDetails.getValidationData());
        return this.cognitoIdentityProviderClient.getAuthenticationDetails(getUserAuthDetailsRequest);
    }

    private AuthenticateResult authenticateUser(String password, GetAuthenticationDetailsResult authDetails, AuthenticationHelper authenticationHelper) {
        byte[] hmac;
        BigInteger B = new BigInteger(authDetails.getSrpB(), 16);
        if (B.mod(AuthenticationHelper.N).equals(BigInteger.ZERO)) {
            throw new CognitoInternalErrorException("B cannot be zero");
        }
        BigInteger salt = new BigInteger(authDetails.getSalt(), 16);
        byte[] key = authenticationHelper.getPasswordAuthenticationKey(this.usernameInternal, password, B, salt);
        Date timestamp = new Date();
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec keySpec = new SecretKeySpec(key, "HmacSHA256");
            mac.init(keySpec);
            mac.update(this.pool.getUserPoolId().split("_", 2)[1].getBytes(StringUtils.UTF8));
            mac.update(this.usernameInternal.getBytes(StringUtils.UTF8));
            mac.update(authDetails.getSecretBlock().array());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy", Locale.US);
            simpleDateFormat.setTimeZone(new SimpleTimeZone(2, "UTC"));
            String dateString = simpleDateFormat.format(timestamp);
            byte[] dateBytes = dateString.getBytes(StringUtils.UTF8);
            hmac = mac.doFinal(dateBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CognitoInternalErrorException("Exception in authentication", e);
        }
        catch (InvalidKeyException e) {
            throw new CognitoInternalErrorException("Exception in authentication", e);
        }
        PasswordClaimType passwordClaim = new PasswordClaimType();
        passwordClaim.setSecretBlock(authDetails.getSecretBlock());
        passwordClaim.setSignature(ByteBuffer.wrap(hmac));
        AuthenticateRequest authUserRequest = new AuthenticateRequest();
        authUserRequest.setClientId(this.clientId);
        authUserRequest.setSecretHash(this.secretHash);
        authUserRequest.setUsername(authDetails.getUsername());
        authUserRequest.setPasswordClaim(passwordClaim);
        authUserRequest.setTimestamp(timestamp);
        return this.cognitoIdentityProviderClient.authenticate(authUserRequest);
    }

    private CognitoUserSession getCognitoUserSession(AuthenticationResultType authResult) {
        return this.getCognitoUserSession(authResult, null);
    }

    private CognitoUserSession getCognitoUserSession(AuthenticationResultType authResult, CognitoRefreshToken refreshTokenOverride) {
        CognitoRefreshToken refreshToken;
        String idtoken = authResult.getIdToken();
        CognitoIdToken idToken = new CognitoIdToken(idtoken);
        String acctoken = authResult.getAccessToken();
        CognitoAccessToken accessToken = new CognitoAccessToken(acctoken);
        if (refreshTokenOverride != null) {
            refreshToken = refreshTokenOverride;
        } else {
            String reftoken = authResult.getRefreshToken();
            refreshToken = new CognitoRefreshToken(reftoken);
        }
        return new CognitoUserSession(idToken, accessToken, refreshToken);
    }

    private CognitoUserSession refreshSessionInternal(CognitoRefreshToken refreshToken) {
        if (refreshToken != null) {
            RefreshTokensRequest refreshTokensRequest = new RefreshTokensRequest();
            refreshTokensRequest.setClientId(this.clientId);
            refreshTokensRequest.setClientSecret(this.clientSecret);
            refreshTokensRequest.setRefreshToken(refreshToken.getToken());
            RefreshTokensResult refreshTokensResult = this.cognitoIdentityProviderClient.refreshTokens(refreshTokensRequest);
            AuthenticationResultType authenticationResult = refreshTokensResult.getAuthenticationResult();
            if (authenticationResult != null) {
                throw new CognitoNotAuthorizedException("user is not authenticated");
            }
            return this.getCognitoUserSession(authenticationResult, refreshToken);
        }
        throw new CognitoNotAuthorizedException("user is not authenticated");
    }

    private static class AuthenticationHelper {
        private BigInteger a;
        private BigInteger A;
        private String poolName;
        private static final String HEX_N = "FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64ECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7ABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6BF12FFA06D98A0864D87602733EC86A64521F2B18177B200CBBE117577A615D6C770988C0BAD946E208E24FA074E5AB3143DB5BFCE0FD108E4B82D120A93AD2CAFFFFFFFFFFFFFFFF";
        private static final BigInteger N = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64ECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7ABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6BF12FFA06D98A0864D87602733EC86A64521F2B18177B200CBBE117577A615D6C770988C0BAD946E208E24FA074E5AB3143DB5BFCE0FD108E4B82D120A93AD2CAFFFFFFFFFFFFFFFF", 16);
        private static final BigInteger g = BigInteger.valueOf(2L);
        private static final BigInteger k;
        private static final int EPHEMERAL_KEY_LENGTH = 1024;
        private static final int DERIVED_KEY_SIZE = 16;
        private static final String DERIVED_KEY_INFO = "Caldera Derived Key";
        private static final ThreadLocal<MessageDigest> THREAD_MESSAGE_DIGEST;
        private static final SecureRandom SECURE_RANDOM;

        public AuthenticationHelper(String userPoolName) {
            do {
                this.a = new BigInteger(1024, SECURE_RANDOM).mod(N);
                this.A = g.modPow(this.a, N);
            } while (this.A.mod(N).equals(BigInteger.ZERO));
            this.poolName = userPoolName.split("_", 2)[1];
        }

        public BigInteger geta() {
            return this.a;
        }

        public BigInteger getA() {
            return this.A;
        }

        public byte[] getPasswordAuthenticationKey(String userId, String userPassword, BigInteger B, BigInteger salt) {
            MessageDigest messageDigest = THREAD_MESSAGE_DIGEST.get();
            messageDigest.reset();
            messageDigest.update(this.A.toByteArray());
            BigInteger u = new BigInteger(1, messageDigest.digest(B.toByteArray()));
            if (u.equals(BigInteger.ZERO)) {
                throw new CognitoInternalErrorException("Hash of A and B cannot be zero");
            }
            messageDigest.reset();
            messageDigest.update(this.poolName.getBytes(StringUtils.UTF8));
            messageDigest.update(userId.getBytes(StringUtils.UTF8));
            messageDigest.update(":".getBytes(StringUtils.UTF8));
            byte[] userIdHash = messageDigest.digest(userPassword.getBytes(StringUtils.UTF8));
            messageDigest.reset();
            messageDigest.update(salt.toByteArray());
            BigInteger x = new BigInteger(1, messageDigest.digest(userIdHash));
            BigInteger S = B.subtract(k.multiply(g.modPow(x, N))).modPow(this.a.add(u.multiply(x)), N).mod(N);
            Hkdf hkdf = null;
            try {
                hkdf = Hkdf.getInstance("HmacSHA256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new CognitoInternalErrorException(e.getMessage(), e);
            }
            hkdf.init(S.toByteArray(), u.toByteArray());
            byte[] key = hkdf.deriveKey(DERIVED_KEY_INFO, 16);
            return key;
        }

        static {
            THREAD_MESSAGE_DIGEST = new ThreadLocal<MessageDigest>(){

                @Override
                protected MessageDigest initialValue() {
                    try {
                        return MessageDigest.getInstance("SHA-256");
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new CognitoInternalErrorException("Exception in authentication", e);
                    }
                }
            };
            try {
                SECURE_RANDOM = SecureRandom.getInstance("SHA1PRNG");
                MessageDigest messageDigest = THREAD_MESSAGE_DIGEST.get();
                messageDigest.reset();
                messageDigest.update(N.toByteArray());
                byte[] digest = messageDigest.digest(g.toByteArray());
                k = new BigInteger(1, digest);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CognitoInternalErrorException(e.getMessage(), e);
            }
        }
    }
}

