/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider.util;

import android.util.Base64;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.exceptions.CognitoParameterInvalidException;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

public class CognitoJWTParser {
    private static final int HEADER = 0;
    private static final int PAYLOAD = 1;
    private static final int SIGNATURE = 2;
    private static final int JWT_PARTS = 3;

    public static JSONObject getHeader(String jwt) {
        try {
            CognitoJWTParser.validateJWT(jwt);
            byte[] sectionDecoded = Base64.decode((String)jwt.split("\\.")[0], (int)8);
            String jwtSection = new String(sectionDecoded, "UTF-8");
            return new JSONObject(jwtSection);
        }
        catch (UnsupportedEncodingException e) {
            throw new CognitoParameterInvalidException(e.getMessage());
        }
        catch (JSONException e) {
            throw new CognitoParameterInvalidException(e.getMessage());
        }
        catch (Exception e) {
            throw new CognitoParameterInvalidException("error in parsing JSON");
        }
    }

    public static JSONObject getPayload(String jwt) {
        try {
            CognitoJWTParser.validateJWT(jwt);
            String payload = jwt.split("\\.")[1];
            byte[] sectionDecoded = Base64.decode((String)payload, (int)8);
            String jwtSection = new String(sectionDecoded, "UTF-8");
            return new JSONObject(jwtSection);
        }
        catch (UnsupportedEncodingException e) {
            throw new CognitoParameterInvalidException(e.getMessage());
        }
        catch (JSONException e) {
            throw new CognitoParameterInvalidException(e.getMessage());
        }
        catch (Exception e) {
            throw new CognitoParameterInvalidException("error in parsing JSON");
        }
    }

    public static String getSignature(String jwt) {
        try {
            CognitoJWTParser.validateJWT(jwt);
            byte[] sectionDecoded = Base64.decode((String)jwt.split("\\.")[2], (int)8);
            return new String(sectionDecoded, "UTF-8");
        }
        catch (Exception e) {
            throw new CognitoParameterInvalidException("error in parsing JSON");
        }
    }

    public static String getClaim(String jwt, String claim) {
        try {
            JSONObject payload = CognitoJWTParser.getPayload(jwt);
            Object claimValue = payload.get(claim);
            if (claimValue != null) {
                return claimValue.toString();
            }
        }
        catch (Exception e) {
            throw new CognitoParameterInvalidException("invalid token");
        }
        return null;
    }

    public static void validateJWT(String jwt) {
        String[] jwtParts = jwt.split("\\.");
        if (jwtParts.length != 3) {
            throw new CognitoParameterInvalidException("not a JSON Web Token");
        }
    }
}

