/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations;

import android.content.Context;
import android.os.Handler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUser;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.AuthenticationDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.CognitoIdentityProviderContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.AuthenticationHandler;
import java.util.Collections;
import java.util.Map;

public class AuthenticationContinuation
implements CognitoIdentityProviderContinuation<String> {
    public static final boolean RUN_IN_BACKGROUND = true;
    public static final boolean RUN_IN_CURRENT = false;
    private final CognitoUser user;
    private final Context context;
    private final AuthenticationHandler callback;
    private final boolean runInBackground;
    private AuthenticationDetails authenticationDetails = null;
    private Map<String, String> clientMetadata;

    public AuthenticationContinuation(CognitoUser user, Context context, boolean runInBackground, AuthenticationHandler callback) {
        this.user = user;
        this.context = context;
        this.runInBackground = runInBackground;
        this.callback = callback;
        this.clientMetadata = Collections.emptyMap();
    }

    public Map<String, String> getClientMetaData() {
        return this.clientMetadata;
    }

    public void setClientMetaData(Map<String, String> clientMetadata) {
        this.clientMetadata.clear();
        this.clientMetadata.putAll(clientMetadata);
    }

    @Override
    public String getParameters() {
        return "AuthenticationDetails";
    }

    @Override
    public void continueTask() {
        if (this.runInBackground) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Runnable nextStep;
                    Handler handler = new Handler(AuthenticationContinuation.this.context.getMainLooper());
                    try {
                        nextStep = AuthenticationContinuation.this.user.initiateUserAuthentication(AuthenticationContinuation.this.clientMetadata, AuthenticationContinuation.this.authenticationDetails, AuthenticationContinuation.this.callback, true);
                    }
                    catch (Exception e) {
                        nextStep = new Runnable(){

                            @Override
                            public void run() {
                                AuthenticationContinuation.this.callback.onFailure(e);
                            }
                        };
                    }
                    handler.post(nextStep);
                }
            }).start();
        } else {
            Runnable nextStep;
            try {
                nextStep = this.user.initiateUserAuthentication(this.clientMetadata, this.authenticationDetails, this.callback, false);
            }
            catch (Exception e) {
                nextStep = new Runnable(){

                    @Override
                    public void run() {
                        AuthenticationContinuation.this.callback.onFailure(e);
                    }
                };
            }
            nextStep.run();
        }
    }

    public void setAuthenticationDetails(AuthenticationDetails authenticationDetails) {
        this.authenticationDetails = authenticationDetails;
    }
}

