/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.StartUserImportJobRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class StartUserImportJobRequestMarshaller
implements Marshaller<Request<StartUserImportJobRequest>, StartUserImportJobRequest> {
    public Request<StartUserImportJobRequest> marshall(StartUserImportJobRequest startUserImportJobRequest) {
        if (startUserImportJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(StartUserImportJobRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)startUserImportJobRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.StartUserImportJob";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (startUserImportJobRequest.getUserPoolId() != null) {
                String userPoolId = startUserImportJobRequest.getUserPoolId();
                jsonWriter.name("UserPoolId");
                jsonWriter.value(userPoolId);
            }
            if (startUserImportJobRequest.getJobId() != null) {
                String jobId = startUserImportJobRequest.getJobId();
                jsonWriter.name("JobId");
                jsonWriter.value(jobId);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

