/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognito;

import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.mobileconnectors.cognito.Dataset;
import com.amazonaws.mobileconnectors.cognito.Record;
import com.amazonaws.mobileconnectors.cognito.SyncConflict;
import com.amazonaws.mobileconnectors.cognito.exceptions.DataStorageException;
import java.util.ArrayList;
import java.util.List;

public class DefaultSyncCallback
implements Dataset.SyncCallback {
    private static final Log LOGGER = LogFactory.getLog(DefaultSyncCallback.class);

    @Override
    public void onSuccess(Dataset dataset, List<Record> updatedRecords) {
        LOGGER.info((Object)String.format("%d records synced successfully.", updatedRecords.size()));
    }

    @Override
    public boolean onConflict(Dataset dataset, List<SyncConflict> conflicts) {
        LOGGER.info((Object)"onConflict resolved with DefaultSyncCallback's default implementation (last writer wins).");
        ArrayList<Record> resolvedConflicts = new ArrayList<Record>(conflicts.size());
        for (SyncConflict conflict : conflicts) {
            resolvedConflicts.add(conflict.resolveWithLastWriterWins());
        }
        dataset.resolve(resolvedConflicts);
        return true;
    }

    @Override
    public boolean onDatasetDeleted(Dataset dataset, String datasetName) {
        LOGGER.warn((Object)"onDatasetDeleted was called and DefaultSyncCallback doesn't provide an implementation for it");
        return false;
    }

    @Override
    public boolean onDatasetsMerged(Dataset dataset, List<String> datasetNames) {
        LOGGER.warn((Object)"onDatasetsMerged was called and DefaultSyncCallback doesn't provide an implementation for it");
        return false;
    }

    @Override
    public void onFailure(DataStorageException dse) {
        LOGGER.error((Object)"Failure occurred during sync", (Throwable)((Object)dse));
    }
}

