/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitosync.model.RecordPatch;
import com.amazonaws.services.cognitosync.model.UpdateRecordsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateRecordsRequestMarshaller
implements Marshaller<Request<UpdateRecordsRequest>, UpdateRecordsRequest> {
    public Request<UpdateRecordsRequest> marshall(UpdateRecordsRequest updateRecordsRequest) {
        if (updateRecordsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateRecordsRequest, "AmazonCognitoSync");
        String target = "AWSCognitoSyncService.UpdateRecords";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        if (updateRecordsRequest.getClientContext() != null) {
            request.addHeader("x-amz-Client-Context", StringUtils.fromString((String)updateRecordsRequest.getClientContext()));
        }
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", updateRecordsRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString((String)updateRecordsRequest.getIdentityPoolId()));
        uriResourcePath = uriResourcePath.replace("{IdentityId}", updateRecordsRequest.getIdentityId() == null ? "" : StringUtils.fromString((String)updateRecordsRequest.getIdentityId()));
        uriResourcePath = uriResourcePath.replace("{DatasetName}", updateRecordsRequest.getDatasetName() == null ? "" : StringUtils.fromString((String)updateRecordsRequest.getDatasetName()));
        if ((uriResourcePath = uriResourcePath.replaceAll("//", "/")).contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            ListWithAutoConstructFlag recordPatchesList;
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (updateRecordsRequest.getDeviceId() != null) {
                jsonWriter.name("DeviceId").value(updateRecordsRequest.getDeviceId());
            }
            if (!((recordPatchesList = (ListWithAutoConstructFlag)updateRecordsRequest.getRecordPatches()) == null || recordPatchesList.isAutoConstruct() && recordPatchesList.isEmpty())) {
                jsonWriter.name("RecordPatches");
                jsonWriter.beginArray();
                for (RecordPatch recordPatchesListValue : recordPatchesList) {
                    if (recordPatchesListValue == null) continue;
                    jsonWriter.beginObject();
                    if (recordPatchesListValue.getOp() != null) {
                        jsonWriter.name("Op").value(recordPatchesListValue.getOp());
                    }
                    if (recordPatchesListValue.getKey() != null) {
                        jsonWriter.name("Key").value(recordPatchesListValue.getKey());
                    }
                    if (recordPatchesListValue.getValue() != null) {
                        jsonWriter.name("Value").value(recordPatchesListValue.getValue());
                    }
                    if (recordPatchesListValue.getSyncCount() != null) {
                        jsonWriter.name("SyncCount").value((Number)recordPatchesListValue.getSyncCount());
                    }
                    if (recordPatchesListValue.getDeviceLastModifiedDate() != null) {
                        jsonWriter.name("DeviceLastModifiedDate").value(recordPatchesListValue.getDeviceLastModifiedDate());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (updateRecordsRequest.getSyncSessionToken() != null) {
                jsonWriter.name("SyncSessionToken").value(updateRecordsRequest.getSyncSessionToken());
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

