/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognito;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.util.Log;
import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.CognitoCachingCredentialsProvider;
import com.amazonaws.auth.IdentityChangedListener;
import com.amazonaws.mobileconnectors.cognito.Dataset;
import com.amazonaws.mobileconnectors.cognito.DatasetMetadata;
import com.amazonaws.mobileconnectors.cognito.DefaultDataset;
import com.amazonaws.mobileconnectors.cognito.PushSyncUpdate;
import com.amazonaws.mobileconnectors.cognito.exceptions.DataStorageException;
import com.amazonaws.mobileconnectors.cognito.exceptions.RegistrationFailedException;
import com.amazonaws.mobileconnectors.cognito.exceptions.UnsubscribeFailedException;
import com.amazonaws.mobileconnectors.cognito.internal.storage.CognitoSyncStorage;
import com.amazonaws.mobileconnectors.cognito.internal.storage.SQLiteLocalStorage;
import com.amazonaws.mobileconnectors.cognito.internal.util.DatasetUtils;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cognitosync.AmazonCognitoSyncClient;
import com.amazonaws.services.cognitosync.model.RegisterDeviceRequest;
import com.amazonaws.services.cognitosync.model.RegisterDeviceResult;
import com.amazonaws.services.cognitosync.model.ResourceNotFoundException;
import com.amazonaws.util.VersionInfoUtils;
import java.util.ArrayList;
import java.util.List;

public class CognitoSyncManager {
    private static final String TAG = "CognitoSyncManager";
    private static final String USER_AGENT = CognitoSyncManager.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static final String DATABASE_NAME = "cognito_dataset_cache.db";
    private static SQLiteLocalStorage local;
    private final Context context;
    private final CognitoSyncStorage remote;
    private final CognitoCachingCredentialsProvider provider;
    private final AmazonCognitoSyncClient syncClient;
    private final String identityPoolId;

    @Deprecated
    public CognitoSyncManager(Context context, String identityPoolId, Regions region, CognitoCachingCredentialsProvider provider) {
        this(context, region, provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CognitoSyncManager(Context context, Regions region, CognitoCachingCredentialsProvider provider) {
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.context = context;
        this.provider = provider;
        this.identityPoolId = provider.getIdentityPoolId();
        Class<CognitoSyncManager> clazz = CognitoSyncManager.class;
        synchronized (CognitoSyncManager.class) {
            if (local == null) {
                local = new SQLiteLocalStorage(context, DATABASE_NAME);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.syncClient = new AmazonCognitoSyncClient((AWSCredentialsProvider)provider);
            this.syncClient.setRegion(Region.getRegion((Regions)region));
            this.remote = new CognitoSyncStorage(this.identityPoolId, this.syncClient, provider);
            this.remote.setUserAgent(USER_AGENT);
            provider.registerIdentityChangedListener(new IdentityChangedListener(){

                public void identityChanged(String oldIdentityId, String newIdentityId) {
                    if (newIdentityId != null) {
                        Log.i((String)CognitoSyncManager.TAG, (String)"identity change detected");
                        local.changeIdentityId(oldIdentityId == null ? "unknown" : oldIdentityId, newIdentityId);
                    }
                }
            });
            return;
        }
    }

    public Dataset openOrCreateDataset(String datasetName) {
        DatasetUtils.validateDatasetName(datasetName);
        local.createDataset(this.getIdentityId(), datasetName);
        DefaultDataset dataset = new DefaultDataset(this.context, datasetName, this.provider, local, this.remote);
        return dataset;
    }

    public List<DatasetMetadata> listDatasets() {
        return local.getDatasets(this.getIdentityId());
    }

    public void refreshDatasetMetadata() throws DataStorageException {
        List<DatasetMetadata> datasets = this.remote.getDatasets();
        local.updateDatasetMetadata(this.getIdentityId(), datasets);
    }

    public void wipeData() {
        this.provider.clear();
        local.wipeData();
        Log.i((String)TAG, (String)"All data has been wiped");
    }

    String getIdentityId() {
        return DatasetUtils.getIdentityId(this.provider);
    }

    public void registerDevice(String platform, String token) {
        SharedPreferences sp = this.getSharedPreferences();
        if (this.isDeviceRegistered()) {
            Log.i((String)TAG, (String)"Device is already registered");
            return;
        }
        String identityId = this.provider.getIdentityId();
        RegisterDeviceRequest request = new RegisterDeviceRequest().withIdentityPoolId(this.provider.getIdentityPoolId()).withIdentityId(identityId).withPlatform(platform).withToken(token);
        try {
            RegisterDeviceResult result = this.syncClient.registerDevice(request);
            String deviceId = result.getDeviceId();
            sp.edit().putString("deviceId", deviceId).putString("platform", platform).putString("token", token).apply();
            Log.i((String)TAG, (String)("Device is registered successfully: " + deviceId));
        }
        catch (AmazonClientException ace) {
            Log.e((String)TAG, (String)"Failed to register device", (Throwable)ace);
            throw new RegistrationFailedException("Failed to register device", ace);
        }
    }

    public boolean isDeviceRegistered() {
        SharedPreferences sp = this.getSharedPreferences();
        return !sp.getString("deviceId", "").isEmpty() && !sp.getString("platform", "").isEmpty() && !sp.getString("token", "").isEmpty();
    }

    public void unregisterDevice() {
        SharedPreferences sp = this.getSharedPreferences();
        sp.edit().remove("deviceId").remove("platform").remove("token").apply();
    }

    public void subscribeAll() {
        ArrayList<String> datasetNames = new ArrayList<String>();
        for (DatasetMetadata dataset : this.listDatasets()) {
            datasetNames.add(dataset.getDatasetName());
        }
        this.subscribe(datasetNames);
    }

    public void subscribe(List<String> datasetNames) {
        for (String datasetName : datasetNames) {
            Dataset dataset = this.openOrCreateDataset(datasetName);
            dataset.subscribe();
        }
    }

    public void unsubscribeAll() {
        ArrayList<String> datasetNames = new ArrayList<String>();
        for (DatasetMetadata dataset : this.listDatasets()) {
            datasetNames.add(dataset.getDatasetName());
        }
        this.unsubscribe(datasetNames);
    }

    public void unsubscribe(List<String> datasetNames) {
        for (String datasetName : datasetNames) {
            Dataset dataset = this.openOrCreateDataset(datasetName);
            try {
                dataset.unsubscribe();
            }
            catch (UnsubscribeFailedException ufe) {
                if (ufe.getCause() instanceof ResourceNotFoundException) {
                    Log.w((String)TAG, (String)("Unable to unsubscribe to dataset " + datasetName + ", dataset not a subscription"));
                    continue;
                }
                throw ufe;
            }
        }
    }

    public PushSyncUpdate getPushSyncUpdate(Intent intent) {
        return new PushSyncUpdate(intent);
    }

    private SharedPreferences getSharedPreferences() {
        return this.context.getSharedPreferences("com.amazonaws.mobileconnectors.cognito", 0);
    }

    void close() {
        local.close();
    }
}

