/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognito;

import android.util.Log;
import com.amazonaws.mobileconnectors.cognito.Dataset;
import com.amazonaws.mobileconnectors.cognito.Record;
import com.amazonaws.mobileconnectors.cognito.SyncConflict;
import com.amazonaws.mobileconnectors.cognito.exceptions.DataStorageException;
import java.util.ArrayList;
import java.util.List;

public class DefaultSyncCallback
implements Dataset.SyncCallback {
    private static final String TAG = "DefaultSyncCallback";

    @Override
    public void onSuccess(Dataset dataset, List<Record> updatedRecords) {
        Log.i((String)TAG, (String)String.format("%d records synced successfully.", updatedRecords.size()));
    }

    @Override
    public boolean onConflict(Dataset dataset, List<SyncConflict> conflicts) {
        Log.i((String)TAG, (String)"onConflict resolved with DefaultSyncCallback's default implementation (last writer wins).");
        ArrayList<Record> resolvedConflicts = new ArrayList<Record>(conflicts.size());
        for (SyncConflict conflict : conflicts) {
            resolvedConflicts.add(conflict.resolveWithLastWriterWins());
        }
        dataset.resolve(resolvedConflicts);
        return true;
    }

    @Override
    public boolean onDatasetDeleted(Dataset dataset, String datasetName) {
        Log.w((String)TAG, (String)"onDatasetDeleted was called and DefaultSyncCallback doesn't provide an implementation for it");
        return false;
    }

    @Override
    public boolean onDatasetsMerged(Dataset dataset, List<String> datasetNames) {
        Log.w((String)TAG, (String)"onDatasetsMerged was called and DefaultSyncCallback doesn't provide an implementation for it");
        return false;
    }

    @Override
    public void onFailure(DataStorageException dse) {
        Log.e((String)TAG, (String)"Failure occurred during sync", (Throwable)((Object)dse));
    }
}

