/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognito.internal.util;

import com.amazonaws.auth.CognitoCachingCredentialsProvider;
import com.amazonaws.mobileconnectors.cognito.Record;
import com.amazonaws.mobileconnectors.cognito.internal.util.StringUtils;
import java.util.regex.Pattern;

public final class DatasetUtils {
    public static final Pattern DATASET_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_.:-]{1,128}$");
    public static final String UNKNOWN_IDENTITY_ID = "unknown";

    public static String validateDatasetName(String datasetName) {
        if (!DATASET_NAME_PATTERN.matcher(datasetName).matches()) {
            throw new IllegalArgumentException("Invalid dataset name");
        }
        return datasetName;
    }

    public static String validateRecordKey(String key) {
        if (StringUtils.isEmpty(key) || StringUtils.utf8ByteLength(key) > 128L) {
            throw new IllegalArgumentException("Invalid record key");
        }
        return key;
    }

    public static long computeRecordSize(Record record) {
        if (record == null) {
            return 0L;
        }
        return StringUtils.utf8ByteLength(record.getKey()) + StringUtils.utf8ByteLength(record.getValue());
    }

    public static String getIdentityId(CognitoCachingCredentialsProvider provider) {
        return provider.getCachedIdentityId() == null ? UNKNOWN_IDENTITY_ID : provider.getCachedIdentityId();
    }
}

