/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitosync.model.ListRecordsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListRecordsRequestMarshaller
implements Marshaller<Request<ListRecordsRequest>, ListRecordsRequest> {
    public Request<ListRecordsRequest> marshall(ListRecordsRequest listRecordsRequest) {
        if (listRecordsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest defaultRequest = new DefaultRequest((AmazonWebServiceRequest)listRecordsRequest, "AmazonCognitoSync");
        String string = "AWSCognitoSyncService.ListRecords";
        defaultRequest.addHeader("X-Amz-Target", string);
        defaultRequest.setHttpMethod(HttpMethodName.GET);
        String string2 = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/records?lastSyncCount={LastSyncCount};maxResults={MaxResults};nextToken={NextToken};syncSessionToken={SyncSessionToken}";
        string2 = string2.replace("{IdentityPoolId}", listRecordsRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getIdentityPoolId()));
        string2 = string2.replace("{IdentityId}", listRecordsRequest.getIdentityId() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getIdentityId()));
        string2 = string2.replace("{DatasetName}", listRecordsRequest.getDatasetName() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getDatasetName()));
        string2 = string2.replace("{LastSyncCount}", listRecordsRequest.getLastSyncCount() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getLastSyncCount()));
        string2 = string2.replace("{NextToken}", listRecordsRequest.getNextToken() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getNextToken()));
        string2 = string2.replace("{MaxResults}", listRecordsRequest.getMaxResults() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getMaxResults()));
        string2 = string2.replace("{SyncSessionToken}", listRecordsRequest.getSyncSessionToken() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getSyncSessionToken()));
        string2 = string2.replaceAll("//", "/");
        if (string2.contains("?")) {
            String string3 = string2.substring(string2.indexOf("?") + 1);
            string2 = string2.substring(0, string2.indexOf("?"));
            for (String string4 : string3.split("[;&]")) {
                String[] stringArray = string4.split("=");
                if (stringArray.length != 2 || stringArray[1].isEmpty()) continue;
                defaultRequest.addParameter(stringArray[0], stringArray[1]);
            }
        }
        defaultRequest.setResourcePath(string2);
        defaultRequest.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        return defaultRequest;
    }
}

