/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitosync.model.ListDatasetsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListDatasetsRequestMarshaller
implements Marshaller<Request<ListDatasetsRequest>, ListDatasetsRequest> {
    public Request<ListDatasetsRequest> marshall(ListDatasetsRequest listDatasetsRequest) {
        if (listDatasetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest defaultRequest = new DefaultRequest((AmazonWebServiceRequest)listDatasetsRequest, "AmazonCognitoSync");
        String string = "AWSCognitoSyncService.ListDatasets";
        defaultRequest.addHeader("X-Amz-Target", string);
        defaultRequest.setHttpMethod(HttpMethodName.GET);
        String string2 = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets?maxResults={MaxResults};nextToken={NextToken}";
        string2 = string2.replace("{IdentityPoolId}", listDatasetsRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString((String)listDatasetsRequest.getIdentityPoolId()));
        string2 = string2.replace("{IdentityId}", listDatasetsRequest.getIdentityId() == null ? "" : StringUtils.fromString((String)listDatasetsRequest.getIdentityId()));
        string2 = string2.replace("{NextToken}", listDatasetsRequest.getNextToken() == null ? "" : StringUtils.fromString((String)listDatasetsRequest.getNextToken()));
        string2 = string2.replace("{MaxResults}", listDatasetsRequest.getMaxResults() == null ? "" : StringUtils.fromString((String)listDatasetsRequest.getMaxResults()));
        string2 = string2.replaceAll("//", "/");
        if (string2.contains("?")) {
            String string3 = string2.substring(string2.indexOf("?") + 1);
            string2 = string2.substring(0, string2.indexOf("?"));
            for (String string4 : string3.split("[;&]")) {
                String[] stringArray = string4.split("=");
                if (stringArray.length != 2 || stringArray[1].isEmpty()) continue;
                defaultRequest.addParameter(stringArray[0], stringArray[1]);
            }
        }
        defaultRequest.setResourcePath(string2);
        defaultRequest.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        return defaultRequest;
    }
}

