/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognito;

import android.content.Context;
import android.util.Log;
import com.amazonaws.auth.CognitoCachingCredentialsProvider;
import com.amazonaws.auth.IdentityChangedListener;
import com.amazonaws.mobileconnectors.cognito.DatasetMetadata;
import com.amazonaws.mobileconnectors.cognito.DefaultDataset;
import com.amazonaws.mobileconnectors.cognito.exceptions.DataStorageException;
import com.amazonaws.mobileconnectors.cognito.internal.storage.CognitoSyncStorage;
import com.amazonaws.mobileconnectors.cognito.internal.storage.SQLiteLocalStorage;
import com.amazonaws.mobileconnectors.cognito.internal.util.DatasetUtils;
import com.amazonaws.mobileconnectors.cognito.internal.util.StringUtils;
import com.amazonaws.regions.Regions;
import com.amazonaws.util.VersionInfoUtils;
import java.util.List;

public class CognitoSyncManager {
    private static final String TAG = "CognitoSyncManager";
    private static final String USER_AGENT = CognitoSyncManager.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static final String DATABASE_NAME = "cognito_dataset_cache.db";
    private final Context context;
    private final SQLiteLocalStorage local;
    private final CognitoSyncStorage remote;
    private final CognitoCachingCredentialsProvider provider;

    public CognitoSyncManager(Context context, String string, Regions regions, CognitoCachingCredentialsProvider cognitoCachingCredentialsProvider) {
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        if (StringUtils.isEmpty(string)) {
            throw new IllegalArgumentException("invalid identity pool id");
        }
        this.context = context;
        this.provider = cognitoCachingCredentialsProvider;
        this.local = new SQLiteLocalStorage(context, DATABASE_NAME);
        this.remote = new CognitoSyncStorage(string, regions, cognitoCachingCredentialsProvider);
        this.remote.setUserAgent(USER_AGENT);
        cognitoCachingCredentialsProvider.registerIdentityChangedListener(new IdentityChangedListener(){

            public void identityChanged(String string, String string2) {
                Log.i((String)CognitoSyncManager.TAG, (String)"identity change detected");
                CognitoSyncManager.this.local.changeIdentityId(string == null ? "unknown" : string, string2);
            }
        });
    }

    public DefaultDataset openOrCreateDataset(String string) {
        DatasetUtils.validateDatasetName(string);
        this.local.createDataset(this.getIdentityId(), string);
        return new DefaultDataset(this.context, string, this.provider, this.local, this.remote);
    }

    public List<DatasetMetadata> listDatasets() {
        return this.local.getDatasets(this.getIdentityId());
    }

    public void refreshDatasetMetadata() throws DataStorageException {
        List<DatasetMetadata> list = this.remote.getDatasets();
        this.local.updateDatasetMetadata(this.getIdentityId(), list);
    }

    public void wipeData() {
        this.provider.clear();
        this.local.wipeData();
        Log.i((String)TAG, (String)"All data has been wiped");
    }

    String getIdentityId() {
        return DatasetUtils.getIdentityId(this.provider);
    }
}

