/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging.acknowledge;

import com.amazon.sqs.javamessaging.AmazonSQSMessagingClientWrapper;
import com.amazon.sqs.javamessaging.SQSSession;
import com.amazon.sqs.javamessaging.acknowledge.Acknowledger;
import com.amazon.sqs.javamessaging.acknowledge.BulkSQSOperation;
import com.amazon.sqs.javamessaging.acknowledge.SQSMessageIdentifier;
import com.amazon.sqs.javamessaging.message.SQSMessage;
import jakarta.jms.JMSException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry;

public class RangedAcknowledger
extends BulkSQSOperation
implements Acknowledger {
    private static final Logger LOG = LoggerFactory.getLogger(RangedAcknowledger.class);
    private final AmazonSQSMessagingClientWrapper amazonSQSClient;
    private final SQSSession session;
    private final Queue<SQSMessageIdentifier> unAckMessages;

    public RangedAcknowledger(AmazonSQSMessagingClientWrapper amazonSQSClient, SQSSession session) {
        this.amazonSQSClient = amazonSQSClient;
        this.session = session;
        this.unAckMessages = new LinkedList<SQSMessageIdentifier>();
    }

    @Override
    public void acknowledge(SQSMessage message) throws JMSException {
        this.session.checkClosed();
        SQSMessageIdentifier ackMessage = SQSMessageIdentifier.fromSQSMessage(message);
        int indexOfMessage = this.indexOf(ackMessage);
        if (indexOfMessage == -1) {
            LOG.warn("SQSMessageID: " + message.getSQSMessageId() + " with SQSMessageReceiptHandle: " + message.getReceiptHandle() + " does not exist.");
        } else {
            this.bulkAction(this.getUnAckMessages(), indexOfMessage);
        }
    }

    private int indexOf(SQSMessageIdentifier findMessage) {
        int i = 0;
        for (SQSMessageIdentifier sqsMessageIdentifier : this.unAckMessages) {
            ++i;
            if (!sqsMessageIdentifier.equals(findMessage)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void notifyMessageReceived(SQSMessage message) throws JMSException {
        SQSMessageIdentifier messageIdentifier = SQSMessageIdentifier.fromSQSMessage(message);
        if (!this.unAckMessages.contains(messageIdentifier)) {
            this.unAckMessages.add(messageIdentifier);
        }
    }

    @Override
    public List<SQSMessageIdentifier> getUnAckMessages() {
        return new ArrayList<SQSMessageIdentifier>(this.unAckMessages);
    }

    @Override
    public void forgetUnAckMessages() {
        this.unAckMessages.clear();
    }

    @Override
    public void action(String queueUrl, List<String> receiptHandles) throws JMSException {
        if (receiptHandles == null || receiptHandles.isEmpty()) {
            return;
        }
        ArrayList<DeleteMessageBatchRequestEntry> deleteMessageBatchRequestEntries = new ArrayList<DeleteMessageBatchRequestEntry>();
        int batchId = 0;
        for (String receiptHandle : receiptHandles) {
            this.unAckMessages.poll();
            DeleteMessageBatchRequestEntry entry = (DeleteMessageBatchRequestEntry)DeleteMessageBatchRequestEntry.builder().id(Integer.toString(batchId)).receiptHandle(receiptHandle).build();
            deleteMessageBatchRequestEntries.add(entry);
            ++batchId;
        }
        DeleteMessageBatchRequest deleteMessageBatchRequest = (DeleteMessageBatchRequest)DeleteMessageBatchRequest.builder().queueUrl(queueUrl).entries(deleteMessageBatchRequestEntries).build();
        this.amazonSQSClient.deleteMessageBatch(deleteMessageBatchRequest);
    }
}

