/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import com.amazon.sqs.javamessaging.SQSExtendedClientConstants;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.payloadoffloading.PayloadS3Pointer;
import software.amazon.payloadoffloading.Util;

public class AmazonSQSExtendedClientUtil {
    private static final Log LOG = LogFactory.getLog(AmazonSQSExtendedClientUtil.class);
    public static final String LEGACY_RESERVED_ATTRIBUTE_NAME = "SQSLargePayloadSize";
    public static final List<String> RESERVED_ATTRIBUTE_NAMES = Arrays.asList("SQSLargePayloadSize", "ExtendedPayloadSize");

    public static void checkMessageAttributes(int payloadSizeThreshold, Map<String, MessageAttributeValue> messageAttributes) {
        int msgAttributesSize = AmazonSQSExtendedClientUtil.getMsgAttributesSize(messageAttributes);
        if (msgAttributesSize > payloadSizeThreshold) {
            String errorMessage = "Total size of Message attributes is " + msgAttributesSize + " bytes which is larger than the threshold of " + payloadSizeThreshold + " Bytes. Consider including the payload in the message body instead of message attributes.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        int messageAttributesNum = messageAttributes.size();
        if (messageAttributesNum > 9) {
            String errorMessage = "Number of message attributes [" + messageAttributesNum + "] exceeds the maximum allowed for large-payload messages [" + 9 + "].";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        Optional<String> largePayloadAttributeName = AmazonSQSExtendedClientUtil.getReservedAttributeNameIfPresent(messageAttributes);
        if (largePayloadAttributeName.isPresent()) {
            String errorMessage = "Message attribute name " + largePayloadAttributeName.get() + " is reserved for use by SQS extended client.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
    }

    public static Optional<String> getReservedAttributeNameIfPresent(Map<String, MessageAttributeValue> msgAttributes) {
        String reservedAttributeName = null;
        if (msgAttributes.containsKey("ExtendedPayloadSize")) {
            reservedAttributeName = "ExtendedPayloadSize";
        } else if (msgAttributes.containsKey(LEGACY_RESERVED_ATTRIBUTE_NAME)) {
            reservedAttributeName = LEGACY_RESERVED_ATTRIBUTE_NAME;
        }
        return Optional.ofNullable(reservedAttributeName);
    }

    public static String embedS3PointerInReceiptHandle(String receiptHandle, String pointer) {
        PayloadS3Pointer s3Pointer = PayloadS3Pointer.fromJson((String)pointer);
        String s3MsgBucketName = s3Pointer.getS3BucketName();
        String s3MsgKey = s3Pointer.getS3Key();
        return "-..s3BucketName..-" + s3MsgBucketName + "-..s3BucketName..-" + "-..s3Key..-" + s3MsgKey + "-..s3Key..-" + receiptHandle;
    }

    public static String getOrigReceiptHandle(String receiptHandle) {
        int secondOccurence = receiptHandle.indexOf("-..s3Key..-", receiptHandle.indexOf("-..s3Key..-") + 1);
        return receiptHandle.substring(secondOccurence + "-..s3Key..-".length());
    }

    public static boolean isS3ReceiptHandle(String receiptHandle) {
        return receiptHandle.contains("-..s3BucketName..-") && receiptHandle.contains("-..s3Key..-");
    }

    public static String getMessagePointerFromModifiedReceiptHandle(String receiptHandle) {
        String s3MsgBucketName = AmazonSQSExtendedClientUtil.getFromReceiptHandleByMarker(receiptHandle, "-..s3BucketName..-");
        String s3MsgKey = AmazonSQSExtendedClientUtil.getFromReceiptHandleByMarker(receiptHandle, "-..s3Key..-");
        PayloadS3Pointer payloadS3Pointer = new PayloadS3Pointer(s3MsgBucketName, s3MsgKey);
        return payloadS3Pointer.toJson();
    }

    public static boolean isLarge(int payloadSizeThreshold, SendMessageRequest sendMessageRequest) {
        long msgBodySize;
        int msgAttributesSize = AmazonSQSExtendedClientUtil.getMsgAttributesSize(sendMessageRequest.messageAttributes());
        long totalMsgSize = (long)msgAttributesSize + (msgBodySize = Util.getStringSizeInBytes((String)sendMessageRequest.messageBody()));
        return totalMsgSize > (long)payloadSizeThreshold;
    }

    public static boolean isLarge(int payloadSizeThreshold, SendMessageBatchRequestEntry batchEntry) {
        long msgBodySize;
        int msgAttributesSize = AmazonSQSExtendedClientUtil.getMsgAttributesSize(batchEntry.messageAttributes());
        long totalMsgSize = (long)msgAttributesSize + (msgBodySize = Util.getStringSizeInBytes((String)batchEntry.messageBody()));
        return totalMsgSize > (long)payloadSizeThreshold;
    }

    public static Map<String, MessageAttributeValue> updateMessageAttributePayloadSize(Map<String, MessageAttributeValue> messageAttributes, Long messageContentSize, boolean usesLegacyReservedAttributeName) {
        HashMap<String, MessageAttributeValue> updatedMessageAttributes = new HashMap<String, MessageAttributeValue>(messageAttributes);
        MessageAttributeValue.Builder messageAttributeValueBuilder = MessageAttributeValue.builder();
        messageAttributeValueBuilder.dataType("Number");
        messageAttributeValueBuilder.stringValue(messageContentSize.toString());
        MessageAttributeValue messageAttributeValue = (MessageAttributeValue)messageAttributeValueBuilder.build();
        if (!usesLegacyReservedAttributeName) {
            updatedMessageAttributes.put("ExtendedPayloadSize", messageAttributeValue);
        } else {
            updatedMessageAttributes.put(LEGACY_RESERVED_ATTRIBUTE_NAME, messageAttributeValue);
        }
        return updatedMessageAttributes;
    }

    public static <T extends AwsRequest.Builder> T appendUserAgent(T builder, String userAgentName, String userAgentVersion) {
        return (T)builder.overrideConfiguration(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().addApiName(ApiName.builder().name(userAgentName).version(userAgentVersion).build())).build());
    }

    private static String getFromReceiptHandleByMarker(String receiptHandle, String marker) {
        int firstOccurence = receiptHandle.indexOf(marker);
        int secondOccurence = receiptHandle.indexOf(marker, firstOccurence + 1);
        return receiptHandle.substring(firstOccurence + marker.length(), secondOccurence);
    }

    private static int getMsgAttributesSize(Map<String, MessageAttributeValue> msgAttributes) {
        int totalMsgAttributesSize = 0;
        for (Map.Entry<String, MessageAttributeValue> entry : msgAttributes.entrySet()) {
            SdkBytes binaryVal;
            String stringVal;
            totalMsgAttributesSize = (int)((long)totalMsgAttributesSize + Util.getStringSizeInBytes((String)entry.getKey()));
            MessageAttributeValue entryVal = entry.getValue();
            if (entryVal.dataType() != null) {
                totalMsgAttributesSize = (int)((long)totalMsgAttributesSize + Util.getStringSizeInBytes((String)entryVal.dataType()));
            }
            if ((stringVal = entryVal.stringValue()) != null) {
                totalMsgAttributesSize = (int)((long)totalMsgAttributesSize + Util.getStringSizeInBytes((String)entryVal.stringValue()));
            }
            if ((binaryVal = entryVal.binaryValue()) == null) continue;
            totalMsgAttributesSize += binaryVal.asByteArray().length;
        }
        return totalMsgAttributesSize;
    }

    public static String trimAndValidateS3KeyPrefix(String s3KeyPrefix) {
        String trimmedPrefix = StringUtils.trimToEmpty((String)s3KeyPrefix);
        if (trimmedPrefix.length() > 988) {
            String errorMessage = "The S3 key prefix length must not be greater than 988";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        if (trimmedPrefix.startsWith(".") || trimmedPrefix.startsWith("/")) {
            String errorMessage = "The S3 key prefix must not starts with '.' or '/'";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        if (trimmedPrefix.contains("..")) {
            String errorMessage = "The S3 key prefix must not contains the string '..'";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        if (SQSExtendedClientConstants.INVALID_S3_PREFIX_KEY_CHARACTERS_PATTERN.matcher(trimmedPrefix).find()) {
            String errorMessage = "The S3 key prefix contain invalid characters. The allowed characters are: letters, digits, '/', '_', '-', and '.'";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        return trimmedPrefix;
    }
}

