/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import com.amazon.sqs.javamessaging.AmazonSQSExtendedClientUtil;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.payloadoffloading.PayloadStorageAsyncConfiguration;
import software.amazon.payloadoffloading.ServerSideEncryptionStrategy;

@NotThreadSafe
public class ExtendedAsyncClientConfiguration
extends PayloadStorageAsyncConfiguration {
    private boolean cleanupS3Payload = true;
    private boolean useLegacyReservedAttributeName = true;
    private boolean ignorePayloadNotFound = false;
    private String s3KeyPrefix = "";

    public ExtendedAsyncClientConfiguration() {
        this.setPayloadSizeThreshold(262144);
    }

    public ExtendedAsyncClientConfiguration(ExtendedAsyncClientConfiguration other) {
        super((PayloadStorageAsyncConfiguration)other);
        this.cleanupS3Payload = other.doesCleanupS3Payload();
        this.useLegacyReservedAttributeName = other.usesLegacyReservedAttributeName();
        this.ignorePayloadNotFound = other.ignoresPayloadNotFound();
        this.s3KeyPrefix = other.s3KeyPrefix;
    }

    public void setPayloadSupportEnabled(S3AsyncClient s3Async, String s3BucketName, boolean cleanupS3Payload) {
        this.setPayloadSupportEnabled(s3Async, s3BucketName);
        this.cleanupS3Payload = cleanupS3Payload;
    }

    public ExtendedAsyncClientConfiguration withPayloadSupportEnabled(S3AsyncClient s3Async, String s3BucketName, boolean cleanupS3Payload) {
        this.setPayloadSupportEnabled(s3Async, s3BucketName, cleanupS3Payload);
        return this;
    }

    public ExtendedAsyncClientConfiguration withPayloadSupportEnabled(S3AsyncClient s3Async, String s3BucketName) {
        this.setPayloadSupportEnabled(s3Async, s3BucketName);
        return this;
    }

    public void setLegacyReservedAttributeNameDisabled() {
        this.useLegacyReservedAttributeName = false;
    }

    public ExtendedAsyncClientConfiguration withLegacyReservedAttributeNameDisabled() {
        this.setLegacyReservedAttributeNameDisabled();
        return this;
    }

    public void setIgnorePayloadNotFound(boolean ignorePayloadNotFound) {
        this.ignorePayloadNotFound = ignorePayloadNotFound;
    }

    public ExtendedAsyncClientConfiguration withIgnorePayloadNotFound(boolean ignorePayloadNotFound) {
        this.setIgnorePayloadNotFound(ignorePayloadNotFound);
        return this;
    }

    public void setS3KeyPrefix(String s3KeyPrefix) {
        this.s3KeyPrefix = AmazonSQSExtendedClientUtil.trimAndValidateS3KeyPrefix(s3KeyPrefix);
    }

    public ExtendedAsyncClientConfiguration withS3KeyPrefix(String s3KeyPrefix) {
        this.setS3KeyPrefix(s3KeyPrefix);
        return this;
    }

    public String getS3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public boolean doesCleanupS3Payload() {
        return this.cleanupS3Payload;
    }

    public boolean usesLegacyReservedAttributeName() {
        return this.useLegacyReservedAttributeName;
    }

    public boolean ignoresPayloadNotFound() {
        return this.ignorePayloadNotFound;
    }

    public ExtendedAsyncClientConfiguration withAlwaysThroughS3(boolean alwaysThroughS3) {
        this.setAlwaysThroughS3(alwaysThroughS3);
        return this;
    }

    public ExtendedAsyncClientConfiguration withObjectCannedACL(ObjectCannedACL objectCannedACL) {
        this.setObjectCannedACL(objectCannedACL);
        return this;
    }

    public ExtendedAsyncClientConfiguration withPayloadSizeThreshold(int payloadSizeThreshold) {
        this.setPayloadSizeThreshold(payloadSizeThreshold);
        return this;
    }

    public ExtendedAsyncClientConfiguration withPayloadSupportDisabled() {
        this.setPayloadSupportDisabled();
        return this;
    }

    public ExtendedAsyncClientConfiguration withServerSideEncryption(ServerSideEncryptionStrategy serverSideEncryption) {
        this.setServerSideEncryptionStrategy(serverSideEncryption);
        return this;
    }
}

