/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import com.amazon.sqs.javamessaging.AmazonSQSExtendedAsyncClientBase;
import com.amazon.sqs.javamessaging.AmazonSQSExtendedClientUtil;
import com.amazon.sqs.javamessaging.ExtendedAsyncClientConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResponse;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.PurgeQueueRequest;
import software.amazon.awssdk.services.sqs.model.PurgeQueueResponse;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.payloadoffloading.PayloadStoreAsync;
import software.amazon.payloadoffloading.S3AsyncDao;
import software.amazon.payloadoffloading.S3BackedPayloadStoreAsync;
import software.amazon.payloadoffloading.Util;

public class AmazonSQSExtendedAsyncClient
extends AmazonSQSExtendedAsyncClientBase
implements SqsAsyncClient {
    static final String USER_AGENT_NAME = AmazonSQSExtendedAsyncClient.class.getSimpleName();
    static final String USER_AGENT_VERSION = "2.21.21";
    private static final Log LOG = LogFactory.getLog(AmazonSQSExtendedAsyncClient.class);
    private ExtendedAsyncClientConfiguration clientConfiguration;
    private PayloadStoreAsync payloadStore;

    public AmazonSQSExtendedAsyncClient(SqsAsyncClient sqsClient) {
        this(sqsClient, new ExtendedAsyncClientConfiguration());
    }

    public AmazonSQSExtendedAsyncClient(SqsAsyncClient sqsClient, ExtendedAsyncClientConfiguration extendedClientConfig) {
        super(sqsClient);
        this.clientConfiguration = new ExtendedAsyncClientConfiguration(extendedClientConfig);
        S3AsyncDao s3Dao = new S3AsyncDao(this.clientConfiguration.getS3AsyncClient(), this.clientConfiguration.getServerSideEncryptionStrategy(), this.clientConfiguration.getObjectCannedACL());
        this.payloadStore = new S3BackedPayloadStoreAsync(s3Dao, this.clientConfiguration.getS3BucketName());
    }

    @Override
    public CompletableFuture<SendMessageResponse> sendMessage(SendMessageRequest sendMessageRequest) {
        if (sendMessageRequest == null) {
            String errorMessage = "sendMessageRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        SendMessageRequest.Builder sendMessageRequestBuilder = sendMessageRequest.toBuilder();
        sendMessageRequest = (SendMessageRequest)AmazonSQSExtendedAsyncClient.appendUserAgent(sendMessageRequestBuilder).build();
        if (!this.clientConfiguration.isPayloadSupportEnabled()) {
            return super.sendMessage(sendMessageRequest);
        }
        if (StringUtils.isEmpty((CharSequence)sendMessageRequest.messageBody())) {
            String errorMessage = "messageBody cannot be null or empty.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        AmazonSQSExtendedClientUtil.checkMessageAttributes(this.clientConfiguration.getPayloadSizeThreshold(), sendMessageRequest.messageAttributes());
        if (this.clientConfiguration.isAlwaysThroughS3() || AmazonSQSExtendedClientUtil.isLarge(this.clientConfiguration.getPayloadSizeThreshold(), sendMessageRequest)) {
            return this.storeMessageInS3(sendMessageRequest).thenCompose(modifiedRequest -> super.sendMessage((SendMessageRequest)modifiedRequest));
        }
        return super.sendMessage(sendMessageRequest);
    }

    @Override
    public CompletableFuture<ReceiveMessageResponse> receiveMessage(ReceiveMessageRequest receiveMessageRequest) {
        if (receiveMessageRequest == null) {
            String errorMessage = "receiveMessageRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        ReceiveMessageRequest.Builder receiveMessageRequestBuilder = receiveMessageRequest.toBuilder();
        AmazonSQSExtendedAsyncClient.appendUserAgent(receiveMessageRequestBuilder);
        if (!this.clientConfiguration.isPayloadSupportEnabled()) {
            return super.receiveMessage((ReceiveMessageRequest)receiveMessageRequestBuilder.build());
        }
        ArrayList<String> messageAttributeNames = new ArrayList<String>(receiveMessageRequest.messageAttributeNames());
        messageAttributeNames.removeAll(AmazonSQSExtendedClientUtil.RESERVED_ATTRIBUTE_NAMES);
        messageAttributeNames.addAll(AmazonSQSExtendedClientUtil.RESERVED_ATTRIBUTE_NAMES);
        receiveMessageRequestBuilder.messageAttributeNames(messageAttributeNames);
        receiveMessageRequest = (ReceiveMessageRequest)receiveMessageRequestBuilder.build();
        return ((CompletableFuture)super.receiveMessage(receiveMessageRequest).thenCompose(receiveMessageResponse -> {
            List messages = receiveMessageResponse.messages();
            if (messages.isEmpty()) {
                return CompletableFuture.completedFuture(messages);
            }
            ArrayList<CompletionStage> modifiedMessageFutures = new ArrayList<CompletionStage>(messages.size());
            for (Message message : messages) {
                Message.Builder messageBuilder = message.toBuilder();
                Optional<String> largePayloadAttributeName = AmazonSQSExtendedClientUtil.getReservedAttributeNameIfPresent(message.messageAttributes());
                if (!largePayloadAttributeName.isPresent()) {
                    modifiedMessageFutures.add(CompletableFuture.completedFuture((Message)messageBuilder.build()));
                    continue;
                }
                String largeMessagePointer = message.body().replace("com.amazon.sqs.javamessaging.MessageS3Pointer", "software.amazon.payloadoffloading.PayloadS3Pointer");
                modifiedMessageFutures.add(this.payloadStore.getOriginalPayload(largeMessagePointer).thenApply(originalPayload -> {
                    messageBuilder.body(originalPayload);
                    HashMap messageAttributes = new HashMap(message.messageAttributes());
                    messageAttributes.keySet().removeAll(AmazonSQSExtendedClientUtil.RESERVED_ATTRIBUTE_NAMES);
                    messageBuilder.messageAttributes(messageAttributes);
                    String modifiedReceiptHandle = AmazonSQSExtendedClientUtil.embedS3PointerInReceiptHandle(message.receiptHandle(), largeMessagePointer);
                    messageBuilder.receiptHandle(modifiedReceiptHandle);
                    return (Message)messageBuilder.build();
                }));
            }
            return CompletableFuture.allOf(modifiedMessageFutures.toArray(new CompletableFuture[modifiedMessageFutures.size()])).thenApply(v -> modifiedMessageFutures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
        })).thenApply(modifiedMessages -> {
            ReceiveMessageResponse.Builder receiveMessageResponseBuilder = ReceiveMessageResponse.builder();
            receiveMessageResponseBuilder.messages((Collection)modifiedMessages);
            return (ReceiveMessageResponse)receiveMessageResponseBuilder.build();
        });
    }

    @Override
    public CompletableFuture<DeleteMessageResponse> deleteMessage(DeleteMessageRequest deleteMessageRequest) {
        String receiptHandle;
        if (deleteMessageRequest == null) {
            String errorMessage = "deleteMessageRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        DeleteMessageRequest.Builder deleteMessageRequestBuilder = deleteMessageRequest.toBuilder();
        AmazonSQSExtendedAsyncClient.appendUserAgent(deleteMessageRequestBuilder);
        String origReceiptHandle = receiptHandle = deleteMessageRequest.receiptHandle();
        String messagePointer = null;
        if (this.clientConfiguration.isPayloadSupportEnabled() && AmazonSQSExtendedClientUtil.isS3ReceiptHandle(receiptHandle)) {
            origReceiptHandle = AmazonSQSExtendedClientUtil.getOrigReceiptHandle(receiptHandle);
            if (this.clientConfiguration.doesCleanupS3Payload()) {
                messagePointer = AmazonSQSExtendedClientUtil.getMessagePointerFromModifiedReceiptHandle(receiptHandle);
            }
        }
        deleteMessageRequestBuilder.receiptHandle(origReceiptHandle);
        if (messagePointer == null) {
            return super.deleteMessage((DeleteMessageRequest)deleteMessageRequestBuilder.build());
        }
        String messageToDeletePointer = messagePointer;
        return super.deleteMessage((DeleteMessageRequest)deleteMessageRequestBuilder.build()).thenCompose(deleteMessageResponse -> this.payloadStore.deleteOriginalPayload(messageToDeletePointer).thenApply(v -> deleteMessageResponse));
    }

    @Override
    public CompletableFuture<ChangeMessageVisibilityResponse> changeMessageVisibility(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) {
        ChangeMessageVisibilityRequest.Builder changeMessageVisibilityRequestBuilder = changeMessageVisibilityRequest.toBuilder();
        if (AmazonSQSExtendedClientUtil.isS3ReceiptHandle(changeMessageVisibilityRequest.receiptHandle())) {
            changeMessageVisibilityRequestBuilder.receiptHandle(AmazonSQSExtendedClientUtil.getOrigReceiptHandle(changeMessageVisibilityRequest.receiptHandle()));
        }
        return this.amazonSqsToBeExtended.changeMessageVisibility((ChangeMessageVisibilityRequest)changeMessageVisibilityRequestBuilder.build());
    }

    @Override
    public CompletableFuture<SendMessageBatchResponse> sendMessageBatch(SendMessageBatchRequest sendMessageBatchRequestIn) {
        if (sendMessageBatchRequestIn == null) {
            String errorMessage = "sendMessageBatchRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        SendMessageBatchRequest.Builder sendMessageBatchRequestBuilder = sendMessageBatchRequestIn.toBuilder();
        AmazonSQSExtendedAsyncClient.appendUserAgent(sendMessageBatchRequestBuilder);
        SendMessageBatchRequest sendMessageBatchRequest = (SendMessageBatchRequest)sendMessageBatchRequestBuilder.build();
        if (!this.clientConfiguration.isPayloadSupportEnabled()) {
            return super.sendMessageBatch(sendMessageBatchRequest);
        }
        ArrayList<CompletableFuture<SendMessageBatchRequestEntry>> batchEntryFutures = new ArrayList<CompletableFuture<SendMessageBatchRequestEntry>>(sendMessageBatchRequest.entries().size());
        boolean hasS3Entries = false;
        for (SendMessageBatchRequestEntry entry : sendMessageBatchRequest.entries()) {
            AmazonSQSExtendedClientUtil.checkMessageAttributes(this.clientConfiguration.getPayloadSizeThreshold(), entry.messageAttributes());
            if (this.clientConfiguration.isAlwaysThroughS3() || AmazonSQSExtendedClientUtil.isLarge(this.clientConfiguration.getPayloadSizeThreshold(), entry)) {
                batchEntryFutures.add(this.storeMessageInS3(entry));
                hasS3Entries = true;
                continue;
            }
            batchEntryFutures.add(CompletableFuture.completedFuture(entry));
        }
        if (!hasS3Entries) {
            return super.sendMessageBatch(sendMessageBatchRequest);
        }
        return ((CompletableFuture)CompletableFuture.allOf(batchEntryFutures.toArray(new CompletableFuture[batchEntryFutures.size()])).thenApply(v -> batchEntryFutures.stream().map(CompletableFuture::join).collect(Collectors.toList()))).thenCompose(batchEntries -> {
            SendMessageBatchRequest modifiedBatchRequest = (SendMessageBatchRequest)sendMessageBatchRequest.toBuilder().entries((Collection)batchEntries).build();
            return super.sendMessageBatch(modifiedBatchRequest);
        });
    }

    @Override
    public CompletableFuture<DeleteMessageBatchResponse> deleteMessageBatch(DeleteMessageBatchRequest deleteMessageBatchRequest) {
        if (deleteMessageBatchRequest == null) {
            String errorMessage = "deleteMessageBatchRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        DeleteMessageBatchRequest.Builder deleteMessageBatchRequestBuilder = deleteMessageBatchRequest.toBuilder();
        AmazonSQSExtendedAsyncClient.appendUserAgent(deleteMessageBatchRequestBuilder);
        if (!this.clientConfiguration.isPayloadSupportEnabled()) {
            return super.deleteMessageBatch(deleteMessageBatchRequest);
        }
        ArrayList<DeleteMessageBatchRequestEntry> entries = new ArrayList<DeleteMessageBatchRequestEntry>(deleteMessageBatchRequest.entries().size());
        for (DeleteMessageBatchRequestEntry entry : deleteMessageBatchRequest.entries()) {
            String receiptHandle;
            DeleteMessageBatchRequestEntry.Builder entryBuilder = entry.toBuilder();
            String origReceiptHandle = receiptHandle = entry.receiptHandle();
            if (AmazonSQSExtendedClientUtil.isS3ReceiptHandle(receiptHandle)) {
                origReceiptHandle = AmazonSQSExtendedClientUtil.getOrigReceiptHandle(receiptHandle);
                if (this.clientConfiguration.doesCleanupS3Payload()) {
                    String messagePointer = AmazonSQSExtendedClientUtil.getMessagePointerFromModifiedReceiptHandle(receiptHandle);
                    this.payloadStore.deleteOriginalPayload(messagePointer);
                }
            }
            entryBuilder.receiptHandle(origReceiptHandle);
            entries.add((DeleteMessageBatchRequestEntry)entryBuilder.build());
        }
        deleteMessageBatchRequestBuilder.entries(entries);
        return super.deleteMessageBatch((DeleteMessageBatchRequest)deleteMessageBatchRequestBuilder.build());
    }

    @Override
    public CompletableFuture<ChangeMessageVisibilityBatchResponse> changeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) {
        ArrayList<ChangeMessageVisibilityBatchRequestEntry> entries = new ArrayList<ChangeMessageVisibilityBatchRequestEntry>(changeMessageVisibilityBatchRequest.entries().size());
        for (ChangeMessageVisibilityBatchRequestEntry entry : changeMessageVisibilityBatchRequest.entries()) {
            ChangeMessageVisibilityBatchRequestEntry.Builder entryBuilder = entry.toBuilder();
            if (AmazonSQSExtendedClientUtil.isS3ReceiptHandle(entry.receiptHandle())) {
                entryBuilder.receiptHandle(AmazonSQSExtendedClientUtil.getOrigReceiptHandle(entry.receiptHandle()));
            }
            entries.add((ChangeMessageVisibilityBatchRequestEntry)entryBuilder.build());
        }
        return this.amazonSqsToBeExtended.changeMessageVisibilityBatch((ChangeMessageVisibilityBatchRequest)changeMessageVisibilityBatchRequest.toBuilder().entries(entries).build());
    }

    @Override
    public CompletableFuture<PurgeQueueResponse> purgeQueue(PurgeQueueRequest purgeQueueRequest) {
        LOG.warn((Object)"Calling purgeQueue deletes SQS messages without deleting their payload from S3.");
        if (purgeQueueRequest == null) {
            String errorMessage = "purgeQueueRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        PurgeQueueRequest.Builder purgeQueueRequestBuilder = purgeQueueRequest.toBuilder();
        AmazonSQSExtendedAsyncClient.appendUserAgent(purgeQueueRequestBuilder);
        return super.purgeQueue((PurgeQueueRequest)purgeQueueRequestBuilder.build());
    }

    private CompletableFuture<SendMessageBatchRequestEntry> storeMessageInS3(SendMessageBatchRequestEntry batchEntry) {
        String messageContentStr = batchEntry.messageBody();
        Long messageContentSize = Util.getStringSizeInBytes((String)messageContentStr);
        SendMessageBatchRequestEntry.Builder batchEntryBuilder = batchEntry.toBuilder();
        batchEntryBuilder.messageAttributes(AmazonSQSExtendedClientUtil.updateMessageAttributePayloadSize(batchEntry.messageAttributes(), messageContentSize, this.clientConfiguration.usesLegacyReservedAttributeName()));
        return this.storeOriginalPayload(messageContentStr).thenApply(largeMessagePointer -> {
            batchEntryBuilder.messageBody(largeMessagePointer);
            return (SendMessageBatchRequestEntry)batchEntryBuilder.build();
        });
    }

    private CompletableFuture<SendMessageRequest> storeMessageInS3(SendMessageRequest sendMessageRequest) {
        String messageContentStr = sendMessageRequest.messageBody();
        Long messageContentSize = Util.getStringSizeInBytes((String)messageContentStr);
        SendMessageRequest.Builder sendMessageRequestBuilder = sendMessageRequest.toBuilder();
        sendMessageRequestBuilder.messageAttributes(AmazonSQSExtendedClientUtil.updateMessageAttributePayloadSize(sendMessageRequest.messageAttributes(), messageContentSize, this.clientConfiguration.usesLegacyReservedAttributeName()));
        return this.payloadStore.storeOriginalPayload(messageContentStr).thenApply(largeMessagePointer -> {
            sendMessageRequestBuilder.messageBody(largeMessagePointer);
            return (SendMessageRequest)sendMessageRequestBuilder.build();
        });
    }

    private CompletableFuture<String> storeOriginalPayload(String messageContentStr) {
        String s3KeyPrefix = this.clientConfiguration.getS3KeyPrefix();
        if (StringUtils.isBlank((CharSequence)s3KeyPrefix)) {
            return this.payloadStore.storeOriginalPayload(messageContentStr);
        }
        return this.payloadStore.storeOriginalPayload(messageContentStr, s3KeyPrefix + UUID.randomUUID());
    }

    private static <T extends AwsRequest.Builder> T appendUserAgent(T builder) {
        return AmazonSQSExtendedClientUtil.appendUserAgent(builder, USER_AGENT_NAME, USER_AGENT_VERSION);
    }
}

