/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import com.amazon.sqs.javamessaging.AmazonSQSExtendedClientBase;
import com.amazon.sqs.javamessaging.ExtendedClientConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResponse;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.PurgeQueueRequest;
import software.amazon.awssdk.services.sqs.model.PurgeQueueResponse;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.payloadoffloading.PayloadS3Pointer;
import software.amazon.payloadoffloading.PayloadStore;
import software.amazon.payloadoffloading.S3BackedPayloadStore;
import software.amazon.payloadoffloading.S3Dao;
import software.amazon.payloadoffloading.Util;

public class AmazonSQSExtendedClient
extends AmazonSQSExtendedClientBase
implements SqsClient {
    static final String USER_AGENT_NAME = AmazonSQSExtendedClient.class.getSimpleName();
    static final String USER_AGENT_VERSION = "2.14.19";
    private static final Log LOG = LogFactory.getLog(AmazonSQSExtendedClient.class);
    static final String LEGACY_RESERVED_ATTRIBUTE_NAME = "SQSLargePayloadSize";
    static final List<String> RESERVED_ATTRIBUTE_NAMES = Arrays.asList("SQSLargePayloadSize", "ExtendedPayloadSize");
    private ExtendedClientConfiguration clientConfiguration;
    private PayloadStore payloadStore;

    public AmazonSQSExtendedClient(SqsClient sqsClient) {
        this(sqsClient, new ExtendedClientConfiguration());
    }

    public AmazonSQSExtendedClient(SqsClient sqsClient, ExtendedClientConfiguration extendedClientConfig) {
        super(sqsClient);
        this.clientConfiguration = new ExtendedClientConfiguration(extendedClientConfig);
        S3Dao s3Dao = new S3Dao(this.clientConfiguration.getS3Client(), this.clientConfiguration.getServerSideEncryptionStrategy(), this.clientConfiguration.getObjectCannedACL());
        this.payloadStore = new S3BackedPayloadStore(s3Dao, this.clientConfiguration.getS3BucketName());
    }

    @Override
    public SendMessageResponse sendMessage(SendMessageRequest sendMessageRequest) {
        if (sendMessageRequest == null) {
            String errorMessage = "sendMessageRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        SendMessageRequest.Builder sendMessageRequestBuilder = sendMessageRequest.toBuilder();
        sendMessageRequest = (SendMessageRequest)AmazonSQSExtendedClient.appendUserAgent(sendMessageRequestBuilder).build();
        if (!this.clientConfiguration.isPayloadSupportEnabled()) {
            return super.sendMessage(sendMessageRequest);
        }
        if (StringUtils.isEmpty((CharSequence)sendMessageRequest.messageBody())) {
            String errorMessage = "messageBody cannot be null or empty.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        this.checkMessageAttributes(sendMessageRequest.messageAttributes());
        if (this.clientConfiguration.isAlwaysThroughS3() || this.isLarge(sendMessageRequest)) {
            sendMessageRequest = this.storeMessageInS3(sendMessageRequest);
        }
        return super.sendMessage(sendMessageRequest);
    }

    @Override
    public ReceiveMessageResponse receiveMessage(ReceiveMessageRequest receiveMessageRequest) {
        if (receiveMessageRequest == null) {
            String errorMessage = "receiveMessageRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        ReceiveMessageRequest.Builder receiveMessageRequestBuilder = receiveMessageRequest.toBuilder();
        AmazonSQSExtendedClient.appendUserAgent(receiveMessageRequestBuilder);
        if (!this.clientConfiguration.isPayloadSupportEnabled()) {
            return super.receiveMessage((ReceiveMessageRequest)receiveMessageRequestBuilder.build());
        }
        ArrayList<String> messageAttributeNames = new ArrayList<String>(receiveMessageRequest.messageAttributeNames());
        messageAttributeNames.removeAll(RESERVED_ATTRIBUTE_NAMES);
        messageAttributeNames.addAll(RESERVED_ATTRIBUTE_NAMES);
        receiveMessageRequestBuilder.attributeNamesWithStrings(messageAttributeNames);
        receiveMessageRequest = (ReceiveMessageRequest)receiveMessageRequestBuilder.build();
        ReceiveMessageResponse receiveMessageResponse = super.receiveMessage(receiveMessageRequest);
        ReceiveMessageResponse.Builder receiveMessageResponseBuilder = receiveMessageResponse.toBuilder();
        List messages = receiveMessageResponse.messages();
        ArrayList<Object> modifiedMessages = new ArrayList<Object>(messages.size());
        for (Message message : messages) {
            Message.Builder messageBuilder = message.toBuilder();
            Optional<String> largePayloadAttributeName = this.getReservedAttributeNameIfPresent(message.messageAttributes());
            if (largePayloadAttributeName.isPresent()) {
                String largeMessagePointer = message.body();
                largeMessagePointer = largeMessagePointer.replace("com.amazon.sqs.javamessaging.MessageS3Pointer", "software.amazon.payloadoffloading.PayloadS3Pointer");
                messageBuilder.body(this.payloadStore.getOriginalPayload(largeMessagePointer));
                HashMap messageAttributes = new HashMap(message.messageAttributes());
                messageAttributes.keySet().removeAll(RESERVED_ATTRIBUTE_NAMES);
                messageBuilder.messageAttributes(messageAttributes);
                String modifiedReceiptHandle = this.embedS3PointerInReceiptHandle(message.receiptHandle(), largeMessagePointer);
                messageBuilder.receiptHandle(modifiedReceiptHandle);
            }
            modifiedMessages.add(messageBuilder.build());
        }
        receiveMessageResponseBuilder.messages(modifiedMessages);
        return (ReceiveMessageResponse)receiveMessageResponseBuilder.build();
    }

    @Override
    public DeleteMessageResponse deleteMessage(DeleteMessageRequest deleteMessageRequest) {
        String receiptHandle;
        if (deleteMessageRequest == null) {
            String errorMessage = "deleteMessageRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        DeleteMessageRequest.Builder deleteMessageRequestBuilder = deleteMessageRequest.toBuilder();
        AmazonSQSExtendedClient.appendUserAgent(deleteMessageRequestBuilder);
        if (!this.clientConfiguration.isPayloadSupportEnabled()) {
            return super.deleteMessage((DeleteMessageRequest)deleteMessageRequestBuilder.build());
        }
        String origReceiptHandle = receiptHandle = deleteMessageRequest.receiptHandle();
        if (this.isS3ReceiptHandle(receiptHandle)) {
            origReceiptHandle = this.getOrigReceiptHandle(receiptHandle);
            if (this.clientConfiguration.doesCleanupS3Payload()) {
                String messagePointer = this.getMessagePointerFromModifiedReceiptHandle(receiptHandle);
                this.payloadStore.deleteOriginalPayload(messagePointer);
            }
        }
        deleteMessageRequestBuilder.receiptHandle(origReceiptHandle);
        return super.deleteMessage((DeleteMessageRequest)deleteMessageRequestBuilder.build());
    }

    @Override
    public ChangeMessageVisibilityResponse changeMessageVisibility(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) throws AwsServiceException, SdkClientException {
        ChangeMessageVisibilityRequest.Builder changeMessageVisibilityRequestBuilder = changeMessageVisibilityRequest.toBuilder();
        if (this.isS3ReceiptHandle(changeMessageVisibilityRequest.receiptHandle())) {
            changeMessageVisibilityRequestBuilder.receiptHandle(this.getOrigReceiptHandle(changeMessageVisibilityRequest.receiptHandle()));
        }
        return this.amazonSqsToBeExtended.changeMessageVisibility((ChangeMessageVisibilityRequest)changeMessageVisibilityRequestBuilder.build());
    }

    @Override
    public SendMessageBatchResponse sendMessageBatch(SendMessageBatchRequest sendMessageBatchRequest) {
        if (sendMessageBatchRequest == null) {
            String errorMessage = "sendMessageBatchRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        SendMessageBatchRequest.Builder sendMessageBatchRequestBuilder = sendMessageBatchRequest.toBuilder();
        AmazonSQSExtendedClient.appendUserAgent(sendMessageBatchRequestBuilder);
        sendMessageBatchRequest = (SendMessageBatchRequest)sendMessageBatchRequestBuilder.build();
        if (!this.clientConfiguration.isPayloadSupportEnabled()) {
            return super.sendMessageBatch(sendMessageBatchRequest);
        }
        ArrayList<SendMessageBatchRequestEntry> batchEntries = new ArrayList<SendMessageBatchRequestEntry>(sendMessageBatchRequest.entries().size());
        for (SendMessageBatchRequestEntry entry : sendMessageBatchRequest.entries()) {
            this.checkMessageAttributes(entry.messageAttributes());
            if (this.clientConfiguration.isAlwaysThroughS3() || this.isLarge(entry)) {
                entry = this.storeMessageInS3(entry);
            }
            batchEntries.add(entry);
        }
        return super.sendMessageBatch(sendMessageBatchRequest);
    }

    @Override
    public DeleteMessageBatchResponse deleteMessageBatch(DeleteMessageBatchRequest deleteMessageBatchRequest) {
        if (deleteMessageBatchRequest == null) {
            String errorMessage = "deleteMessageBatchRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        DeleteMessageBatchRequest.Builder deleteMessageBatchRequestBuilder = deleteMessageBatchRequest.toBuilder();
        AmazonSQSExtendedClient.appendUserAgent(deleteMessageBatchRequestBuilder);
        if (!this.clientConfiguration.isPayloadSupportEnabled()) {
            return super.deleteMessageBatch(deleteMessageBatchRequest);
        }
        ArrayList<Object> entries = new ArrayList<Object>(deleteMessageBatchRequest.entries().size());
        for (DeleteMessageBatchRequestEntry entry : deleteMessageBatchRequest.entries()) {
            String receiptHandle;
            DeleteMessageBatchRequestEntry.Builder entryBuilder = entry.toBuilder();
            String origReceiptHandle = receiptHandle = entry.receiptHandle();
            if (this.isS3ReceiptHandle(receiptHandle)) {
                origReceiptHandle = this.getOrigReceiptHandle(receiptHandle);
                if (this.clientConfiguration.doesCleanupS3Payload()) {
                    String messagePointer = this.getMessagePointerFromModifiedReceiptHandle(receiptHandle);
                    this.payloadStore.deleteOriginalPayload(messagePointer);
                }
            }
            entryBuilder.receiptHandle(origReceiptHandle);
            entries.add(entryBuilder.build());
        }
        deleteMessageBatchRequestBuilder.entries(entries);
        return super.deleteMessageBatch((DeleteMessageBatchRequest)deleteMessageBatchRequestBuilder.build());
    }

    @Override
    public ChangeMessageVisibilityBatchResponse changeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) throws AwsServiceException, SdkClientException {
        ArrayList<Object> entries = new ArrayList<Object>(changeMessageVisibilityBatchRequest.entries().size());
        for (ChangeMessageVisibilityBatchRequestEntry entry : changeMessageVisibilityBatchRequest.entries()) {
            ChangeMessageVisibilityBatchRequestEntry.Builder entryBuilder = entry.toBuilder();
            if (this.isS3ReceiptHandle(entry.receiptHandle())) {
                entryBuilder.receiptHandle(this.getOrigReceiptHandle(entry.receiptHandle()));
            }
            entries.add(entryBuilder.build());
        }
        return this.amazonSqsToBeExtended.changeMessageVisibilityBatch((ChangeMessageVisibilityBatchRequest)changeMessageVisibilityBatchRequest.toBuilder().entries(entries).build());
    }

    @Override
    public PurgeQueueResponse purgeQueue(PurgeQueueRequest purgeQueueRequest) throws AwsServiceException, SdkClientException {
        LOG.warn((Object)"Calling purgeQueue deletes SQS messages without deleting their payload from S3.");
        if (purgeQueueRequest == null) {
            String errorMessage = "purgeQueueRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        PurgeQueueRequest.Builder purgeQueueRequestBuilder = purgeQueueRequest.toBuilder();
        AmazonSQSExtendedClient.appendUserAgent(purgeQueueRequestBuilder);
        return super.purgeQueue((PurgeQueueRequest)purgeQueueRequestBuilder.build());
    }

    private void checkMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
        int msgAttributesSize = this.getMsgAttributesSize(messageAttributes);
        if (msgAttributesSize > this.clientConfiguration.getPayloadSizeThreshold()) {
            String errorMessage = "Total size of Message attributes is " + msgAttributesSize + " bytes which is larger than the threshold of " + this.clientConfiguration.getPayloadSizeThreshold() + " Bytes. Consider including the payload in the message body instead of message attributes.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        int messageAttributesNum = messageAttributes.size();
        if (messageAttributesNum > 9) {
            String errorMessage = "Number of message attributes [" + messageAttributesNum + "] exceeds the maximum allowed for large-payload messages [" + 9 + "].";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        Optional<String> largePayloadAttributeName = this.getReservedAttributeNameIfPresent(messageAttributes);
        if (largePayloadAttributeName.isPresent()) {
            String errorMessage = "Message attribute name " + largePayloadAttributeName.get() + " is reserved for use by SQS extended client.";
            LOG.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
    }

    private String embedS3PointerInReceiptHandle(String receiptHandle, String pointer) {
        PayloadS3Pointer s3Pointer = PayloadS3Pointer.fromJson((String)pointer);
        String s3MsgBucketName = s3Pointer.getS3BucketName();
        String s3MsgKey = s3Pointer.getS3Key();
        String modifiedReceiptHandle = "-..s3BucketName..-" + s3MsgBucketName + "-..s3BucketName..-" + "-..s3Key..-" + s3MsgKey + "-..s3Key..-" + receiptHandle;
        return modifiedReceiptHandle;
    }

    private String getOrigReceiptHandle(String receiptHandle) {
        int secondOccurence = receiptHandle.indexOf("-..s3Key..-", receiptHandle.indexOf("-..s3Key..-") + 1);
        return receiptHandle.substring(secondOccurence + "-..s3Key..-".length());
    }

    private String getFromReceiptHandleByMarker(String receiptHandle, String marker) {
        int firstOccurence = receiptHandle.indexOf(marker);
        int secondOccurence = receiptHandle.indexOf(marker, firstOccurence + 1);
        return receiptHandle.substring(firstOccurence + marker.length(), secondOccurence);
    }

    private boolean isS3ReceiptHandle(String receiptHandle) {
        return receiptHandle.contains("-..s3BucketName..-") && receiptHandle.contains("-..s3Key..-");
    }

    private String getMessagePointerFromModifiedReceiptHandle(String receiptHandle) {
        String s3MsgBucketName = this.getFromReceiptHandleByMarker(receiptHandle, "-..s3BucketName..-");
        String s3MsgKey = this.getFromReceiptHandleByMarker(receiptHandle, "-..s3Key..-");
        PayloadS3Pointer payloadS3Pointer = new PayloadS3Pointer(s3MsgBucketName, s3MsgKey);
        return payloadS3Pointer.toJson();
    }

    private boolean isLarge(SendMessageRequest sendMessageRequest) {
        long msgBodySize;
        int msgAttributesSize = this.getMsgAttributesSize(sendMessageRequest.messageAttributes());
        long totalMsgSize = (long)msgAttributesSize + (msgBodySize = Util.getStringSizeInBytes((String)sendMessageRequest.messageBody()));
        return totalMsgSize > (long)this.clientConfiguration.getPayloadSizeThreshold();
    }

    private boolean isLarge(SendMessageBatchRequestEntry batchEntry) {
        long msgBodySize;
        int msgAttributesSize = this.getMsgAttributesSize(batchEntry.messageAttributes());
        long totalMsgSize = (long)msgAttributesSize + (msgBodySize = Util.getStringSizeInBytes((String)batchEntry.messageBody()));
        return totalMsgSize > (long)this.clientConfiguration.getPayloadSizeThreshold();
    }

    private Optional<String> getReservedAttributeNameIfPresent(Map<String, MessageAttributeValue> msgAttributes) {
        String reservedAttributeName = null;
        if (msgAttributes.containsKey("ExtendedPayloadSize")) {
            reservedAttributeName = "ExtendedPayloadSize";
        } else if (msgAttributes.containsKey(LEGACY_RESERVED_ATTRIBUTE_NAME)) {
            reservedAttributeName = LEGACY_RESERVED_ATTRIBUTE_NAME;
        }
        return Optional.ofNullable(reservedAttributeName);
    }

    private int getMsgAttributesSize(Map<String, MessageAttributeValue> msgAttributes) {
        int totalMsgAttributesSize = 0;
        for (Map.Entry<String, MessageAttributeValue> entry : msgAttributes.entrySet()) {
            SdkBytes binaryVal;
            String stringVal;
            totalMsgAttributesSize = (int)((long)totalMsgAttributesSize + Util.getStringSizeInBytes((String)entry.getKey()));
            MessageAttributeValue entryVal = entry.getValue();
            if (entryVal.dataType() != null) {
                totalMsgAttributesSize = (int)((long)totalMsgAttributesSize + Util.getStringSizeInBytes((String)entryVal.dataType()));
            }
            if ((stringVal = entryVal.stringValue()) != null) {
                totalMsgAttributesSize = (int)((long)totalMsgAttributesSize + Util.getStringSizeInBytes((String)entryVal.stringValue()));
            }
            if ((binaryVal = entryVal.binaryValue()) == null) continue;
            totalMsgAttributesSize += binaryVal.asByteArray().length;
        }
        return totalMsgAttributesSize;
    }

    private SendMessageBatchRequestEntry storeMessageInS3(SendMessageBatchRequestEntry batchEntry) {
        String messageContentStr = batchEntry.messageBody();
        Long messageContentSize = Util.getStringSizeInBytes((String)messageContentStr);
        SendMessageBatchRequestEntry.Builder batchEntryBuilder = batchEntry.toBuilder();
        batchEntryBuilder.messageAttributes(this.updateMessageAttributePayloadSize(batchEntry.messageAttributes(), messageContentSize));
        String largeMessagePointer = this.payloadStore.storeOriginalPayload(messageContentStr);
        batchEntryBuilder.messageBody(largeMessagePointer);
        return (SendMessageBatchRequestEntry)batchEntryBuilder.build();
    }

    private SendMessageRequest storeMessageInS3(SendMessageRequest sendMessageRequest) {
        String messageContentStr = sendMessageRequest.messageBody();
        Long messageContentSize = Util.getStringSizeInBytes((String)messageContentStr);
        SendMessageRequest.Builder sendMessageRequestBuilder = sendMessageRequest.toBuilder();
        sendMessageRequestBuilder.messageAttributes(this.updateMessageAttributePayloadSize(sendMessageRequest.messageAttributes(), messageContentSize));
        String largeMessagePointer = this.payloadStore.storeOriginalPayload(messageContentStr);
        sendMessageRequestBuilder.messageBody(largeMessagePointer);
        return (SendMessageRequest)sendMessageRequestBuilder.build();
    }

    private Map<String, MessageAttributeValue> updateMessageAttributePayloadSize(Map<String, MessageAttributeValue> messageAttributes, Long messageContentSize) {
        HashMap<String, MessageAttributeValue> updatedMessageAttributes = new HashMap<String, MessageAttributeValue>(messageAttributes);
        MessageAttributeValue.Builder messageAttributeValueBuilder = MessageAttributeValue.builder();
        messageAttributeValueBuilder.dataType("Number");
        messageAttributeValueBuilder.stringValue(messageContentSize.toString());
        MessageAttributeValue messageAttributeValue = (MessageAttributeValue)messageAttributeValueBuilder.build();
        if (!this.clientConfiguration.usesLegacyReservedAttributeName()) {
            updatedMessageAttributes.put("ExtendedPayloadSize", messageAttributeValue);
        } else {
            updatedMessageAttributes.put(LEGACY_RESERVED_ATTRIBUTE_NAME, messageAttributeValue);
        }
        return updatedMessageAttributes;
    }

    private static <T extends AwsRequest.Builder> T appendUserAgent(T builder) {
        return (T)builder.overrideConfiguration(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().addApiName(ApiName.builder().name(USER_AGENT_NAME).version(USER_AGENT_VERSION).build())).build());
    }
}

