/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.redshift.Driver;
import com.amazon.redshift.core.BaseConnection;
import com.amazon.redshift.core.CachedQuery;
import com.amazon.redshift.core.ParameterList;
import com.amazon.redshift.core.Query;
import com.amazon.redshift.core.TypeInfo;
import com.amazon.redshift.core.v3.BatchedQuery;
import com.amazon.redshift.jdbc.BooleanTypeUtil;
import com.amazon.redshift.jdbc.PreferQueryMode;
import com.amazon.redshift.jdbc.PrimitiveArraySupport;
import com.amazon.redshift.jdbc.RedshiftArray;
import com.amazon.redshift.jdbc.RedshiftConnectionImpl;
import com.amazon.redshift.jdbc.RedshiftParameterMetaData;
import com.amazon.redshift.jdbc.RedshiftResultSet;
import com.amazon.redshift.jdbc.RedshiftSQLXML;
import com.amazon.redshift.jdbc.RedshiftStatementImpl;
import com.amazon.redshift.jdbc.ResultWrapper;
import com.amazon.redshift.jdbc.TimestampUtils;
import com.amazon.redshift.largeobject.LargeObject;
import com.amazon.redshift.largeobject.LargeObjectManager;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.util.ByteConverter;
import com.amazon.redshift.util.ByteStreamWriter;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.HStoreConverter;
import com.amazon.redshift.util.ReaderInputStream;
import com.amazon.redshift.util.RedshiftBinaryObject;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftObject;
import com.amazon.redshift.util.RedshiftState;
import com.amazon.redshift.util.RedshiftTime;
import com.amazon.redshift.util.RedshiftTimestamp;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;

public class RedshiftPreparedStatement
extends RedshiftStatementImpl
implements PreparedStatement {
    protected final CachedQuery preparedQuery;
    protected final ParameterList preparedParameters;
    private TimeZone defaultTimeZone;
    protected boolean enableGeneratedName;

    RedshiftPreparedStatement(RedshiftConnectionImpl connection, String sql, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        this(connection, connection.borrowQuery(sql), rsType, rsConcurrency, rsHoldability);
    }

    RedshiftPreparedStatement(RedshiftConnectionImpl connection, CachedQuery query, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(connection, rsType, rsConcurrency, rsHoldability);
        this.preparedQuery = query;
        this.preparedParameters = this.preparedQuery.query.createParameterList();
        this.setPoolable(true);
        this.enableGeneratedName = connection.getGeneratedName();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new RedshiftException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), RedshiftState.WRONG_OBJECT_TYPE);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, new Object[0]);
        }
        if (!this.executeWithFlags(0)) {
            throw new RedshiftException(GT.tr("No results were returned by the query.", new Object[0]), RedshiftState.NO_DATA);
        }
        ResultSet rs = this.getSingleResultSet();
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rs);
        }
        return rs;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new RedshiftException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), RedshiftState.WRONG_OBJECT_TYPE);
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, new Object[0]);
        }
        if (this.autoGeneratedKeys == 1) {
            this.wantsGeneratedKeysOnce = true;
        }
        this.executeWithFlags(4);
        this.checkNoResultUpdate();
        int rc = this.getUpdateCount();
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rc);
        }
        return rc;
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, new Object[0]);
        }
        if (this.autoGeneratedKeys == 1) {
            this.wantsGeneratedKeysOnce = true;
        }
        this.executeWithFlags(4);
        this.checkNoResultUpdate();
        long rc = this.getLargeUpdateCount();
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rc);
        }
        return rc;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new RedshiftException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), RedshiftState.WRONG_OBJECT_TYPE);
    }

    @Override
    public boolean execute() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, new Object[0]);
        }
        boolean rc = this.executeWithFlags(0);
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rc);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeWithFlags(int flags) throws SQLException {
        try {
            this.checkClosed();
            if (this.connection.getPreferQueryMode() == PreferQueryMode.SIMPLE) {
                flags |= 0x400;
            }
            this.execute(this.preparedQuery, this.preparedParameters, flags);
            RedshiftPreparedStatement redshiftPreparedStatement = this;
            synchronized (redshiftPreparedStatement) {
                this.checkClosed();
                boolean bl = this.result != null && this.result.getResultSet() != null;
                return bl;
            }
        }
        finally {
            this.defaultTimeZone = null;
        }
    }

    @Override
    protected boolean isOneShotQuery(CachedQuery cachedQuery) {
        if (cachedQuery == null) {
            cachedQuery = this.preparedQuery;
        }
        boolean rc = super.isOneShotQuery(cachedQuery);
        return this.enableGeneratedName ? false : rc;
    }

    @Override
    public void closeImpl() throws SQLException {
        if (this.preparedQuery != null) {
            ((RedshiftConnectionImpl)this.connection).releaseQuery(this.preparedQuery);
            super.closeImpl();
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        int oid;
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, parameterIndex, sqlType);
        }
        this.checkClosed();
        if (parameterIndex < 1 || parameterIndex > this.preparedParameters.getParameterCount()) {
            throw new RedshiftException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", parameterIndex, this.preparedParameters.getParameterCount()), RedshiftState.INVALID_PARAMETER_VALUE);
        }
        switch (sqlType) {
            case 2009: {
                oid = 142;
                break;
            }
            case 4: {
                oid = 23;
                break;
            }
            case -6: 
            case 5: {
                oid = 21;
                break;
            }
            case -5: {
                oid = 20;
                break;
            }
            case 7: {
                oid = 700;
                break;
            }
            case 6: 
            case 8: {
                oid = 701;
                break;
            }
            case 2: 
            case 3: {
                oid = 1700;
                break;
            }
            case 1: {
                oid = 1042;
                break;
            }
            case -1: 
            case 12: {
                oid = this.connection.getStringVarcharFlag() ? 1043 : 0;
                break;
            }
            case 91: {
                oid = 1082;
                break;
            }
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                oid = 0;
                break;
            }
            case -7: 
            case 16: {
                oid = 16;
                break;
            }
            case -3: 
            case -2: 
            case 2004: {
                oid = 17;
                break;
            }
            case -4: {
                oid = 6551;
                break;
            }
            case 2005: {
                oid = 1043;
                break;
            }
            case 0: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: {
                oid = 0;
                break;
            }
            default: {
                throw new RedshiftException(GT.tr("Unknown Types value.", new Object[0]), RedshiftState.INVALID_PARAMETER_TYPE);
            }
        }
        this.preparedParameters.setNull(parameterIndex, oid);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, parameterIndex, x);
        }
        this.checkClosed();
        this.bindLiteral(parameterIndex, x ? "TRUE" : "FALSE", 16);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, parameterIndex, x);
        }
        this.setShort(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, parameterIndex, x);
        }
        this.checkClosed();
        if (this.connection.binaryTransferSend(21)) {
            byte[] val = new byte[2];
            ByteConverter.int2(val, 0, x);
            this.bindBytes(parameterIndex, val, 21);
            return;
        }
        this.bindLiteral(parameterIndex, Integer.toString(x), 21);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, parameterIndex, x);
        }
        this.checkClosed();
        if (this.connection.binaryTransferSend(23)) {
            byte[] val = new byte[4];
            ByteConverter.int4(val, 0, x);
            this.bindBytes(parameterIndex, val, 23);
            return;
        }
        this.bindLiteral(parameterIndex, Integer.toString(x), 23);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, parameterIndex, x);
        }
        this.checkClosed();
        if (this.connection.binaryTransferSend(20)) {
            byte[] val = new byte[8];
            ByteConverter.int8(val, 0, x);
            this.bindBytes(parameterIndex, val, 20);
            return;
        }
        this.bindLiteral(parameterIndex, Long.toString(x), 20);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, parameterIndex, Float.valueOf(x));
        }
        this.checkClosed();
        if (this.connection.binaryTransferSend(700)) {
            byte[] val = new byte[4];
            ByteConverter.float4(val, 0, x);
            this.bindBytes(parameterIndex, val, 700);
            return;
        }
        this.bindLiteral(parameterIndex, Float.toString(x), 701);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, parameterIndex, x);
        }
        this.checkClosed();
        if (this.connection.binaryTransferSend(701)) {
            byte[] val = new byte[8];
            ByteConverter.float8(val, 0, x);
            this.bindBytes(parameterIndex, val, 701);
            return;
        }
        this.bindLiteral(parameterIndex, Double.toString(x), 701);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, parameterIndex, x);
        }
        this.setNumber(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, parameterIndex, x);
        }
        this.checkClosed();
        this.setString(parameterIndex, x, this.getStringType());
    }

    private int getStringType() {
        return this.connection.getStringVarcharFlag() ? 1043 : 0;
    }

    protected void setString(int parameterIndex, String x, int oid) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.preparedParameters.setNull(parameterIndex, oid);
        } else {
            this.bindString(parameterIndex, x, oid);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, parameterIndex, x);
        }
        this.checkClosed();
        if (null == x) {
            this.setNull(parameterIndex, -3);
            return;
        }
        byte[] copy = new byte[x.length];
        System.arraycopy(x, 0, copy, 0, x.length);
        this.preparedParameters.setBytea(parameterIndex, copy, 0, x.length);
    }

    private void setByteStreamWriter(int parameterIndex, ByteStreamWriter x) throws SQLException {
        this.preparedParameters.setBytea(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, parameterIndex, x);
        }
        this.setDate(parameterIndex, x, null);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, parameterIndex, x);
        }
        this.setTime(parameterIndex, x, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, parameterIndex, x);
        }
        this.setTimestamp(parameterIndex, x, null);
    }

    private void setCharacterStreamPost71(int parameterIndex, InputStream x, int length, String encoding) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 12);
            return;
        }
        if (length < 0) {
            throw new RedshiftException(GT.tr("Invalid stream length {0}.", length), RedshiftState.INVALID_PARAMETER_VALUE);
        }
        try {
            int n;
            InputStreamReader inStream = new InputStreamReader(x, encoding);
            char[] chars = new char[length];
            int charsRead = 0;
            while ((n = inStream.read(chars, charsRead, length - charsRead)) != -1 && (charsRead += n) != length) {
            }
            this.setString(parameterIndex, new String(chars, 0, charsRead), 1043);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RedshiftException(GT.tr("The JVM claims not to support the {0} encoding.", encoding), RedshiftState.UNEXPECTED_ERROR, (Throwable)uee);
        }
        catch (IOException ioe) {
            throw new RedshiftException(GT.tr("Provided InputStream failed.", new Object[0]), RedshiftState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        this.setCharacterStreamPost71(parameterIndex, x, length, "ASCII");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, parameterIndex, x, length);
        }
        this.checkClosed();
        this.setCharacterStreamPost71(parameterIndex, x, length, "UTF-8");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -3);
            return;
        }
        if (length < 0) {
            throw new RedshiftException(GT.tr("Invalid stream length {0}.", length), RedshiftState.INVALID_PARAMETER_VALUE);
        }
        this.preparedParameters.setBytea(parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, new Object[0]);
        }
        this.preparedParameters.clear();
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, new Object[0]);
        }
    }

    private void setRedshiftObject(int parameterIndex, RedshiftObject x) throws SQLException {
        String typename = x.getType();
        int oid = this.connection.getTypeInfo().getRSType(typename);
        if (oid == 0) {
            throw new RedshiftException(GT.tr("Unknown type {0}.", typename), RedshiftState.INVALID_PARAMETER_TYPE);
        }
        if (x instanceof RedshiftBinaryObject && this.connection.binaryTransferSend(oid)) {
            RedshiftBinaryObject binObj = (RedshiftBinaryObject)((Object)x);
            byte[] data = new byte[binObj.lengthInBytes()];
            binObj.toBytes(data, 0);
            this.bindBytes(parameterIndex, data, oid);
        } else {
            this.setString(parameterIndex, x.getValue(), oid);
        }
    }

    private void setMap(int parameterIndex, Map<?, ?> x) throws SQLException {
        int oid = this.connection.getTypeInfo().getRSType("hstore");
        if (oid == 0) {
            throw new RedshiftException(GT.tr("No hstore extension installed.", new Object[0]), RedshiftState.INVALID_PARAMETER_TYPE);
        }
        if (this.connection.binaryTransferSend(oid)) {
            byte[] data = HStoreConverter.toBytes(x, this.connection.getEncoding());
            this.bindBytes(parameterIndex, data, oid);
        } else {
            this.setString(parameterIndex, HStoreConverter.toString(x), oid);
        }
    }

    private void setNumber(int parameterIndex, Number x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 3);
        } else if (x instanceof BigInteger) {
            this.setString(parameterIndex, x.toString());
        } else {
            this.bindLiteral(parameterIndex, x.toString(), 1700);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object in, int targetSqlType, int scale) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, parameterIndex, in, targetSqlType, scale);
        }
        this.checkClosed();
        if (in == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        switch (targetSqlType) {
            case 2009: {
                if (in instanceof SQLXML) {
                    this.setSQLXML(parameterIndex, (SQLXML)in);
                    break;
                }
                this.setSQLXML(parameterIndex, new RedshiftSQLXML(this.connection, in.toString()));
                break;
            }
            case 4: {
                this.setInt(parameterIndex, RedshiftPreparedStatement.castToInt(in));
                break;
            }
            case -6: 
            case 5: {
                this.setShort(parameterIndex, RedshiftPreparedStatement.castToShort(in));
                break;
            }
            case -5: {
                this.setLong(parameterIndex, RedshiftPreparedStatement.castToLong(in));
                break;
            }
            case 7: {
                this.setFloat(parameterIndex, RedshiftPreparedStatement.castToFloat(in));
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(parameterIndex, RedshiftPreparedStatement.castToDouble(in));
                break;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(parameterIndex, RedshiftPreparedStatement.castToBigDecimal(in, scale));
                break;
            }
            case 1: {
                this.setString(parameterIndex, RedshiftPreparedStatement.castToString(in), 1042);
                break;
            }
            case 12: {
                this.setString(parameterIndex, RedshiftPreparedStatement.castToString(in), this.getStringType());
                break;
            }
            case -1: {
                if (in instanceof InputStream) {
                    this.preparedParameters.setText(parameterIndex, (InputStream)in);
                    break;
                }
                this.setString(parameterIndex, RedshiftPreparedStatement.castToString(in), this.getStringType());
                break;
            }
            case 91: {
                Date tmpd;
                if (in instanceof Date) {
                    this.setDate(parameterIndex, (Date)in);
                    break;
                }
                if (in instanceof java.util.Date) {
                    tmpd = new Date(((java.util.Date)in).getTime());
                } else {
                    if (in instanceof LocalDate) {
                        this.setDate(parameterIndex, (LocalDate)in);
                        break;
                    }
                    tmpd = this.connection.getTimestampUtils().toDate(this.getDefaultCalendar(), in.toString());
                }
                this.setDate(parameterIndex, tmpd);
                break;
            }
            case 92: {
                Time tmpt;
                if (in instanceof Time) {
                    this.setTime(parameterIndex, (Time)in);
                    break;
                }
                if (in instanceof java.util.Date) {
                    tmpt = new Time(((java.util.Date)in).getTime());
                } else {
                    if (in instanceof LocalTime) {
                        this.setTime(parameterIndex, (LocalTime)in);
                        break;
                    }
                    tmpt = this.connection.getTimestampUtils().toTime(this.getDefaultCalendar(), in.toString());
                }
                this.setTime(parameterIndex, tmpt);
                break;
            }
            case 93: {
                Timestamp tmpts;
                if (in instanceof RedshiftTimestamp) {
                    this.setObject(parameterIndex, in);
                    break;
                }
                if (in instanceof Timestamp) {
                    this.setTimestamp(parameterIndex, (Timestamp)in);
                    break;
                }
                if (in instanceof java.util.Date) {
                    tmpts = new Timestamp(((java.util.Date)in).getTime());
                } else {
                    if (in instanceof LocalDateTime) {
                        this.setTimestamp(parameterIndex, (LocalDateTime)in);
                        break;
                    }
                    tmpts = this.connection.getTimestampUtils().toTimestamp(this.getDefaultCalendar(), in.toString());
                }
                this.setTimestamp(parameterIndex, tmpts);
                break;
            }
            case 2014: {
                if (in instanceof OffsetDateTime) {
                    this.setTimestamp(parameterIndex, (OffsetDateTime)in);
                    break;
                }
                if (in instanceof RedshiftTimestamp) {
                    this.setObject(parameterIndex, in);
                    break;
                }
                throw new RedshiftException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.TIMESTAMP_WITH_TIMEZONE"), RedshiftState.INVALID_PARAMETER_TYPE);
            }
            case -7: 
            case 16: {
                this.setBoolean(parameterIndex, BooleanTypeUtil.castToBoolean(in));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setObject(parameterIndex, in);
                break;
            }
            case 2004: {
                if (in instanceof Blob) {
                    this.setBlob(parameterIndex, (Blob)in);
                    break;
                }
                if (in instanceof InputStream) {
                    long oid = this.createBlob(parameterIndex, (InputStream)in, -1L);
                    this.setLong(parameterIndex, oid);
                    break;
                }
                throw new RedshiftException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.BLOB"), RedshiftState.INVALID_PARAMETER_TYPE);
            }
            case 2005: {
                if (in instanceof Clob) {
                    this.setClob(parameterIndex, (Clob)in);
                    break;
                }
                throw new RedshiftException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.CLOB"), RedshiftState.INVALID_PARAMETER_TYPE);
            }
            case 2003: {
                if (in instanceof Array) {
                    this.setArray(parameterIndex, (Array)in);
                    break;
                }
                if (PrimitiveArraySupport.isSupportedPrimitiveArray(in)) {
                    this.setPrimitiveArray(parameterIndex, in);
                    break;
                }
                throw new RedshiftException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.ARRAY"), RedshiftState.INVALID_PARAMETER_TYPE);
            }
            case 2001: {
                this.bindString(parameterIndex, in.toString(), 0);
                break;
            }
            case 1111: {
                if (in instanceof RedshiftObject) {
                    this.setRedshiftObject(parameterIndex, (RedshiftObject)in);
                    break;
                }
                if (in instanceof Map) {
                    this.setMap(parameterIndex, (Map)in);
                    break;
                }
                this.bindString(parameterIndex, in.toString(), 0);
                break;
            }
            default: {
                throw new RedshiftException(GT.tr("Unsupported Types value: {0}", targetSqlType), RedshiftState.INVALID_PARAMETER_TYPE);
            }
        }
    }

    private <A> void setPrimitiveArray(int parameterIndex, A in) throws SQLException {
        PrimitiveArraySupport<A> arrayToString = PrimitiveArraySupport.getArraySupport(in);
        TypeInfo typeInfo = this.connection.getTypeInfo();
        int oid = arrayToString.getDefaultArrayTypeOid(typeInfo);
        if (arrayToString.supportBinaryRepresentation() && this.connection.getPreferQueryMode() != PreferQueryMode.SIMPLE) {
            this.bindBytes(parameterIndex, arrayToString.toBinaryRepresentation(this.connection, in), oid);
        } else {
            char delim = typeInfo.getArrayDelimiter(oid);
            this.setString(parameterIndex, arrayToString.toArrayString(delim, in), oid);
        }
    }

    private static String asString(Clob in) throws SQLException {
        return in.getSubString(1L, (int)in.length());
    }

    private static int castToInt(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Integer.parseInt((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).intValue();
            }
            if (in instanceof java.util.Date) {
                return (int)((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1 : 0;
            }
            if (in instanceof Clob) {
                return Integer.parseInt(RedshiftPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Integer.parseInt(in.toString());
            }
        }
        catch (Exception e) {
            throw RedshiftPreparedStatement.cannotCastException(in.getClass().getName(), "int", e);
        }
        throw RedshiftPreparedStatement.cannotCastException(in.getClass().getName(), "int");
    }

    private static short castToShort(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Short.parseShort((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).shortValue();
            }
            if (in instanceof java.util.Date) {
                return (short)((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? (short)1 : 0;
            }
            if (in instanceof Clob) {
                return Short.parseShort(RedshiftPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Short.parseShort(in.toString());
            }
        }
        catch (Exception e) {
            throw RedshiftPreparedStatement.cannotCastException(in.getClass().getName(), "short", e);
        }
        throw RedshiftPreparedStatement.cannotCastException(in.getClass().getName(), "short");
    }

    private static long castToLong(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Long.parseLong((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).longValue();
            }
            if (in instanceof java.util.Date) {
                return ((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1L : 0L;
            }
            if (in instanceof Clob) {
                return Long.parseLong(RedshiftPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Long.parseLong(in.toString());
            }
        }
        catch (Exception e) {
            throw RedshiftPreparedStatement.cannotCastException(in.getClass().getName(), "long", e);
        }
        throw RedshiftPreparedStatement.cannotCastException(in.getClass().getName(), "long");
    }

    private static float castToFloat(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Float.parseFloat((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).floatValue();
            }
            if (in instanceof java.util.Date) {
                return ((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1.0f : 0.0f;
            }
            if (in instanceof Clob) {
                return Float.parseFloat(RedshiftPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Float.parseFloat(in.toString());
            }
        }
        catch (Exception e) {
            throw RedshiftPreparedStatement.cannotCastException(in.getClass().getName(), "float", e);
        }
        throw RedshiftPreparedStatement.cannotCastException(in.getClass().getName(), "float");
    }

    private static double castToDouble(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Double.parseDouble((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).doubleValue();
            }
            if (in instanceof java.util.Date) {
                return ((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1.0 : 0.0;
            }
            if (in instanceof Clob) {
                return Double.parseDouble(RedshiftPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Double.parseDouble(in.toString());
            }
        }
        catch (Exception e) {
            throw RedshiftPreparedStatement.cannotCastException(in.getClass().getName(), "double", e);
        }
        throw RedshiftPreparedStatement.cannotCastException(in.getClass().getName(), "double");
    }

    private static BigDecimal castToBigDecimal(Object in, int scale) throws SQLException {
        try {
            BigDecimal rc = null;
            if (in instanceof String) {
                rc = new BigDecimal((String)in);
            } else if (in instanceof BigDecimal) {
                rc = (BigDecimal)in;
            } else if (in instanceof BigInteger) {
                rc = new BigDecimal((BigInteger)in);
            } else if (in instanceof Long || in instanceof Integer || in instanceof Short || in instanceof Byte) {
                rc = BigDecimal.valueOf(((Number)in).longValue());
            } else if (in instanceof Double || in instanceof Float) {
                rc = BigDecimal.valueOf(((Number)in).doubleValue());
            } else if (in instanceof java.util.Date) {
                rc = BigDecimal.valueOf(((java.util.Date)in).getTime());
            } else if (in instanceof Boolean) {
                rc = (Boolean)in != false ? BigDecimal.ONE : BigDecimal.ZERO;
            } else if (in instanceof Clob) {
                rc = new BigDecimal(RedshiftPreparedStatement.asString((Clob)in));
            } else if (in instanceof Character) {
                rc = new BigDecimal(new char[]{((Character)in).charValue()});
            }
            if (rc != null) {
                if (scale >= 0) {
                    rc = rc.setScale(scale, RoundingMode.HALF_UP);
                }
                return rc;
            }
        }
        catch (Exception e) {
            throw RedshiftPreparedStatement.cannotCastException(in.getClass().getName(), "BigDecimal", e);
        }
        throw RedshiftPreparedStatement.cannotCastException(in.getClass().getName(), "BigDecimal");
    }

    private static String castToString(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return (String)in;
            }
            if (in instanceof Clob) {
                return RedshiftPreparedStatement.asString((Clob)in);
            }
            return in.toString();
        }
        catch (Exception e) {
            throw RedshiftPreparedStatement.cannotCastException(in.getClass().getName(), "String", e);
        }
    }

    private static RedshiftException cannotCastException(String fromType, String toType) {
        return RedshiftPreparedStatement.cannotCastException(fromType, toType, null);
    }

    private static RedshiftException cannotCastException(String fromType, String toType, Exception cause) {
        return new RedshiftException(GT.tr("Cannot convert an instance of {0} to type {1}", fromType, toType), RedshiftState.INVALID_PARAMETER_TYPE, (Throwable)cause);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, parameterIndex, x, targetSqlType);
        }
        this.setObject(parameterIndex, x, targetSqlType, -1);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, parameterIndex, x);
        }
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 1111);
        } else if (x instanceof SQLXML) {
            this.setSQLXML(parameterIndex, (SQLXML)x);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof ByteStreamWriter) {
            this.setByteStreamWriter(parameterIndex, (ByteStreamWriter)x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
        } else if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
        } else if (x instanceof Array) {
            this.setArray(parameterIndex, (Array)x);
        } else if (x instanceof RedshiftObject) {
            this.setRedshiftObject(parameterIndex, (RedshiftObject)x);
        } else if (x instanceof Character) {
            this.setString(parameterIndex, ((Character)x).toString());
        } else if (x instanceof LocalDate) {
            this.setDate(parameterIndex, (LocalDate)x);
        } else if (x instanceof LocalTime) {
            this.setTime(parameterIndex, (LocalTime)x);
        } else if (x instanceof LocalDateTime) {
            this.setTimestamp(parameterIndex, (LocalDateTime)x);
        } else if (x instanceof OffsetDateTime) {
            this.setTimestamp(parameterIndex, (OffsetDateTime)x);
        } else if (x instanceof Map) {
            this.setMap(parameterIndex, (Map)x);
        } else if (x instanceof Number) {
            this.setNumber(parameterIndex, (Number)x);
        } else if (PrimitiveArraySupport.isSupportedPrimitiveArray(x)) {
            this.setPrimitiveArray(parameterIndex, x);
        } else {
            throw new RedshiftException(GT.tr("Can''t infer the SQL type to use for an instance of {0}. Use setObject() with an explicit Types value to specify the type to use.", x.getClass().getName()), RedshiftState.INVALID_PARAMETER_TYPE);
        }
    }

    public String toString() {
        if (this.preparedQuery == null) {
            return super.toString();
        }
        return this.preparedQuery.query.toString(this.preparedParameters);
    }

    protected void bindLiteral(int paramIndex, String s, int oid) throws SQLException {
        this.preparedParameters.setLiteralParameter(paramIndex, s, oid);
    }

    protected void bindBytes(int paramIndex, byte[] b, int oid) throws SQLException {
        this.preparedParameters.setBinaryParameter(paramIndex, b, oid);
    }

    private void bindString(int paramIndex, String s, int oid) throws SQLException {
        this.preparedParameters.setStringParameter(paramIndex, s, oid);
    }

    @Override
    public boolean isUseServerPrepare() {
        return this.preparedQuery != null && this.mPrepareThreshold != 0 && this.preparedQuery.getExecuteCount() + 1 >= this.mPrepareThreshold;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkClosed();
        throw new RedshiftException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), RedshiftState.WRONG_OBJECT_TYPE);
    }

    @Override
    public void addBatch() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, new Object[0]);
        }
        this.checkClosed();
        if (this.batchStatements == null) {
            this.batchStatements = new ArrayList();
            this.batchParameters = new ArrayList();
        }
        this.batchParameters.add(this.preparedParameters.copy());
        Query query = this.preparedQuery.query;
        if (!(query instanceof BatchedQuery) || this.batchStatements.isEmpty()) {
            this.batchStatements.add(query);
        }
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, new Object[0]);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, new Object[0]);
        }
        this.checkClosed();
        ResultSet rs = this.getResultSet();
        if (rs == null || ((RedshiftResultSet)rs).isResultSetClosed()) {
            int flags = 49;
            RedshiftStatementImpl.StatementResultHandler handler = new RedshiftStatementImpl.StatementResultHandler(this, this);
            this.connection.getQueryExecutor().execute(this.preparedQuery.query, this.preparedParameters, handler, 0, 0, flags);
            ResultWrapper wrapper = handler.getResults();
            if (wrapper != null) {
                this.firstUnclosedResult = wrapper;
                rs = wrapper.getResultSet();
            }
            handler.setStatementStateIdleFromInQuery();
        }
        ResultSetMetaData rc = rs != null ? rs.getMetaData() : null;
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rc);
        }
        return rc;
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        RedshiftArray arr;
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, i, x);
        }
        this.checkClosed();
        if (null == x) {
            this.setNull(i, 2003);
            return;
        }
        String typename = x.getBaseTypeName();
        int oid = this.connection.getTypeInfo().getRSArrayType(typename);
        if (oid == 0) {
            throw new RedshiftException(GT.tr("Unknown type {0}.", typename), RedshiftState.INVALID_PARAMETER_TYPE);
        }
        if (x instanceof RedshiftArray && (arr = (RedshiftArray)x).isBinary()) {
            this.bindBytes(i, arr.toBytes(), oid);
            return;
        }
        this.setString(i, x.toString(), oid);
    }

    protected long createBlob(int i, InputStream inputStream, long length) throws SQLException {
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        long oid = lom.createLO();
        LargeObject lob = lom.open(oid);
        OutputStream outputStream = lob.getOutputStream();
        byte[] buf = new byte[4096];
        try {
            long remaining = length > 0L ? length : Long.MAX_VALUE;
            int numRead = inputStream.read(buf, 0, length > 0L && remaining < (long)buf.length ? (int)remaining : buf.length);
            while (numRead != -1 && remaining > 0L) {
                outputStream.write(buf, 0, numRead);
                numRead = inputStream.read(buf, 0, length > 0L && remaining < (long)buf.length ? (int)(remaining -= (long)numRead) : buf.length);
            }
        }
        catch (IOException se) {
            throw new RedshiftException(GT.tr("Unexpected error writing large object to database.", new Object[0]), RedshiftState.UNEXPECTED_ERROR, (Throwable)se);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
        return oid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(i, 2004);
            return;
        }
        InputStream inStream = x.getBinaryStream();
        try {
            long oid = this.createBlob(i, inStream, x.length());
            this.setLong(i, oid);
        }
        finally {
            try {
                inStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private String readerToString(Reader value, int maxLength) throws SQLException {
        try {
            int bufferSize = Math.min(maxLength, 1024);
            StringBuilder v = new StringBuilder(bufferSize);
            char[] buf = new char[bufferSize];
            int nRead = 0;
            while (nRead > -1 && v.length() < maxLength) {
                nRead = value.read(buf, 0, Math.min(bufferSize, maxLength - v.length()));
                if (nRead <= 0) continue;
                v.append(buf, 0, nRead);
            }
            return v.toString();
        }
        catch (IOException ioe) {
            throw new RedshiftException(GT.tr("Provided Reader failed.", new Object[0]), RedshiftState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public void setCharacterStream(int i, Reader x, int length) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, i, x, length);
        }
        this.checkClosed();
        if (x == null) {
            this.setNull(i, 12);
            return;
        }
        if (length < 0) {
            throw new RedshiftException(GT.tr("Invalid stream length {0}.", length), RedshiftState.INVALID_PARAMETER_VALUE);
        }
        this.setString(i, this.readerToString(x, length));
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(i, 2005);
            return;
        }
        Reader inStream = x.getCharacterStream();
        int length = (int)x.length();
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        long oid = lom.createLO();
        LargeObject lob = lom.open(oid);
        Charset connectionCharset = Charset.forName(this.connection.getEncoding().name());
        OutputStream los = lob.getOutputStream();
        OutputStreamWriter lw = new OutputStreamWriter(los, connectionCharset);
        try {
            int c = inStream.read();
            for (int p = 0; c > -1 && p < length; ++p) {
                ((Writer)lw).write(c);
                c = inStream.read();
            }
            ((Writer)lw).close();
        }
        catch (IOException se) {
            throw new RedshiftException(GT.tr("Unexpected error writing large object to database.", new Object[0]), RedshiftState.UNEXPECTED_ERROR, (Throwable)se);
        }
        this.setLong(i, oid);
    }

    @Override
    public void setNull(int parameterIndex, int t, String typeName) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, parameterIndex, t, typeName);
        }
        if (typeName == null) {
            this.setNull(parameterIndex, t);
            return;
        }
        this.checkClosed();
        TypeInfo typeInfo = this.connection.getTypeInfo();
        int oid = typeInfo.getRSType(typeName);
        this.preparedParameters.setNull(parameterIndex, oid);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setRef(int,Ref)");
    }

    @Override
    public void setDate(int i, Date d, Calendar cal) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, i, d, cal);
        }
        this.checkClosed();
        if (d == null) {
            this.setNull(i, 91);
            return;
        }
        if (this.connection.binaryTransferSend(1082)) {
            byte[] val = new byte[4];
            TimeZone tz = cal != null ? cal.getTimeZone() : null;
            this.connection.getTimestampUtils().toBinDate(tz, val, d);
            this.preparedParameters.setBinaryParameter(i, val, 1082);
            return;
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, d), 0);
    }

    @Override
    public void setTime(int i, Time t, Calendar cal) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, i, t, cal);
        }
        this.checkClosed();
        if (t == null) {
            this.setNull(i, 92);
            return;
        }
        int oid = 0;
        if (t instanceof RedshiftTime) {
            RedshiftTime rsTime = (RedshiftTime)t;
            if (rsTime.getCalendar() == null) {
                oid = 1083;
            } else {
                oid = 1266;
                cal = rsTime.getCalendar();
            }
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, t), oid);
    }

    @Override
    public void setTimestamp(int i, Timestamp t, Calendar cal) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, i, t, cal);
        }
        this.checkClosed();
        if (t == null) {
            this.setNull(i, 93);
            return;
        }
        int oid = 0;
        if (t instanceof RedshiftTimestamp) {
            RedshiftTimestamp rsTimestamp = (RedshiftTimestamp)t;
            if (rsTimestamp.getCalendar() == null) {
                oid = 1114;
            } else {
                oid = 1184;
                cal = rsTimestamp.getCalendar();
            }
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, t), oid);
    }

    private void setDate(int i, LocalDate localDate) throws SQLException {
        int oid = 1082;
        this.bindString(i, this.connection.getTimestampUtils().toString(localDate), oid);
    }

    private void setTime(int i, LocalTime localTime) throws SQLException {
        int oid = 1083;
        this.bindString(i, this.connection.getTimestampUtils().toString(localTime), oid);
    }

    private void setTimestamp(int i, LocalDateTime localDateTime) throws SQLException {
        int oid = 1114;
        this.bindString(i, this.connection.getTimestampUtils().toString(localDateTime), oid);
    }

    private void setTimestamp(int i, OffsetDateTime offsetDateTime) throws SQLException {
        int oid = 1184;
        this.bindString(i, this.connection.getTimestampUtils().toString(offsetDateTime), oid);
    }

    public ParameterMetaData createParameterMetaData(BaseConnection conn, int[] oids) throws SQLException {
        return new RedshiftParameterMetaData(conn, oids);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject");
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setRowId(int, RowId)");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNString(int, String)");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(int, Reader, long)");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(int, Reader)");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(int, Reader, long)");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader value) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, parameterIndex, value);
        }
        if (this.connection.getPreferQueryMode() == PreferQueryMode.SIMPLE) {
            String s = value != null ? this.readerToString(value, Integer.MAX_VALUE) : null;
            this.setString(parameterIndex, s);
            return;
        }
        ReaderInputStream is = value != null ? new ReaderInputStream(value) : null;
        this.setObject(parameterIndex, (Object)is, -1);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new RedshiftException(GT.tr("Object is too large to send over the protocol.", new Object[0]), RedshiftState.NUMERIC_CONSTANT_OUT_OF_RANGE);
        }
        this.preparedParameters.setBytea(parameterIndex, value, (int)length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value) throws SQLException {
        this.preparedParameters.setBytea(parameterIndex, value);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(int, InputStream, long)");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(int, InputStream)");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNClob(int, NClob)");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setClob(int, Reader, long)");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setClob(int, Reader)");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkClosed();
        if (inputStream == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        if (length < 0L) {
            throw new RedshiftException(GT.tr("Invalid stream length {0}.", length), RedshiftState.INVALID_PARAMETER_VALUE);
        }
        long oid = this.createBlob(parameterIndex, inputStream, length);
        this.setLong(parameterIndex, oid);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkClosed();
        if (inputStream == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        long oid = this.createBlob(parameterIndex, inputStream, -1L);
        this.setLong(parameterIndex, oid);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNClob(int, Reader, long)");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNClob(int, Reader)");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        String stringValue;
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, parameterIndex, xmlObject);
        }
        this.checkClosed();
        String string = stringValue = xmlObject == null ? null : xmlObject.getString();
        if (stringValue == null) {
            this.setNull(parameterIndex, 2009);
        } else {
            this.setString(parameterIndex, stringValue, 142);
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setURL(int,URL)");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            if (this.batchParameters != null && this.batchParameters.size() > 1 && this.mPrepareThreshold > 0) {
                this.preparedQuery.increaseExecuteCount(this.mPrepareThreshold);
            }
            int[] nArray = super.executeBatch();
            return nArray;
        }
        finally {
            this.defaultTimeZone = null;
        }
    }

    private Calendar getDefaultCalendar() {
        TimestampUtils timestampUtils = this.connection.getTimestampUtils();
        if (timestampUtils.hasFastDefaultTimeZone()) {
            return timestampUtils.getSharedCalendar(null);
        }
        Calendar sharedCalendar = timestampUtils.getSharedCalendar(this.defaultTimeZone);
        if (this.defaultTimeZone == null) {
            this.defaultTimeZone = sharedCalendar.getTimeZone();
        }
        return sharedCalendar;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(true, new Object[0]);
        }
        int flags = 49;
        RedshiftStatementImpl.StatementResultHandler handler = new RedshiftStatementImpl.StatementResultHandler(this, this);
        this.connection.getQueryExecutor().execute(this.preparedQuery.query, this.preparedParameters, handler, 0, 0, flags);
        int[] oids = this.preparedParameters.getTypeOIDs();
        ParameterMetaData rc = oids != null ? this.createParameterMetaData(this.connection, oids) : null;
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logFunction(false, rc);
        }
        return rc;
    }

    @Override
    protected void transformQueriesAndParameters() throws SQLException {
        if (this.batchParameters.size() <= 1 || !(this.preparedQuery.query instanceof BatchedQuery)) {
            return;
        }
        BatchedQuery originalQuery = (BatchedQuery)this.preparedQuery.query;
        int bindCount = originalQuery.getBindCount();
        int highestBlockCount = ((RedshiftConnectionImpl)this.connection).getReWriteBatchedInsertsSize();
        int maxValueBlocks = bindCount == 0 ? 1024 : Integer.highestOneBit(Math.min(Math.max(1, 32766 / bindCount), highestBlockCount));
        int unprocessedBatchCount = this.batchParameters.size();
        int fullValueBlocksCount = unprocessedBatchCount / maxValueBlocks;
        int partialValueBlocksCount = Integer.bitCount(unprocessedBatchCount % maxValueBlocks);
        int count = fullValueBlocksCount + partialValueBlocksCount;
        ArrayList<BatchedQuery> newBatchStatements = new ArrayList<BatchedQuery>(count);
        ArrayList<ParameterList> newBatchParameters = new ArrayList<ParameterList>(count);
        int offset = 0;
        for (int i = 0; i < count; ++i) {
            int valueBlock = unprocessedBatchCount >= maxValueBlocks ? maxValueBlocks : Integer.highestOneBit(unprocessedBatchCount);
            BatchedQuery bq = originalQuery.deriveForMultiBatch(valueBlock, highestBlockCount, this.connection.getLogger());
            ParameterList newPl = bq.createParameterList();
            for (int j = 0; j < valueBlock; ++j) {
                ParameterList pl = (ParameterList)this.batchParameters.get(offset++);
                newPl.appendAll(pl);
            }
            newBatchStatements.add(bq);
            newBatchParameters.add(newPl);
            unprocessedBatchCount -= valueBlock;
        }
        this.batchStatements = newBatchStatements;
        this.batchParameters = newBatchParameters;
    }
}

