/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.core.Field;
import com.amazon.redshift.core.Query;
import com.amazon.redshift.core.ResultCursor;
import com.amazon.redshift.core.ResultHandler;
import com.amazon.redshift.core.Tuple;
import com.amazon.redshift.core.v3.RedshiftRowsBlockingQueue;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;

public class ResultHandlerBase
implements ResultHandler {
    private SQLException firstException;
    private SQLException lastException;
    private SQLWarning firstWarning;
    private SQLWarning lastWarning;

    @Override
    public void handleResultRows(Query fromQuery, Field[] fields, List<Tuple> tuples, ResultCursor cursor, RedshiftRowsBlockingQueue<Tuple> queueTuples, int[] rowCount, Thread ringBufferThread) {
    }

    @Override
    public void handleCommandStatus(String status, long updateCount, long insertOID) {
    }

    @Override
    public void secureProgress() {
    }

    @Override
    public void handleWarning(SQLWarning warning) {
        if (this.firstWarning == null) {
            this.firstWarning = this.lastWarning = warning;
            return;
        }
        this.lastWarning.setNextException(warning);
        this.lastWarning = warning;
    }

    @Override
    public void handleError(SQLException error) {
        if (this.firstException == null) {
            this.firstException = this.lastException = error;
            return;
        }
        this.lastException.setNextException(error);
        this.lastException = error;
    }

    @Override
    public void handleCompletion() throws SQLException {
        if (this.firstException != null) {
            throw this.firstException;
        }
    }

    @Override
    public SQLException getException() {
        return this.firstException;
    }

    @Override
    public SQLWarning getWarning() {
        return this.firstWarning;
    }

    @Override
    public void setStatementStateIdleFromInQuery() {
    }

    @Override
    public void setStatementStateInQueryFromIdle() {
    }

    @Override
    public boolean wantsScrollableResultSet() {
        return false;
    }
}

